# -*- coding: utf-8 -*-
"""
Created on Sat Mar 18 12:20:09 2023

@author: lmveldman
"""

import os
import sys
import inspect

### CHANGING TO CORRECT DIRECTORY
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
grandparentdir = os.path.dirname(parentdir)
sys.path.insert(0, grandparentdir) 

from data_analysis_functions import *
from scipy.ndimage.filters import gaussian_filter1d

###############################
####### RAW DATA ##############
###############################

colors = 'RdBu_r'
x='Probe delay Tau2 (sec)'
y='Lock-In Y (V)'
npts = 600
listfiles = GenList([325,324,323,322,312,311,310,309,308,313,314,315,316,317,318,319,320,321],'../data/AWG_PP_{}.dat')

# Convert lockin to number of electron per pulse
# Parameters for conversion
lockinfreq = 270 # frequency of the lockin (Hz)
lockinsens = 0.100 # lockin sensitivity (V)
nbprobepulse = 6172# number of probe pulses
gain = 1e11 # gain of the current amplifier (I/V)
qel = 1.602*10**-19 # charge of an electron in Coulomb

raw_data = []
c = []
for i,file in enumerate(listfiles):
    # Read files
    data, header = ReadFile_PP(file)
    currentstpt = round(float(header[1][12])*1e12,2)
    biasstpt = round(float(header[1][11])*1000)
    t = data[x][0:npts]*1e9 + 4 #define start of the evolution at 4ns to take into account the second pump pulse
    trace = data[y][0:npts]
    trace = LI_to_electrons(trace,lockinsens,gain,lockinfreq,nbprobepulse,qel)
    raw_data.append(trace)
    c.append(currentstpt)


###################################
########### PLOTTING ##############
###################################
fig, ax = plt.subplots(1,1,figsize=(6.4*2/1.5,4.8*2/3))

### PLOT RAW DATA
im = ax.pcolor(t,c,raw_data,cmap=colors)
ax.set_ylabel('Setpopint current (pA)')
ax.set_xlabel('Time evolution (ns)')
cbar = fig.colorbar(im,ax=ax)
cbar.set_label('$\Delta I$ (electrons per pulse)')
plt.savefig('../plots/fig_3.pdf')
plt.show()