# -*- coding: utf-8 -*-
"""
Created on Thu Feb 23 14:44:06 2023

@author: lmveldman
"""


import os
import sys
import inspect

### IMPORTING MODULE FROM PARENT DIRECTORY
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
grandparentdir = os.path.dirname(parentdir)
sys.path.insert(0, grandparentdir) 

from data_analysis_functions import *

##################################
########## MAIN PLOT #############
##################################

####### Generate list of names at file location
listfiles = GenList([960,974,969,975,955,976,968,977,958,978,967,979,959,980,966,981,961,982,965,983,962,984,964,985,963,986,970,987,971,988,972,989,973],'../data/large_plot/ESR_{}.tf')
npts = 1337

# Channels to plot
x='Frequency (Hz)'
y='Lock-In Y (V)'

bias = []
conductance = []
z = np.zeros(npts)

for file in listfiles:
    # import data
    data, header = ReadFile_ESR(file)
    currentstpt = round(float(header[1][3])*1e12) # in pA
    biasstpt = round(float(header[1][4]),4) # in V
    freq = data[x][0:npts]*1e-9
    trace = data[y][0:npts]
    
    # Normalise
    trace = Normalise(trace)
    
    # substract average value from trace
    trace = trace - (sum(trace)/npts)
    
    z = np.column_stack((z,trace))
    bias.append(biasstpt)
    conductance.append(currentstpt/biasstpt)
z = np.delete(z, 0, 1) #delete row of zeros from initialization

colors = 'magma_r'
fig, axs = plt.subplots(2,1,figsize=(6.4/1.5,4.8*2/1.5), gridspec_kw={'height_ratios': [1, 1/2]})
bias = [1/entry for entry in bias]
im = axs[0].pcolor(conductance,freq*1000,z, cmap=colors,vmin=z.min(),vmax=z.max())
axs[0].set_xlabel('Conductance (pS)')
axs[0].set_ylabel('Frequency (MHz)')
cbar = fig.colorbar(im,ax=axs[0],aspect=40)
cbar.set_label('ESR signal (a.u.)')
axs[0].tick_params(direction="in")
axs[0].set_ylim([20, 1000])
fig.tight_layout()

################################
########## ZOOM IN #############
################################
    
####### Generate list of names at file location
A = GenList(range(1,10),'../data/zoom_in/ESR_A00{}.tf')
B = GenList(range(10,20),'../data/zoom_in/ESR_A0{}.tf')
listfiles = A+B
npts = 513
start = 0
x='Frequency (Hz)'
y='Lock-In Y (V)'


bias = []
conductance = []
z_zoom = np.zeros(npts-start)

for file in listfiles:
    data, header = ReadFile_ESR(file)
    currentstpt = round(float(header[1][3])*1e12)
    biasstpt = round(float(header[1][4]),4)
    freq = data[x][start:npts]*1e-9
    trace = data[y][start:npts]
    
    # Normalise
    trace = Normalise(trace)
    
    # substract average value from trace
    trace = trace - (sum(trace)/npts)
    
    z_zoom = np.column_stack((z_zoom,trace))
    bias.append(biasstpt)
    conductance.append(currentstpt/biasstpt)
z_zoom = np.delete(z_zoom, 0, 1) #delete row of zeros from initialization

bias = [1/entry for entry in bias]
im2 = axs[1].pcolor(conductance,freq*1000,z_zoom, cmap=colors,vmin=z.min(),vmax=z.max())
axs[1].set_xlabel('Conductance (pS)')
axs[1].set_ylabel('Frequency (MHz)')
axs[1].set_ylim([10, 200])
cbar = fig.colorbar(im2,ax=axs[1],aspect=20)
cbar.set_label('ESR signal (a.u.)')
axs[1].tick_params(direction="in")
fig.tight_layout()
plt.savefig('../plots/fig_2b.pdf')

