# -*- coding: utf-8 -*-
"""
Created on Thu Feb 23 13:44:49 2023

@author: lmveldman
"""

### HERE WE FIT THE ESR DATA THAT SHOWS SPIN PUMPING

import os
import sys
import inspect

### IMPORTING MODULE FROM PARENT DIRECTORY
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
grandparentdir = os.path.dirname(parentdir)
sys.path.insert(0, grandparentdir) 

from data_analysis_functions import *

##########################################################
############ FITTING HYPERFINE SPIN PUMPING ##############
##########################################################

########### channels to extract
x = 'Frequency (Hz)'
y = 'Lock-In Y (V)'

########### initialize arrays for reference data and parameters
popt_hyp = []
perror_hyp = []
freq_hyp = []
data_hyp = []

############ enter files
files = [
    'ESR_860.tf',
    'ESR_850.tf',
    'ESR_861.tf',
    'ESR_848.tf',
    'ESR_862.tf',
    'ESR_851.tf',
    'ESR_863.tf',
    'ESR_842.tf',
    'ESR_852.tf',
    'ESR_853.tf',
    'ESR_854.tf',
    'ESR_826.tf',
    'ESR_855.tf',
    'ESR_856.tf',
    'ESR_858.tf',
    'ESR_859.tf',
    'ESR_857.tf'
]
########### offset traces in plot
offset = np.linspace(0,0.4,len(files))

############ List of inital guesses:  f_0,Gamma,q,A,Delta_F,I,T
p0 = [ 
    [12.6,0.1,0,0,0.13,0.15,1],
      [12.38,0.1,0,0,0.13,0.15,1],
      [12.22,0.1,0.1,0,0.13,0.15,1],
      [12.15,0.1,0,0,0.130,0.1,1],
      [12.0,0.1,0,0,0.13,0.1,0.05],
      [12.0,0.1,0,0,0.13,0.1,0.05],
      [11.9,0.08,0,0,0.13,0.1,0.05],
      [11.85,0.08,0,0,0.13,0.1,0.05],
      [11.8,0.06,0,0,0.13,0.1,0.05],
      [11.75,0.06,0,0,0.13,0.1,0.05],
      [11.68,0.04,0.3,0,0.13,0.1,0.05],
      [11.65,0.04,0,0,0.13,0.1,0.05],
      [11.6,0.04,0,0,0.13,0.1,0.02],
      [11.57,0.04,0,0.01,0.13,0.1,0.05],
      [11.58,0.03,0,0,0.13,0.1,0.05],
      [11.54,0.02,0,0,0.13,0.2,0.02],
      [11.53,0.02,0,0,0.13,0.1,0.05]
     ]
############ Fitting bounds
eps_f = 0.2 # fitting bounds for center frequency
eps_Gamma = 0.1 # fitting bounds for widths
eps_I = 5.5 # fitting bound for Amplitudes
eps_q = 2 # fitting gbound for asymmetry
eps_A = 0.3 # fitting bound for offset
eps_delta = 0.05 # fitting bound for hyperfine splitting
eps_T = 1 # fitting bound for temperature
bounds = []
for i in range(len(files)):
    bounds.append(
     (
    (p0[i][0]-eps_f,p0[i][1]-eps_Gamma,p0[i][2]-eps_q,p0[i][3]-eps_A,p0[i][4]-eps_delta,p0[i][5]-eps_I,p0[i][6]-eps_T), 
    (p0[i][0]+eps_f,p0[i][1]+eps_Gamma,p0[i][2]+eps_q,p0[i][3]+eps_A,p0[i][4]+eps_delta,p0[i][5]+eps_I,p0[i][6]+eps_T)
     )
    )


bias = []
for i,name in enumerate(files):
    ########### import and read files
    file = '../data/bias_dependence/'+ name
    data, header = ReadFile_ESR(file)
    currentstpt = float(header[1][3])*1e12
    biasstpt = float(header[1][4])*1000
    bias.append(round(biasstpt))
    
    ############ remove NaN values in x and y data
    ydat = np.array(data[y])[~np.isnan(np.array(data[y]))]
    xdat = np.array(data[x])[~np.isnan(np.array(data[x]))]
    
    ############# Convert axes to correct units
    freq = xdat*10**-9
    Delta_I = LItoA_ESR(ydat,0.05,10**11)
    
    ############# Fitting parameters:  f,f_0,Gamma,q,A,Delta_F,I_A,I_B,I_C,I_D,I_E,I_F
    popt, pcov = curve_fit(Six_Fano_Boltzmann, freq, Delta_I, p0=p0[i], bounds=bounds[i])
    print(popt)
    ############# save all reference atom parameters in arrays
    popt_hyp.append(popt)
    perror_hyp.append(np.sqrt(np.diag(pcov)))
    freq_hyp.append(freq)
    data_hyp.append(Delta_I)
    
    ############ plotting for the fitting process
    cmap = plt.cm.get_cmap('autumn')
    plt.plot(freq, Six_Fano_Boltzmann(freq, *p0[i])+offset[i], c='blue')
    plt.plot(freq, Six_Fano_Boltzmann(freq, *popt)+offset[i], c=cmap(i/len(files)))
    plt.plot(freq, Delta_I+offset[i],'o',c=cmap(i/len(files)),alpha=0.2,markersize=2, label = file + '\n' + '{:.1f} pA, {:.1f} mV'.format(currentstpt,biasstpt)) 
    plt.xlabel('f - f\u2080 (GHz)')
    plt.ylabel('\u0394 I (pA)')


############# PLOTTING ALL FITS ###########
plt.figure()
cmap = plt.cm.get_cmap('autumn')
for i in range(len(files)):
    plt.plot(freq_hyp[i]-popt_hyp[i][0], Six_Fano_Boltzmann(freq_hyp[i], *popt_hyp[i])-popt_hyp[i][3] + offset[i], c=cmap(i/len(files)),label='bla')
    plt.plot(freq_hyp[i]-popt_hyp[i][0], data_hyp[i]-popt_hyp[i][3]+offset[i],c=cmap(i/len(files)),alpha=0.2,markersize=2,label='bla') 
plt.xlabel('f - f\u2080 (GHz)')
plt.ylabel('\u0394 I (pA)')
plt.tick_params(direction="in")


############ PLOTTING EFFECTIVE TEMPERATURE ###########

plt.figure(figsize=(4/1.5,4.8/1.5))
plt.errorbar(bias,np.transpose(popt_hyp)[6]*1000,yerr= np.transpose(np.sqrt(np.diag(pcov)))[6]*1000 )
plt.xlabel('Bias (mV)')
plt.ylabel('Effective temperature (mK)')
plt.tick_params(direction="in")
plt.tight_layout()


#%%

########### PLOT INDIVIDUAL FITS ##################

############# plotting for final graph
for j in range(17):
    plt.figure(figsize=(4.5/1.5,4.8/2/1.5))
    for i in [j]:
        # plot data and convert to fA
        plt.plot((freq_hyp[i]-popt_hyp[i][0])*1000, (data_hyp[i]-popt_hyp[i][3])*1000,c='grey',markersize=2,label='bla') 
        # plot fit
        plt.plot((freq_hyp[i]-popt_hyp[i][0])*1000, (Six_Fano_Boltzmann(freq_hyp[i], *popt_hyp[i])-popt_hyp[i][3])*1000, c='black',label='bla')
        # write effective temp in plot
        plt.text(0, 40, '$T_{eff}$'+' = {} mK \n'.format(round(popt_hyp[i][6]*1000,1)),
                 # '$V$'+' = {} mV \n'.format(round(bias[i],0)),
                 verticalalignment='top')

    plt.xlim([-600,600])
    plt.ylim([-10,40])
    plt.xlabel('f - f\u2080 (MHz)')
    plt.ylabel('\u0394 I (fA)')
    plt.tick_params(direction="in")
    plt.tight_layout()
    
    ### save only selected plots 
    if j == 2:
        plt.savefig('../plots/spin_pumping_35mV.pdf'.format(j))
        print(bias[j])
    if j == 9:
        plt.savefig('../plots/spin_pumping_80mV.pdf'.format(j))
        print(bias[j])
    if j == 13:
        print(bias[j])
        plt.savefig('../plots/spin_pumping_120mV.pdf'.format(j))

#%%

###########  GENERATE COLORPLOT OF RAW DATA ###############

#################### GENERATE COLORPLOT

files = ['ESR_861.tf','ESR_848.tf','ESR_862.tf','ESR_851.tf','ESR_863.tf',
          'ESR_842.tf','ESR_852.tf','ESR_853.tf','ESR_854.tf','ESR_826.tf','ESR_855.tf',
          'ESR_856.tf','ESR_858.tf','ESR_859.tf','ESR_857.tf']

fmin = 11 #GHz
fmax = 12.8 # GHz
fmin = -1
fmax = 0.8
########### import and read files
bias = []
z = np.zeros(923)
for i,name in enumerate(files):
    file = '../data/bias_dependence/'+ name
    data, header = ReadFile_ESR(file)
    currentstpt = float(header[1][3])*1e12
    biasstpt = float(header[1][4])
    bias.append(round(biasstpt,4))
    
    ############ remove NaN values in x and y data
    ydat = np.array(data[y])[~np.isnan(np.array(data[y]))]
    xdat = np.array(data[x])[~np.isnan(np.array(data[x]))]
    
    ############# Convert axes to correct units
    freq = xdat*10**-9 - popt_hyp[i+2][0]
    Delta_I = LItoA_ESR(ydat,0.05,10**11)
    
    ############ remove floor value determined from fit:
    Delta_I = Delta_I - popt_hyp[i+2][3]
    
    ############ Normalize data
    # Delta_I = (Delta_I - min(Delta_I)) / (max(Delta_I)-min(Delta_I))
    
    ############ Padding data to make matrix square se we can create colorplot
    stepsize = (max(freq)-min(freq))/len(freq)
    prepad = np.empty( round( (min(freq) - fmin)/stepsize )) *np.nan
    postpad = np.empty( round( (fmax - max(freq))/stepsize  )) *np.nan
    datapad = np.concatenate((prepad, Delta_I, postpad), axis=0)
    
    ########### Ugly hack to get everything the right length:
    if i in [0,1,2,3,4,5,6,7,9,11,12,13,14]:
           datapad = np.concatenate((datapad, [np.nan]), axis=0)
     
    z = np.column_stack((z,datapad))
    
    #generate new freqency axis with right size
    freq = np.linspace(fmin,fmax,len(datapad))
    
z = np.delete(z, 0, 1) #delete row of zeros from initialization

plt.figure(figsize=(6.4/1.5,4.8/1.5))
colors = 'magma_r'
plt.pcolor(freq*1000,[i*1000 for i in bias],np.transpose(z), cmap=colors)

plt.ylabel('Bias [mV]')
plt.xlabel('$f-f_0$ (MHz)')
plt.xlim([-450,450])
cbar = plt.colorbar(label='ESR signal (a.u.)',ticks=[])
plt.tick_params(direction="in")
plt.tight_layout()
plt.savefig('../plots/fig_1d.pdf')



