function res = SumFitFanos(f,f0,I1,gamma,alpha,Ioff,n,deltaf)
% Sum of functions adapted to reproduce asymmetric ESR lineshape as 
% defined in J. Kim et al, PRB 104, 174408 (2021)
% All peaks are identical and split equally
%   f array of frequencies
%   f0 resonance frequency of the first peak
%   I1 intensity of the peak
%   gamma full width half maximum
%   alpha gives the asymmetry of the peak
%   Ioff offset in current
%   n number of peaks
%   deltaf splitting between peaks
res = zeros(size(f)) + Ioff;
for i=1:n
    fcent = f0 + (i-1)*deltaf;
    delta = (f - fcent)./(gamma/2);
    res = res + I1 * (1 + alpha*delta)./(1+delta.^2);
end
