close all
clear all

%% Rotate g factor in-plane

% values from J. Kim et al, PRB 104, 174408 (2021)
gMg = 1.917;
gO = 1.653;
gz = 1.989;

phi = 16 * pi/180;

% g factor we should get from experiment
gv = sqrt( (cos(phi)*gO)^2 + (sin(phi)*gMg)^2 )
gh = sqrt( (sin(phi)*gO)^2 + (cos(phi)*gMg)^2 )

%% Rotate v,h back to x,y

gv = 1.688; %pm 0.005
gh = 1.906; %pm 0.009

phi = 12 * pi/180;

gx = sqrt( (cos(phi)*gv)^2 + (sin(phi)*gh)^2 )
gy = sqrt( (sin(phi)*gv)^2 + (cos(phi)*gh)^2 )

%% Rotate A vector

% values from fits
Av = 64; %MHz
Ah = 24.6; %MHz
Az = 19; %MHz

syms AO AMg

S = solve( ...
    Av == 1/gv * sqrt( (cos(phi)*gO*AO)^2 + (sin(phi)*gMg*AMg)^2 ), ...
    Ah == 1/gh * sqrt( (sin(phi)*gO*AO)^2 + (cos(phi)*gMg*AMg)^2 ) ...
    );

AO = eval(S.AO)
AMg = eval(S.AMg)