

clear all
close all

%% Load data from fits
load('variablesVertical.mat')

%% Plot 8 peaks data ESR_832, ESR_948

gain = 10^9;
sens = 0.001; %V

filename = strcat('ESR_832.tf');
    
% Open file and load data
fid = fopen(filename);
data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
fclose(fid);
freq = data{1}*1E-9; %GHz
lockin = data{7};

% Convert lockin to change in current
deltaI = lockin * (sens/10/gain) * 2*sqrt(2)*pi/4 * 10^12; %pA

% find fit parameters
index = contains(Hyp_v, 'ESR_832');

% center frequency
freq = freq - (hypf0_v(index)+3.5*hypdeltaf_v(index));
bonjour = hypf0_v(index)+3.5*hypdeltaf_v(index)
hypdeltaf_v(index)

% Plot spectrum and fit

offset1 = -0.3

figure;
set(gca,'FontSize',18)
hold on;
box on
p = plot(freq*1000, deltaI-offset1, '.');
p.Color = '#2B3990';
q = plot(freq*1000, SumFitFanos(freq,hypf0_v(index)- (hypf0_v(index)+3.5*hypdeltaf_v(index)),hypI1_v(index),gamma_v(index),alpha_v(index),hypIoff_v(index),8,hypdeltaf_v(index))-offset1,'LineWidth',2);
q.Color = '#2B3990';
xlim([-0.3 0.3])
%ylim([-0.1 0.3])
xlabel('Frequency (MHz)')
ylabel('\Delta I (pA)')

filename = strcat('ESR_948.tf');
    
% Open file and load data
fid = fopen(filename);
data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
fclose(fid);
freq2 = data{1}*1E-9; %GHz
lockin = data{7};

% Convert lockin to change in current
deltaI = lockin * (sens/10/gain) * 2*sqrt(2)*pi/4 * 10^12; %pA

% find fit parameters
index = contains(Hyp_v, 'ESR_948');

% center frequency
freq2 = freq2 - (hypf0_v(index)+3.5*hypdeltaf_v(index));
bonjour = hypf0_v(index)+3.5*hypdeltaf_v(index)
hypdeltaf_v(index)

% Plot spectrum and fit

offset2= offset1 + 0.2

set(gca,'FontSize',18)
hold on;
box on
p = plot(freq2*1000, deltaI-offset2, '.');
p.Color = '#FFA500';
q = plot(freq*1000, SumFitFanos(freq,hypf0_v(index)- (hypf0_v(index)+3.5*hypdeltaf_v(index)),hypI1_v(index),gamma_v(index),alpha_v(index),hypIoff_v(index),8,hypdeltaf_v(index))-offset2,'LineWidth',2);
q.Color = '#FFA500';
xlim([-0.3 0.3]*1000)
ylim([-0 0.8])
xlabel('Frequency (MHz)')
ylabel('\Delta I (pA)')

%% Plot reference data ESR_833, ESR_949

filename = strcat('ESR_833.tf');
   
sens = 0.001; %V

% Open file and load data
fid = fopen(filename);
data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
fclose(fid);
freq = data{1}*1E-9; %GHz
lockin = data{7};

% Convert lockin to change in current
deltaI = lockin * (sens/10/gain) * 2*sqrt(2)*pi/4 * 10^12; %pA

% find fit parameters
index = contains(Ref_v, 'ESR_833');

% center frequency
freq = freq - f0_v(index);
hola = f0_v(index)

% Plot spectrum and fit

offset1 = -0.3

figure;
set(gca,'FontSize',18)
hold on;
box on
p = plot(freq*1000, deltaI-offset1, '.');
p.Color = '#2B3990';
q = plot(freq*1000, FitFano(freq,0,I1_v(index),gamma_v(index),alpha_v(index),Ioff_v(index))-offset1,'LineWidth',2);
q.Color = '#2B3990';
xlim([-0.3 0.3]*1000)
ylim([0 1.5])
yticks([0.0, 0.4, 0.8, 1.2])
xlabel('Frequency (GHz)')
ylabel('Delta I (pA)')
filename = strcat('ESR_949.tf');
    
% Open file and load data
fid = fopen(filename);
data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
fclose(fid);
freq2 = data{1}*1E-9; %GHz
lockin = data{7};

% Convert lockin to change in current
deltaI = lockin * (sens/10/gain) * 2*sqrt(2)*pi/4 * 10^12; %pA

% find fit parameters
index = contains(Ref_v, 'ESR_949');

% center frequency
freq2 = freq2 - f0_v(index);
hola = f0_v(index)

% Plot spectrum and fit

offset2= offset1 + 0.1

set(gca,'FontSize',18)
hold on;
box on
p = plot(freq2*1000, deltaI-offset2, '.');
p.Color = '#FFA500';
q = plot(freq*1000, FitFano(freq,0,I1_v(index),gamma_v(index),alpha_v(index),Ioff_v(index))-offset2,'LineWidth',2);
q.Color = '#FFA500';
xlabel('Frequency (MHz)')
ylabel('\Delta I (pA)')

%% Fit and plot 6 peaks data ESR_584, ESR_685

filename = strcat('ESR_584.tf');
    
% Open file and load data
fid = fopen(filename);
data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
fclose(fid);
freq = data{1}*1E-9; %GHz
lockin = data{7};
sens = 0.01;

% Convert lockin to change in current
deltaI = lockin * (sens/10/gain) * 2*sqrt(2)*pi/4 * 10^12; %pA

% Fit with sum of Fanos
%Initialize parameters
n = 6;
gammai = 0.02;
alphai = 0.2;
deltafi = 0.07;
f0i = 24.1;
I1i = 0.01;
Ioffi = -0.01;
% Plot data and starting point
% figure;
% hold on
% plot(freq, deltaI,'o')
% plot(freq, SumFitFanos(freq,f0i,I1i,gammai,alphai,Ioffi,n,deltafi))
% hold off
% define fit model
ft = fittype('SumFitFanos(f,f0,I1,gamma,alpha,Ioff,n,deltaf)','Independent','f');
% Set limits and starting coefficients (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
options = fitoptions(ft);
options.Lower = [0, min(deltaI) , 0, 0, min(freq), 0, n];
options.Upper = [100, max(deltaI), 1, 1, max(freq), 1, n];
options.StartPoint = [I1i, Ioffi, alphai, deltafi, f0i, gammai, n];
% Perform fit
[myfit,gof] = fit(freq, deltaI, ft, options)

% center frequency
freq = freq - (myfit.f0+2.5*myfit.deltaf);
hello = myfit.f0+2.5*myfit.deltaf
myfit.deltaf

% Plot data and fit results

offset1 = -0.4
fitfreq = linspace(-0.3,0.3,100)

figure;
set(gca,'FontSize',18)
hold on;
box on
p = plot(freq*1000, deltaI-offset1,'.');
p.Color = '#2B3990';
q = plot(fitfreq*1000, SumFitFanos(fitfreq,myfit.f0 - (myfit.f0+2.5*myfit.deltaf),myfit.I1,myfit.gamma,myfit.alpha,myfit.Ioff,n,myfit.deltaf)-offset1,'LineWidth',2);
q.Color = '#2B3990';
xlabel('Frequency (MHz)')
ylabel('\Delta I (pA)')
%

filename = strcat('ESR_685.tf');
    
% Open file and load data
fid = fopen(filename);
data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
fclose(fid);
freq2 = data{1}*1E-9; %GHz
lockin = data{7};
sens = 0.001; %should this be 0.002???

% Convert lockin to change in current
deltaI = lockin * (sens/10/gain) * 2*sqrt(2)*pi/4 * 10^12; %pA

% Get data above 24.3 because there is a weird background
filter = (freq2>=24.3);
freq2 = freq2(filter);
deltaI = deltaI(filter);

% Fit with sum of Fanos
%Initialize parameters
n = 6;
gammai = 0.02;
alphai = -1;
deltafi = 0.01;
f0i = 24.45;
I1i = 0.05;
Ioffi = -0.1;
% % Plot data and starting point
% figure;
% hold on
% plot(freq, deltaI,'o')
% plot(freq, SumFitFanos(freq,f0i,I1i,gammai,alphai,Ioffi,n,deltafi))
% hold off
% define fit model
ft = fittype( 'SumFitFanos(f,f0,I1,gamma,alpha,Ioff,n,deltaf)', 'Independent', 'f');
% Set limits and starting coefficients (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
options = fitoptions(ft);
options.Lower = [0, min(deltaI) , -inf, 0, min(freq2), 0, n];
options.Upper = [100, max(deltaI), +inf, 1, max(freq2), 1, n];
options.StartPoint = [I1i, Ioffi, alphai, deltafi, f0i, gammai, n];
% Perform fit
[myfit,gof] = fit(freq2, deltaI, ft, options)

% center frequency
freq2 = freq2 - (myfit.f0+2.5*myfit.deltaf);
hello = myfit.f0+2.5*myfit.deltaf
myfit.deltaf

% Plot data and fit results

offset2= offset1 + 0.2

set(gca,'FontSize',18)
hold on;
box on
p = plot(freq2*1000, deltaI-offset2,'.');
p.Color = '#FFA500';
q = plot(fitfreq*1000, SumFitFanos(fitfreq,myfit.f0-(myfit.f0+2.5*myfit.deltaf),myfit.I1,myfit.gamma,myfit.alpha,myfit.Ioff,n,myfit.deltaf)-offset2,'LineWidth',2);
q.Color = '#FFA500';
xlim([-0.3 0.3]*1000)
ylim([-0 0.5])
%yticks([-0.9, -0.6, -0.3, 0.0])
xlabel('Frequency (MHz)')
ylabel('\Delta I (pA)')

