clear variables
close all

%% Parameters to load data
% List of spectra and corresponding fields
Hyp_v = {'ESR_966';'ESR_971';'ESR_975';'ESR_980';'ESR_988';'ESR_A007';'ESR_A013';'ESR_A018';'ESR_A022';'ESR_A030';'ESR_A036';'ESR_A040';'ESR_A044';'ESR_A049';'ESR_A059';'ESR_A067';'ESR_A073';'ESR_A078';'ESR_A084';'ESR_A089';'ESR_A093';'ESR_A100';'ESR_A105';'ESR_A111';'ESR_A121';'ESR_A126';'ESR_A134';'ESR_A150';'ESR_A155';'ESR_A160';'ESR_A169';'ESR_A178';'ESR_A183';'ESR_A188';'ESR_A194';'ESR_A207';'ESR_832';'ESR_841';'ESR_863';'ESR_850';'ESR_867';'ESR_870';'ESR_878';'ESR_883';'ESR_891';'ESR_895';'ESR_902';'ESR_906';'ESR_910';'ESR_916';'ESR_954';'ESR_930';'ESR_934';'ESR_943';'ESR_948'};
Ref_v = {'ESR_968';'ESR_972';'ESR_976';'ESR_981';'ESR_989';'ESR_A008';'ESR_A014';'ESR_A019';'ESR_A024';'ESR_A031';'ESR_A037';'ESR_A041';'ESR_A045';'ESR_A050';'ESR_A060';'ESR_A068';'ESR_A074';'ESR_A080';'ESR_A085';'ESR_A090';'ESR_A094';'ESR_A101';'ESR_A107';'ESR_A113';'ESR_A122';'ESR_A127';'ESR_A135';'ESR_A151';'ESR_A156';'ESR_A161';'ESR_A170';'ESR_A180';'ESR_A184';'ESR_A189';'ESR_A195';'ESR_A208';'ESR_833';'ESR_842';'ESR_864';'ESR_851';'ESR_868';'ESR_873';'ESR_879';'ESR_885';'ESR_892';'ESR_897';'ESR_903';'ESR_907';'ESR_912';'ESR_917';'ESR_955';'ESR_931';'ESR_936';'ESR_944';'ESR_949'};
Bx_v = {-0.074;-0.149;-0.225;-0.298;-0.372;-0.446;-0.532;-0.595;-0.666;-0.736;-0.790;-0.852;-0.907;-0.948;-0.987;-1.009;-1.024;-1.025;-1.030;-1.006;-0.939;-0.846;-0.729;-0.590;-0.444;-0.302;-0.151;0.000;0.151;0.304;0.457;0.592;0.732;0.850;0.944;1.011;1.037;1.029;1.008;0.978;0.900;0.846;0.801;0.729;0.660;0.590;0.525;0.450;0.376;0.302;0.229;0.228;0.152;0.074;0.000};
Bx_v = cell2mat(Bx_v);
Bz_v = {-0.851;-0.845;-0.842;-0.818;-0.798;-0.773;-0.760;-0.709;-0.666;-0.617;-0.553;-0.492;-0.423;-0.345;-0.264;-0.179;-0.090;0.000;0.090;0.178;0.341;0.488;0.611;0.703;0.769;0.830;0.856;0.865;0.865;0.830;0.791;0.706;0.614;0.491;0.343;0.178;0.000;-0.090;-0.179;-0.262;-0.420;-0.489;-0.561;-0.561;-0.660;-0.703;-0.749;-0.780;-0.806;-0.830;-0.853;-0.850;-0.861;-0.850;-0.860};
Bz_v = cell2mat(Bz_v);

% Calculate total field
Btot_v = sqrt(Bz_v.^2+Bx_v.^2);

% Calculate corresponding field angle
angle_v = atan2(Bx_v,Bz_v) * 180 /pi;

% Parameters
gain = 10^9;
sens = 0.001; %V



%% Initialize arrays to store fit results for reference atom

% To store results
f0_v = zeros(size(Bx_v));
f0neg_v = zeros(size(Bx_v));
f0pos_v = zeros(size(Bx_v));
I1_v = zeros(size(Bx_v));
I1neg_v = zeros(size(Bx_v));
I1pos_v = zeros(size(Bx_v));
Ioff_v = zeros(size(Bx_v));
Ioffneg_v = zeros(size(Bx_v));
Ioffpos_v = zeros(size(Bx_v));
gamma_v = zeros(size(Bx_v));
gammaneg_v = zeros(size(Bx_v));
gammapos_v = zeros(size(Bx_v));
alpha_v = zeros(size(Bx_v));
alphaneg_v = zeros(size(Bx_v));
alphapos_v = zeros(size(Bx_v));

%% Go through spectra - fit reference and store fit values

for i = 1:size(Ref_v)
    filename = strcat(Ref_v{i},'.tf');
    
    % Open file and load data
    fid = fopen(filename);
    data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
    fclose(fid);
    freq = data{1}*1E-9; %GHz
    lockin = data{7};
    
    % Convert lockin to change in current
    deltaI = lockin * (sens/10/gain) * 2*sqrt(2)*pi/4 * 10^12; %pA
    
    % Fit with a Fano function
    % intialize parameters
    [I1i, f0i] = max(deltaI);
    gammai = 0.03;
    alphai = 0.4;
    Ioffi = deltaI(1);
    % define fit model
    ft = fittype( 'FitFano(f,f0,I1,gamma,alpha,Ioff)', 'Independent', 'f');
    % Set limits and starting coefficients (order coefs: I1, Ioff, alpha, f0,gamma)
    options = fitoptions(ft);
    options.Lower = [0, -10 , -Inf, min(freq), 0];
    options.Upper = [100, 10, +Inf, max(freq), 1];
    options.StartPoint = [I1i, Ioffi, alphai, f0i, gammai];
    % Perform fit
    [myfit,gof] = fit(freq, deltaI, ft, options);
    % Plot fit results
    fig = figure;
    plot(myfit, freq, deltaI)
    title(Ref_v{i}, 'Interpreter', 'None')
    annotation('textbox',[0.2 0.2 0 0 ], 'String', strcat('R^2:',num2str(gof.rsquare,'%4.2f')))
    subtitle(strcat('(Bx, Bz)=(',num2str(Bx_v(i)),',',num2str(Bz_v(i)),') / (Btot,theta)=(',num2str(Btot_v(i)),',',num2str(angle_v(i)),')'))
    xlabel('Frequency (GHz)')
    ylabel('Delta I (pA)')
    % Save Figure
    exportgraphics(fig,fullfile('Figures',strrep(filename,'tf','png')),'Resolution',300)
    
    % Store values for field dependence
    f0_v(i) = myfit.f0;
    I1_v(i) = myfit.I1;
    Ioff_v(i) = myfit.Ioff;
    gamma_v(i) = myfit.gamma;
    alpha_v(i) = myfit.alpha;
    
    % Store values for error bars (order coefs: I1, Ioff, alpha, f0,gamma)
    conf = confint(myfit);
    I1neg_v(i) = conf(1)-myfit.I1;
    I1pos_v(i) = conf(2)-myfit.I1;
    Ioffneg_v(i) = conf(3)-myfit.Ioff;
    Ioffpos_v(i) = conf(4)-myfit.Ioff;
    alphaneg_v(i) = conf(5)-myfit.alpha;
    alphapos_v(i) = conf(6)-myfit.alpha;
    f0neg_v(i) = conf(7)-myfit.f0;
    f0pos_v(i) = conf(8)-myfit.f0;
    gammaneg_v(i) = conf(9)-myfit.gamma;
    gammapos_v(i) = conf(10)-myfit.gamma;
end


%% One spectrum is not fitted correctly so do it again

filename = strcat('ESR_976.tf');

% find index
i = find(contains(Ref_v,'ESR_976'));
    
% Open file and load data
fid = fopen(filename);
data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
fclose(fid);
freq = data{1}*1E-9; %GHz
lockin = data{7};

% Convert lockin to change in current
deltaI = lockin * (sens/10/gain) * 2*sqrt(2)*pi/4 * 10^12; %pA

% Fit with a Fano function
% intialize parameters
I1i = max(deltaI);
f0i = 24.25;
gammai = 0.03;
alphai = 0.4;
Ioffi = 0.05;
% define fit model
ft = fittype( 'FitFano(f,f0,I1,gamma,alpha,Ioff)', 'Independent', 'f');
% Set limits and starting coefficients (order coefs: I1, Ioff, alpha, f0,gamma)
options = fitoptions(ft);
options.Lower = [0, -10 , -Inf, min(freq), 0];
options.Upper = [100, 10, +Inf, max(freq), 1];
options.StartPoint = [I1i, Ioffi, alphai, f0i, gammai];
% Perform fit
[myfit,gof] = fit(freq, deltaI, ft, options);
% Plot fit results
fig = figure;
plot(myfit, freq, deltaI)
title(Ref_v{i}, 'Interpreter', 'None')
annotation('textbox',[0.2 0.2 0 0 ], 'String', strcat('R^2:',num2str(gof.rsquare,'%4.2f')))
subtitle(strcat('(Bx, Bz)=(',num2str(Bx_v(i)),',',num2str(Bz_v(i)),') / (Btot,theta)=(',num2str(Btot_v(i)),',',num2str(angle_v(i)),')'))
xlabel('Frequency (GHz)')
ylabel('Delta I (pA)')
exportgraphics(fig,fullfile('Figures',strrep(filename,'tf','png')),'Resolution',300)

% Store values for field dependence
f0_v(i) = myfit.f0;
I1_v(i) = myfit.I1;
Ioff_v(i) = myfit.Ioff;
gamma_v(i) = myfit.gamma;
alpha_v(i) = myfit.alpha;

% Store values for error bars (order coefs: I1, Ioff, alpha, f0,gamma)
conf = confint(myfit);
I1neg_v(i) = conf(1)-myfit.I1;
I1pos_v(i) = conf(2)-myfit.I1;
Ioffneg_v(i) = conf(3)-myfit.Ioff;
Ioffpos_v(i) = conf(4)-myfit.Ioff;
alphaneg_v(i) = conf(5)-myfit.alpha;
alphapos_v(i) = conf(6)-myfit.alpha;
f0neg_v(i) = conf(7)-myfit.f0;
f0pos_v(i) = conf(8)-myfit.f0;
gammaneg_v(i) = conf(9)-myfit.gamma;
gammapos_v(i) = conf(10)-myfit.gamma;

%% Plot results field dependence for reference atom
figure;
plot(angle_v, Btot_v, 'o')
xlabel('Angle Bxz')
ylabel('Total field (T)')

figure;
errorbar(angle_v, f0_v, f0neg_v, f0pos_v, 'o')
xlabel('Angle Bxz')
ylabel('Center frequency (GHz)')

figure;
errorbar(angle_v, I1_v, I1neg_v, I1pos_v, 'o')
xlabel('Angle Bxz')
ylabel('Peak intensity (pA)')

figure;
errorbar(angle_v, Ioff_v, Ioffneg_v, Ioffpos_v, 'o')
xlabel('Angle Bxz')
ylabel('Offset (pA)')

figure;
errorbar(angle_v, gamma_v, gammaneg_v, gammapos_v, 'o')
xlabel('Angle Bxz')
ylabel('Full width half maximum (GHz)')

figure;
errorbar(angle_v, alpha_v, alphaneg_v, alphapos_v, 'o')
xlabel('Angle Bxz')
ylabel('Peak asymmetry/q factor')



%% Initialize arrays to store fit results for hyperfine atom

% To store results

hypf0_v = zeros(size(Bx_v));
hypf0neg_v = zeros(size(Bx_v));
hypf0pos_v = zeros(size(Bx_v));
hypI1_v = zeros(size(Bx_v));
hypI1neg_v = zeros(size(Bx_v));
hypI1pos_v = zeros(size(Bx_v));
hypIoff_v = zeros(size(Bx_v));
hypIoffneg_v = zeros(size(Bx_v));
hypIoffpos_v = zeros(size(Bx_v));
hypdeltaf_v = zeros(size(Bx_v));
hypdeltafneg_v = zeros(size(Bx_v));
hypdeltafpos_v = zeros(size(Bx_v));

hypgof_v = zeros(size(Bx_v));

%% Now fit hyperfine data

gv = 2; % to guess hyperfine splitting
gz = 2; % to guess hyperfine splitting

Av = 0.065; %GHz initial guess for hyperfine in plane
Az = 0.02; %GHz initial guess for hyperfine out of plane

for i = 1:size(Hyp_v)
    filename = strcat(Hyp_v{i},'.tf');
    
    % Open file and load data
    fid = fopen(filename);
    data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
    fclose(fid);
    freq = data{1}*1E-9; %GHz
    lockin = data{7};
    
    % Convert lockin to change in current
    deltaI = lockin * (sens/10/gain) * 2*sqrt(2)*pi/4 * 10^12; %pA
    
    % Intialize parameters
    % To guess hyperfine coupling
    thetai = (angle_v(i) - 10) * pi/180;
    gi = sqrt( (sin(thetai)*gv).^2 + (cos(thetai)*gz).^2 );
    % Initialize parameters
    deltafi = 1/gi * sqrt( (sin(thetai)*gv*Av).^2 + (cos(thetai)*gz*Az).^2 );
    hypdeltaf_v(i) = deltafi;
    n = 8;
    f0i = f0_v(i) - (n-1)/2 * deltafi; 
    I1i = I1_v(i)/n;
    gammai = gamma_v(i);
    alphai = alpha_v(i);
    Ioffi = Ioff_v(i);
    
    % define fit model
    ft = fittype( 'SumFitFanos(f,f0,I1,gamma,alpha,Ioff,n,deltaf)', 'Independent', 'f');
    % Set limits and starting coefficients (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
    options = fitoptions(ft);
    options.Lower = [0, min(deltaI) , alphai, 0, min(freq), gammai, n];
    options.Upper = [100, max(deltaI) , alphai, 1, max(freq), gammai, n];
    options.StartPoint = [I1i, Ioffi, alphai, deltafi, f0i, gammai, n];
    % Perform fit
    [myfit,gof] = fit(freq, deltaI, ft, options);
    
    % if gof is low then usually fit didn't work and missed first peak so
    % fit again
    if gof.rsquare <0.55
        % Initialize parameters
        deltafi = myfit.deltaf;
        f0i = myfit.f0 - myfit.deltaf; % shift starting position by one peak
        I1i = myfit.I1;
        options = fitoptions(ft); % keep fit model
        options.Lower = [0, min(deltaI) , alphai, 0, min(freq), gammai, n];
        options.Upper = [100, max(deltaI), alphai, 1, max(freq), gammai, n];
        options.StartPoint = [I1i, Ioffi, alphai, deltafi, f0i, gammai, n];
        % Perform fit
        [myfit,gof] = fit(freq, deltaI, ft, options);
    end
    
    hypgof_v(i) = gof.rsquare;
    % Plot fit results
    fig = figure;
    plot(myfit, freq, deltaI)
    title(Hyp_v{i}, 'Interpreter', 'None')
    annotation('textbox',[0.2 0.2 0 0 ], 'String', strcat('R^2:',num2str(gof.rsquare,'%4.2f')))
    subtitle(strcat('(Bx, Bz)=(',num2str(Bx_v(i)),',',num2str(Bz_v(i)),') / (Btot,theta)=(',num2str(Btot_v(i)),',',num2str(angle_v(i)),')'))
    xlabel('Frequency (GHz)')
    ylabel('Delta I (pA)')
    exportgraphics(fig,fullfile('Figures',strrep(filename,'tf','png')),'Resolution',300)
    
    % Store values for field dependence
    hypf0_v(i) = myfit.f0;
    hypI1_v(i) = myfit.I1;
    hypIoff_v(i) = myfit.Ioff;
    hypdeltaf_v(i) = myfit.deltaf;
    
    % Store values for error bars (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
    conf = confint(myfit);
    hypI1neg_v(i) = conf(1)-myfit.I1;
    hypI1pos_v(i) = conf(2)-myfit.I1;
    hypIoffneg_v(i) = conf(3)-myfit.Ioff;
    hypIoffpos_v(i) = conf(4)-myfit.Ioff;
    hypdeltafneg_v(i) = conf(7)-myfit.deltaf;
    hypdeltafpos_v(i) = conf(8)-myfit.deltaf;
    hypf0neg_v(i) = conf(9)-myfit.f0;
    hypf0pos_v(i) = conf(10)-myfit.f0;
end

%% Some spectra are not fitted correctly so adjust starting values per hand

filename = 'ESR_832.tf';

% find index
i = find(contains(Hyp_v,'ESR_832'));

% Open file and load data
fid = fopen(filename);
data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
fclose(fid);
freq = data{1}*1E-9; %GHz
lockin = data{7};

% Convert lockin to change in current
deltaI = lockin * (sens/10/gain) * 2*sqrt(2)*pi/4 * 10^12; %pA

%Initialize parameters
n = 8;
gammai = gamma_v(i);
alphai = alpha_v(i);
deltafi = Av;
f0i = hypf0_v(i); 
I1i = 1;
Ioffi = Ioff_v(i);

% define fit model
ft = fittype( 'SumFitFanos(f,f0,I1,gamma,alpha,Ioff,n,deltaf)', 'Independent', 'f');
% Set limits and starting coefficients (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
options = fitoptions(ft);
options.Lower = [0, min(deltaI) , alphai, 0, min(freq), gammai, n];
options.Upper = [100, max(deltaI), alphai, 1, max(freq), gammai, n];
options.StartPoint = [I1i, Ioffi, alphai, deltafi, f0i, gammai, n];
% Perform fit
[myfit,gof] = fit(freq, deltaI, ft, options);

hypgof_v(i) = gof.rsquare;
% Plot fit results
fig = figure;
plot(myfit, freq, deltaI)
title(Hyp_v{i}, 'Interpreter', 'None')
annotation('textbox',[0.2 0.2 0 0 ], 'String', strcat('R^2:',num2str(gof.rsquare,'%4.2f')))
subtitle(strcat('(Bx, Bz)=(',num2str(Bx_v(i)),',',num2str(Bz_v(i)),') / (Btot,theta)=(',num2str(Btot_v(i)),',',num2str(angle_v(i)),')'))
xlabel('Frequency (GHz)')
ylabel('Delta I (pA)')
exportgraphics(fig,fullfile('Figures',strrep(filename,'tf','png')),'Resolution',300)

% Store values for field dependence
hypf0_v(i) = myfit.f0;
hypI1_v(i) = myfit.I1;
hypIoff_v(i) = myfit.Ioff;
hypdeltaf_v(i) = myfit.deltaf;

% Store values for error bars (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
conf = confint(myfit);
hypI1neg_v(i) = conf(1)-myfit.I1;
hypI1pos_v(i) = conf(2)-myfit.I1;
hypIoffneg_v(i) = conf(3)-myfit.Ioff;
hypIoffpos_v(i) = conf(4)-myfit.Ioff;
hypdeltafneg_v(i) = conf(7)-myfit.deltaf;
hypdeltafpos_v(i) = conf(8)-myfit.deltaf;
hypf0neg_v(i) = conf(9)-myfit.f0;
hypf0pos_v(i) = conf(10)-myfit.f0;

%% Some spectra are not fitted correctly so adjust starting values per hand

filename = 'ESR_870.tf';

% find index
i = find(contains(Hyp_v,'ESR_870'));

% Open file and load data
fid = fopen(filename);
data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
fclose(fid);
freq = data{1}*1E-9; %GHz
lockin = data{7};

% Convert lockin to change in current
deltaI = lockin * (sens/10/gain) * 2*sqrt(2)*pi/4 * 10^12; %pA

%Initialize parameters
n = 8;
gammai = gamma_v(i);
alphai = alpha_v(i);
deltafi = 0.05;
f0i = 24.15; 
I1i = 1;
Ioffi = Ioff_v(i);

% define fit model
ft = fittype( 'SumFitFanos(f,f0,I1,gamma,alpha,Ioff,n,deltaf)', 'Independent', 'f');
% Set limits and starting coefficients (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
options = fitoptions(ft);
options.Lower = [0, min(deltaI) , alphai, 0, min(freq), gammai, n];
options.Upper = [100, max(deltaI), alphai, 1, max(freq), gammai, n];
options.StartPoint = [I1i, Ioffi, alphai, deltafi, f0i, gammai, n];
% Perform fit
[myfit,gof] = fit(freq, deltaI, ft, options);

hypgof_v(i) = gof.rsquare;
% Plot fit results
fig = figure;
plot(myfit, freq, deltaI)
title(Hyp_v{i}, 'Interpreter', 'None')
annotation('textbox',[0.2 0.2 0 0 ], 'String', strcat('R^2:',num2str(gof.rsquare,'%4.2f')))
subtitle(strcat('(Bx, Bz)=(',num2str(Bx_v(i)),',',num2str(Bz_v(i)),') / (Btot,theta)=(',num2str(Btot_v(i)),',',num2str(angle_v(i)),')'))
xlabel('Frequency (GHz)')
ylabel('Delta I (pA)')
exportgraphics(fig,fullfile('Figures',strrep(filename,'tf','png')),'Resolution',300)

% Store values for field dependence
hypf0_v(i) = myfit.f0;
hypI1_v(i) = myfit.I1;
hypIoff_v(i) = myfit.Ioff;
hypdeltaf_v(i) = myfit.deltaf;

% Store values for error bars (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
conf = confint(myfit);
hypI1neg_v(i) = conf(1)-myfit.I1;
hypI1pos_v(i) = conf(2)-myfit.I1;
hypIoffneg_v(i) = conf(3)-myfit.Ioff;
hypIoffpos_v(i) = conf(4)-myfit.Ioff;
hypdeltafneg_v(i) = conf(7)-myfit.deltaf;
hypdeltafpos_v(i) = conf(8)-myfit.deltaf;
hypf0neg_v(i) = conf(9)-myfit.f0;
hypf0pos_v(i) = conf(10)-myfit.f0;

%% Some spectra are not fitted correctly so adjust starting values per hand

filename = 'ESR_895.tf';

% find index
i = find(contains(Hyp_v,'ESR_895'));

% Open file and load data
fid = fopen(filename);
data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
fclose(fid);
freq = data{1}*1E-9; %GHz
lockin = data{7};

% Convert lockin to change in current
deltaI = lockin * (sens/10/gain) * 2*sqrt(2)*pi/4 * 10^12; %pA

%Initialize parameters
n = 8;
gammai = gamma_v(i);
alphai = alpha_v(i);
deltafi = 0.05;
f0i = hypf0_v(i); 
I1i = 1;
Ioffi = Ioff_v(i);

% define fit model
ft = fittype( 'SumFitFanos(f,f0,I1,gamma,alpha,Ioff,n,deltaf)', 'Independent', 'f');
% Set limits and starting coefficients (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
options = fitoptions(ft);
options.Lower = [0, min(deltaI) , alphai, 0, min(freq), gammai, n];
options.Upper = [100, max(deltaI), alphai, 1, max(freq), gammai, n];
options.StartPoint = [I1i, Ioffi, alphai, deltafi, f0i, gammai, n];
% Perform fit
[myfit,gof] = fit(freq, deltaI, ft, options);

hypgof_v(i) = gof.rsquare;
% Plot fit results
fig = figure;
plot(myfit, freq, deltaI)
title(Hyp_v{i}, 'Interpreter', 'None')
annotation('textbox',[0.2 0.2 0 0 ], 'String', strcat('R^2:',num2str(gof.rsquare,'%4.2f')))
subtitle(strcat('(Bx, Bz)=(',num2str(Bx_v(i)),',',num2str(Bz_v(i)),') / (Btot,theta)=(',num2str(Btot_v(i)),',',num2str(angle_v(i)),')'))
xlabel('Frequency (GHz)')
ylabel('Delta I (pA)')
exportgraphics(fig,fullfile('Figures',strrep(filename,'tf','png')),'Resolution',300)

% Store values for field dependence
hypf0_v(i) = myfit.f0;
hypI1_v(i) = myfit.I1;
hypIoff_v(i) = myfit.Ioff;
hypdeltaf_v(i) = myfit.deltaf;

% Store values for error bars (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
conf = confint(myfit);
hypI1neg_v(i) = conf(1)-myfit.I1;
hypI1pos_v(i) = conf(2)-myfit.I1;
hypIoffneg_v(i) = conf(3)-myfit.Ioff;
hypIoffpos_v(i) = conf(4)-myfit.Ioff;
hypdeltafneg_v(i) = conf(7)-myfit.deltaf;
hypdeltafpos_v(i) = conf(8)-myfit.deltaf;
hypf0neg_v(i) = conf(9)-myfit.f0;
hypf0pos_v(i) = conf(10)-myfit.f0;

%% Some spectra are not fitted correctly so adjust starting values per hand

filename = 'ESR_975.tf';

% find index
i = find(contains(Hyp_v,'ESR_975'));

% Open file and load data
fid = fopen(filename);
data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
fclose(fid);
freq = data{1}*1E-9; %GHz
lockin = data{7};

% Convert lockin to change in current
deltaI = lockin * (sens/10/gain) * 2*sqrt(2)*pi/4 * 10^12; %pA

%Initialize parameters
n = 8;
gammai = gamma_v(i);
alphai = alpha_v(i);
deltafi = 0.02;
f0i = 24.25; 
I1i = 0.5;
Ioffi = Ioff_v(i);

% define fit model
ft = fittype( 'SumFitFanos(f,f0,I1,gamma,alpha,Ioff,n,deltaf)', 'Independent', 'f');
% Set limits and starting coefficients (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
options = fitoptions(ft);
options.Lower = [0, min(deltaI) , alphai, 0, min(freq), gammai, n];
options.Upper = [100, max(deltaI), alphai, 1, max(freq), gammai, n];
options.StartPoint = [I1i, Ioffi, alphai, deltafi, f0i, gammai, n];
% Perform fit
[myfit,gof] = fit(freq, deltaI, ft, options);

hypgof_v(i) = gof.rsquare;
% Plot fit results
fig = figure;
plot(myfit, freq, deltaI)
title(Hyp_v{i}, 'Interpreter', 'None')
annotation('textbox',[0.2 0.2 0 0 ], 'String', strcat('R^2:',num2str(gof.rsquare,'%4.2f')))
subtitle(strcat('(Bx, Bz)=(',num2str(Bx_v(i)),',',num2str(Bz_v(i)),') / (Btot,theta)=(',num2str(Btot_v(i)),',',num2str(angle_v(i)),')'))
xlabel('Frequency (GHz)')
ylabel('Delta I (pA)')
exportgraphics(fig,fullfile('Figures',strrep(filename,'tf','png')),'Resolution',300)

% Store values for field dependence
hypf0_v(i) = myfit.f0;
hypI1_v(i) = myfit.I1;
hypIoff_v(i) = myfit.Ioff;
hypdeltaf_v(i) = myfit.deltaf;

% Store values for error bars (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
conf = confint(myfit);
hypI1neg_v(i) = conf(1)-myfit.I1;
hypI1pos_v(i) = conf(2)-myfit.I1;
hypIoffneg_v(i) = conf(3)-myfit.Ioff;
hypIoffpos_v(i) = conf(4)-myfit.Ioff;
hypdeltafneg_v(i) = conf(7)-myfit.deltaf;
hypdeltafpos_v(i) = conf(8)-myfit.deltaf;
hypf0neg_v(i) = conf(9)-myfit.f0;
hypf0pos_v(i) = conf(10)-myfit.f0;

%% Some spectra are not fitted correctly so adjust starting values per hand

filename = 'ESR_A073.tf';

% find index
i = find(contains(Hyp_v,'ESR_A073'));

% Open file and load data
fid = fopen(filename);
data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
fclose(fid);
freq = data{1}*1E-9; %GHz
lockin = data{7};

% Convert lockin to change in current
deltaI = lockin * (sens/10/gain) * 2*sqrt(2)*pi/4 * 10^12; %pA

%Initialize parameters
n = 8;
gammai = gamma_v(i);
alphai = alpha_v(i);
deltafi = 0.065;
f0i = 24.05; 
I1i = 0.5;
Ioffi = Ioff_v(i);

% define fit model
ft = fittype( 'SumFitFanos(f,f0,I1,gamma,alpha,Ioff,n,deltaf)', 'Independent', 'f');
% Set limits and starting coefficients (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
options = fitoptions(ft);
options.Lower = [0, min(deltaI) , alphai, 0, min(freq), gammai, n];
options.Upper = [100, max(deltaI), alphai, 1, max(freq), gammai, n];
options.StartPoint = [I1i, Ioffi, alphai, deltafi, f0i, gammai, n];
% Perform fit
[myfit,gof] = fit(freq, deltaI, ft, options);

hypgof_v(i) = gof.rsquare;
% Plot fit results
fig = figure;
plot(myfit, freq, deltaI)
title(Hyp_v{i}, 'Interpreter', 'None')
annotation('textbox',[0.2 0.2 0 0 ], 'String', strcat('R^2:',num2str(gof.rsquare,'%4.2f')))
subtitle(strcat('(Bx, Bz)=(',num2str(Bx_v(i)),',',num2str(Bz_v(i)),') / (Btot,theta)=(',num2str(Btot_v(i)),',',num2str(angle_v(i)),')'))
xlabel('Frequency (GHz)')
ylabel('Delta I (pA)')
exportgraphics(fig,fullfile('Figures',strrep(filename,'tf','png')),'Resolution',300)

% Store values for field dependence
hypf0_v(i) = myfit.f0;
hypI1_v(i) = myfit.I1;
hypIoff_v(i) = myfit.Ioff;
hypdeltaf_v(i) = myfit.deltaf;

% Store values for error bars (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
conf = confint(myfit);
hypI1neg_v(i) = conf(1)-myfit.I1;
hypI1pos_v(i) = conf(2)-myfit.I1;
hypIoffneg_v(i) = conf(3)-myfit.Ioff;
hypIoffpos_v(i) = conf(4)-myfit.Ioff;
hypdeltafneg_v(i) = conf(7)-myfit.deltaf;
hypdeltafpos_v(i) = conf(8)-myfit.deltaf;
hypf0neg_v(i) = conf(9)-myfit.f0;
hypf0pos_v(i) = conf(10)-myfit.f0;

%% Some spectra are not fitted correctly so adjust starting values per hand

filename = 'ESR_A155.tf';

% find index
i = find(contains(Hyp_v,'ESR_A155'));

% Open file and load data
fid = fopen(filename);
data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
fclose(fid);
freq = data{1}*1E-9; %GHz
lockin = data{7};

% Convert lockin to change in current
deltaI = lockin * (sens/10/gain) * 2*sqrt(2)*pi/4 * 10^12; %pA

%Initialize parameters
n = 8;
gammai = gamma_v(i);
alphai = alpha_v(i);
deltafi = 0.015;
f0i = 24.35; 
I1i = 0.45;
Ioffi = 0.5;

% define fit model
ft = fittype( 'SumFitFanos(f,f0,I1,gamma,alpha,Ioff,n,deltaf)', 'Independent', 'f');
% Set limits and starting coefficients (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
options = fitoptions(ft);
options.Lower = [0, min(deltaI) , alphai, 0, min(freq), gammai, n];
options.Upper = [100, max(deltaI), alphai, 1, max(freq), gammai, n];
options.StartPoint = [I1i, Ioffi, alphai, deltafi, f0i, gammai, n];
% Perform fit
[myfit,gof] = fit(freq, deltaI, ft, options);

hypgof_v(i) = gof.rsquare;
% Plot fit results
fig = figure;
plot(myfit, freq, deltaI);
title(Hyp_v{i}, 'Interpreter', 'None')
annotation('textbox',[0.2 0.2 0 0 ], 'String', strcat('R^2:',num2str(gof.rsquare,'%4.2f')))
subtitle(strcat('(Bx, Bz)=(',num2str(Bx_v(i)),',',num2str(Bz_v(i)),') / (Btot,theta)=(',num2str(Btot_v(i)),',',num2str(angle_v(i)),')'))
xlabel('Frequency (GHz)')
ylabel('Delta I (pA)')
exportgraphics(fig,fullfile('Figures',strrep(filename,'tf','png')),'Resolution',300)

% Store values for field dependence
hypf0_v(i) = myfit.f0;
hypI1_v(i) = myfit.I1;
hypIoff_v(i) = myfit.Ioff;
hypdeltaf_v(i) = myfit.deltaf;

% Store values for error bars (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
conf = confint(myfit);
hypI1neg_v(i) = conf(1)-myfit.I1;
hypI1pos_v(i) = conf(2)-myfit.I1;
hypIoffneg_v(i) = conf(3)-myfit.Ioff;
hypIoffpos_v(i) = conf(4)-myfit.Ioff;
hypdeltafneg_v(i) = conf(7)-myfit.deltaf;
hypdeltafpos_v(i) = conf(8)-myfit.deltaf;
hypf0neg_v(i) = conf(9)-myfit.f0;
hypf0pos_v(i) = conf(10)-myfit.f0;

%% Some spectra are not fitted correctly so adjust starting values per hand

filename = 'ESR_878.tf';

% find index
i = find(contains(Hyp_v,'ESR_878'));

% Open file and load data
fid = fopen(filename);
data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
fclose(fid);
freq = data{1}*1E-9; %GHz
lockin = data{7};

% Convert lockin to change in current
deltaI = lockin * (sens/10/gain) * 2*sqrt(2)*pi/4 * 10^12; %pA

%Initialize parameters
n = 8;
gammai = gamma_v(i);
alphai = alpha_v(i);
deltafi = 0.025;
f0i = 24.35; 
I1i = 0.45;
Ioffi = 0.5;

% define fit model
ft = fittype( 'SumFitFanos(f,f0,I1,gamma,alpha,Ioff,n,deltaf)', 'Independent', 'f');
% Set limits and starting coefficients (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
options = fitoptions(ft);
options.Lower = [0, min(deltaI) , alphai, 0, min(freq), gammai, n];
options.Upper = [100, max(deltaI), alphai, 1, max(freq), gammai, n];
options.StartPoint = [I1i, Ioffi, alphai, deltafi, f0i, gammai, n];
% Perform fit
[myfit,gof] = fit(freq, deltaI, ft, options);

hypgof_v(i) = gof.rsquare;
% Plot fit results
fig = figure;
plot(myfit, freq, deltaI);
title(Hyp_v{i}, 'Interpreter', 'None')
annotation('textbox',[0.2 0.2 0 0 ], 'String', strcat('R^2:',num2str(gof.rsquare,'%4.2f')))
subtitle(strcat('(Bx, Bz)=(',num2str(Bx_v(i)),',',num2str(Bz_v(i)),') / (Btot,theta)=(',num2str(Btot_v(i)),',',num2str(angle_v(i)),')'))
xlabel('Frequency (GHz)')
ylabel('Delta I (pA)')
exportgraphics(fig,fullfile('Figures',strrep(filename,'tf','png')),'Resolution',300)

% Store values for field dependence
hypf0_v(i) = myfit.f0;
hypI1_v(i) = myfit.I1;
hypIoff_v(i) = myfit.Ioff;
hypdeltaf_v(i) = myfit.deltaf;

% Store values for error bars (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
conf = confint(myfit);
hypI1neg_v(i) = conf(1)-myfit.I1;
hypI1pos_v(i) = conf(2)-myfit.I1;
hypIoffneg_v(i) = conf(3)-myfit.Ioff;
hypIoffpos_v(i) = conf(4)-myfit.Ioff;
hypdeltafneg_v(i) = conf(7)-myfit.deltaf;
hypdeltafpos_v(i) = conf(8)-myfit.deltaf;
hypf0neg_v(i) = conf(9)-myfit.f0;
hypf0pos_v(i) = conf(10)-myfit.f0;

%% Some spectra are not fitted correctly so adjust starting values per hand

filename = 'ESR_902.tf';

% find index
i = find(contains(Hyp_v,'ESR_902'));

% Open file and load data
fid = fopen(filename);
data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
fclose(fid);
freq = data{1}*1E-9; %GHz
lockin = data{7};

% Convert lockin to change in current
deltaI = lockin * (sens/10/gain) * 2*sqrt(2)*pi/4 * 10^12; %pA

%Initialize parameters
n = 8;
gammai = gamma_v(i);
alphai = alpha_v(i);
deltafi = 0.01;
f0i = 24.35; 
I1i = 0.45;
Ioffi = 0.5;

% define fit model
ft = fittype( 'SumFitFanos(f,f0,I1,gamma,alpha,Ioff,n,deltaf)', 'Independent', 'f');
% Set limits and starting coefficients (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
options = fitoptions(ft);
options.Lower = [0, min(deltaI) , alphai, 0, min(freq), gammai, n];
options.Upper = [100, max(deltaI), alphai, 1, max(freq), gammai, n];
options.StartPoint = [I1i, Ioffi, alphai, deltafi, f0i, gammai, n];
% Perform fit
[myfit,gof] = fit(freq, deltaI, ft, options);

hypgof_v(i) = gof.rsquare;
% Plot fit results
fig = figure;
plot(myfit, freq, deltaI);
title(Hyp_v{i}, 'Interpreter', 'None')
annotation('textbox',[0.2 0.2 0 0 ], 'String', strcat('R^2:',num2str(gof.rsquare,'%4.2f')))
subtitle(strcat('(Bx, Bz)=(',num2str(Bx_v(i)),',',num2str(Bz_v(i)),') / (Btot,theta)=(',num2str(Btot_v(i)),',',num2str(angle_v(i)),')'))
xlabel('Frequency (GHz)')
ylabel('Delta I (pA)')
exportgraphics(fig,fullfile('Figures',strrep(filename,'tf','png')),'Resolution',300)

% Store values for field dependence
hypf0_v(i) = myfit.f0;
hypI1_v(i) = myfit.I1;
hypIoff_v(i) = myfit.Ioff;
hypdeltaf_v(i) = myfit.deltaf;

% Store values for error bars (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
conf = confint(myfit);
hypI1neg_v(i) = conf(1)-myfit.I1;
hypI1pos_v(i) = conf(2)-myfit.I1;
hypIoffneg_v(i) = conf(3)-myfit.Ioff;
hypIoffpos_v(i) = conf(4)-myfit.Ioff;
hypdeltafneg_v(i) = conf(7)-myfit.deltaf;
hypdeltafpos_v(i) = conf(8)-myfit.deltaf;
hypf0neg_v(i) = conf(9)-myfit.f0;
hypf0pos_v(i) = conf(10)-myfit.f0;

%% Some spectra are not fitted correctly so adjust starting values per hand

filename = 'ESR_A044.tf';

% find index
i = find(contains(Hyp_v,'ESR_A044'));

% Open file and load data
fid = fopen(filename);
data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
fclose(fid);
freq = data{1}*1E-9; %GHz
lockin = data{7};

% Convert lockin to change in current
deltaI = lockin * (sens/10/gain) * 2*sqrt(2)*pi/4 * 10^12; %pA

%Initialize parameters
n = 8;
gammai = gamma_v(i);
alphai = alpha_v(i);
deltafi = 0.06;
f0i = 24.2; 
I1i = 0.45;
Ioffi = 0.5;

% define fit model
ft = fittype( 'SumFitFanos(f,f0,I1,gamma,alpha,Ioff,n,deltaf)', 'Independent', 'f');
% Set limits and starting coefficients (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
options = fitoptions(ft);
options.Lower = [0, min(deltaI) , alphai, 0, min(freq), gammai, n];
options.Upper = [100, max(deltaI), alphai, 1, max(freq), gammai, n];
options.StartPoint = [I1i, Ioffi, alphai, deltafi, f0i, gammai, n];
% Perform fit
[myfit,gof] = fit(freq, deltaI, ft, options);

hypgof_v(i) = gof.rsquare;
% Plot fit results
fig = figure;
plot(myfit, freq, deltaI);
title(Hyp_v{i}, 'Interpreter', 'None')
annotation('textbox',[0.2 0.2 0 0 ], 'String', strcat('R^2:',num2str(gof.rsquare,'%4.2f')))
subtitle(strcat('(Bx, Bz)=(',num2str(Bx_v(i)),',',num2str(Bz_v(i)),') / (Btot,theta)=(',num2str(Btot_v(i)),',',num2str(angle_v(i)),')'))
xlabel('Frequency (GHz)')
ylabel('Delta I (pA)')
exportgraphics(fig,fullfile('Figures',strrep(filename,'tf','png')),'Resolution',300)

% Store values for field dependence
hypf0_v(i) = myfit.f0;
hypI1_v(i) = myfit.I1;
hypIoff_v(i) = myfit.Ioff;
hypdeltaf_v(i) = myfit.deltaf;

% Store values for error bars (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
conf = confint(myfit);
hypI1neg_v(i) = conf(1)-myfit.I1;
hypI1pos_v(i) = conf(2)-myfit.I1;
hypIoffneg_v(i) = conf(3)-myfit.Ioff;
hypIoffpos_v(i) = conf(4)-myfit.Ioff;
hypdeltafneg_v(i) = conf(7)-myfit.deltaf;
hypdeltafpos_v(i) = conf(8)-myfit.deltaf;
hypf0neg_v(i) = conf(9)-myfit.f0;
hypf0pos_v(i) = conf(10)-myfit.f0;

%% Some spectra are not fitted correctly so adjust starting values per hand

filename = 'ESR_A188.tf';

% find index
i = find(contains(Hyp_v,'ESR_A188'));

% Open file and load data
fid = fopen(filename);
data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
fclose(fid);
freq = data{1}*1E-9; %GHz
lockin = data{7};

% Convert lockin to change in current
deltaI = lockin * (sens/10/gain) * 2*sqrt(2)*pi/4 * 10^12; %pA

%Initialize parameters
n = 8;
gammai = gamma_v(i);
alphai = alpha_v(i);
deltafi = 0.06;
f0i = 24.1; 
I1i = 0.45;
Ioffi = 0.5;

% define fit model
ft = fittype( 'SumFitFanos(f,f0,I1,gamma,alpha,Ioff,n,deltaf)', 'Independent', 'f');
% Set limits and starting coefficients (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
options = fitoptions(ft);
options.Lower = [0, min(deltaI) , alphai, 0, min(freq), gammai, n];
options.Upper = [100, max(deltaI), alphai, 1, max(freq), gammai, n];
options.StartPoint = [I1i, Ioffi, alphai, deltafi, f0i, gammai, n];
% Perform fit
[myfit,gof] = fit(freq, deltaI, ft, options);

hypgof_v(i) = gof.rsquare;
% Plot fit results
fig = figure;
plot(myfit, freq, deltaI);
title(Hyp_v{i}, 'Interpreter', 'None')
annotation('textbox',[0.2 0.2 0 0 ], 'String', strcat('R^2:',num2str(gof.rsquare,'%4.2f')))
subtitle(strcat('(Bx, Bz)=(',num2str(Bx_v(i)),',',num2str(Bz_v(i)),') / (Btot,theta)=(',num2str(Btot_v(i)),',',num2str(angle_v(i)),')'))
xlabel('Frequency (GHz)')
ylabel('Delta I (pA)')
exportgraphics(fig,fullfile('Figures',strrep(filename,'tf','png')),'Resolution',300)

% Store values for field dependence
hypf0_v(i) = myfit.f0;
hypI1_v(i) = myfit.I1;
hypIoff_v(i) = myfit.Ioff;
hypdeltaf_v(i) = myfit.deltaf;

% Store values for error bars (order coefs: I1, Ioff, alpha, deltaf, f0, gamma, n)
conf = confint(myfit);
hypI1neg_v(i) = conf(1)-myfit.I1;
hypI1pos_v(i) = conf(2)-myfit.I1;
hypIoffneg_v(i) = conf(3)-myfit.Ioff;
hypIoffpos_v(i) = conf(4)-myfit.Ioff;
hypdeltafneg_v(i) = conf(7)-myfit.deltaf;
hypdeltafpos_v(i) = conf(8)-myfit.deltaf;
hypf0neg_v(i) = conf(9)-myfit.f0;
hypf0pos_v(i) = conf(10)-myfit.f0;

%% Plot results

figure;
plot(angle_v, hypgof_v, 'o')
xlabel('Angle Bxz')
ylabel('Goodness of fit')

figure;
errorbar(angle_v, hypf0_v, hypf0neg_v, hypf0pos_v, 'o')
xlabel('Angle Bxz')
ylabel('Center frequency (GHz)')

figure;
errorbar(angle_v, hypI1_v, hypI1neg_v, hypI1pos_v, 'o')
xlabel('Angle Bxz')
ylabel('Peak intensity (pA)')

figure;
errorbar(angle_v, hypIoff_v, hypIoffneg_v, hypIoffpos_v, 'o')
xlabel('Angle Bxz')
ylabel('Offset (pA)')

figure;
errorbar(angle_v, hypdeltaf_v, hypdeltafneg_v, hypdeltafpos_v, 'o')
xlabel('Angle Bxz')
ylabel('Hyperfine splitting (GHz)')


%% Save parameters
clear fig
save('variablesVertical.mat')