function res = FitFano(f,f0,I1,gamma,alpha,Ioff)
%Same function as in J. Kim et al, PRB 104, 174408 (2021)
%   f frequency vector
%   f0 resonance frequency
%   I1 intensity of the resonance
%   gamma linewidth of the resonance
%   Ioff intensity offset
delta = (f - f0)./(gamma/2);
res = Ioff + I1 * (1 + alpha*delta)./(1+delta.^2);
end

