clear all
close all

%% Load data

load('variablesVertical.mat')

%% First go through all files to set up common frequency

minfreq = 1e20;
maxfreq = 0;
mindelta = 1e20;

for i = 1:size(Hyp_v)
    filename = strcat(Hyp_v{i},'.tf');
    
    % Open file and load data
    fid = fopen(filename);
    data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
    fclose(fid);
    freq = data{1}*1E-9; %GHz
    
    % center frequency around hyperfine peaks
    freq = freq - (hypf0_v(i)+3.5*hypdeltaf_v(i));
    
    minfreq = min( minfreq, min(freq) );
    maxfreq = max( maxfreq, max(freq) );
    mindelta = min( mindelta, min(abs(freq(1)-freq(2))) );
end

%% Set up angle and frequency

angle_all = -180:5:180;

freq_all_v = minfreq:mindelta:maxfreq;

deltaI_all_v = zeros( length(angle_all), length(freq_all_v) );

for i=1:length(angle_all)
    % find the matching angle and thereby file
    [~,indexi] = min( abs(angle_v - angle_all(i)) );
    filename = strcat(Hyp_v{indexi},'.tf');
    
    % Open file and load data
    fid = fopen(filename);
    data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
    fclose(fid);
    freq = data{1}*1E-9; %GHz
    lockin = data{7};
    
    % Convert lockin to change in current
    deltaI = lockin * (sens/10/gain) * 2*sqrt(2)*pi/4 * 10^12; %pA
    
    % center frequency around hyperfine peaks
    freq = freq - (hypf0_v(indexi)+3.5*hypdeltaf_v(indexi));
    
    for j=1:length(freq_all_v)
        [~,indexj] = min( abs( freq - freq_all_v(j) ) );
        if indexj==1
            deltaI_all_v(i,j) = NaN;
        else
            if indexj==length(freq)
                deltaI_all_v(i,j) = NaN;
            else
                deltaI_all_v(i,j) = deltaI(indexj);
            end
        end
        
    end
    
    mini = min(deltaI_all_v(i,:));
    maxi = max(deltaI_all_v(i,:));
    
    deltaI_all_v(i,:) = (deltaI_all_v(i,:)-mini)/(maxi-mini);
end

%% Plot results
min(deltaI_all_v,[],'all')
max(deltaI_all_v,[],'all')

figure;
imagesc(freq_all_v*10^3, angle_all, deltaI_all_v, 'AlphaData',~isnan(deltaI_all_v))
xlim([-300, 300])
xticks([-300, -200, -100, 0, 100, 200, 300])
yticks([-180, -90, 0, 90, 180])
c = colorbar;
caxis([min(deltaI_all_v,[],'all') max(deltaI_all_v,[],'all')])
c.Label.String = '\Delta I (pA)';
xlabel('Frequency f-f0 (MHz)')
ylabel('Angle of external field')

%% Load data

load('variablesHorizontal.mat')

%% First go through all files to set up common frequency

minfreq = 1e20;
maxfreq = 0;
mindelta = 1e20;

for i = 1:size(Hyp_h)
    filename = strcat(Hyp_h{i},'.tf');
    
    % Open file and load data
    fid = fopen(filename);
    data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
    fclose(fid);
    freq = data{1}*1E-9; %GHz
    
    % center frequency around hyperfine peaks
    freq = freq - (hypf0_h(i)+3.5*hypdeltaf_h(i));
    
    minfreq = min( minfreq, min(freq) );
    maxfreq = max( maxfreq, max(freq) );
    mindelta = min( mindelta, min(abs(freq(1)-freq(2))) );
end

%% Set up angle and frequency

freq_all_h = minfreq:mindelta:maxfreq;

deltaI_all_h = zeros( length(angle_all), length(freq_all_h) );

for i=1:length(angle_all)
    % find the matching angle and thereby file
    [~,indexi] = min( abs(angle_h - angle_all(i)) );
    filename = strcat(Hyp_h{indexi},'.tf');
    
    % Open file and load data
    fid = fopen(filename);
    data = textscan(fid, '%f %f %f %f %f %f %f %f %f %f %f', 'headerlines', 17);
    fclose(fid);
    freq = data{1}*1E-9; %GHz
    lockin = data{7};
    
    % Convert lockin to change in current
    deltaI = lockin * (sens/10/gain) * 2*sqrt(2)*pi/4 * 10^12; %pA
    
    % center frequency around hyperfine peaks
    freq = freq - (hypf0_h(indexi)+3.5*hypdeltaf_h(indexi));
    
    for j=1:length(freq_all_h)
        [~,indexj] = min( abs( freq - freq_all_h(j) ) );
        if indexj==1
            deltaI_all_h(i,j) = NaN;
        else
            if indexj==length(freq)
                deltaI_all_h(i,j) = NaN;
            else
                deltaI_all_h(i,j) = deltaI(indexj);
            end
        end
    end
    
    mini = min(deltaI_all_h(i,:));
    maxi = max(deltaI_all_h(i,:));
    
    deltaI_all_h(i,:) = (deltaI_all_h(i,:)-mini)/(maxi-mini);
end

%% Plot results
min(deltaI_all_h,[],'all')
max(deltaI_all_h,[],'all')

figure;
imagesc(freq_all_h*10^3, angle_all, deltaI_all_h,'AlphaData',~isnan(deltaI_all_h))
xlim([-200, 200])
xticks([-200, -100, 0, 100, 200])
yticks([-180, -90, 0, 90, 180])
c = colorbar;
caxis([min(deltaI_all_h,[],'all') max(deltaI_all_h,[],'all')])
c.Label.String = '\Delta I (pA)';
xlabel('Frequency f-f0 (MHz)')
ylabel('Angle of external field')