# -*- coding: utf-8 -*-
"""
Created on Wed Jun 28 11:43:18 2023

@author: lmveldman
"""

import os
import sys
import inspect

### CHANGING TO CORRECT DIRECTORY
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
grandparentdir = os.path.dirname(parentdir)
sys.path.insert(0, grandparentdir) 

from data_analysis_functions import *
from simulation_functions_v3 import *
from scipy.ndimage.filters import gaussian_filter1d

y = 'Lock-In Y (V)'
x = 'Frequency (Hz)'
colors = 'magma_r'

### initilize figure:
fig, axs = plt.subplots(2,3,figsize=(6.4*1.7,4.8*1), gridspec_kw={'width_ratios': [1, 1, 1]})
for k in range(2):
    for l in range(3):
        axs[k,l].tick_params(direction='in')
        
### getting data names
datas = [ [list(range(572,622)),list(range(285,310)),list(range(345,389))],[list(range(389,440)),list(range(521,572)),list(range(756,807))]]
folders = [ ['../data/single_atom/','../data/dimer/','../data/trimer/'],['../data/tetramer/','../data/pentamer/','../data/y-chain/'] ]
datalengths = [ [230,217,461], [563,459,346] ]

for k in range(2):
    for l in range(3):
        files = GenList(datas[k][l],'ESR_A{}.tf')
        current = []
        z = np.zeros(datalengths[k][l])
        for i,name in enumerate(files):
            file = folders[k][l] + name
            data, header = ReadFile_ESR(file)
            currentstpt = float(header[1][3])*1e12
            current.append(round(currentstpt,4))
            
            ############ remove NaN values in x and y data
            ydat = np.array(data[y])[~np.isnan(np.array(data[y]))]
            xdat = np.array(data[x])[~np.isnan(np.array(data[x]))]
            
            ############# Convert axes to correct units
            freq = xdat*10**-9 #- popt_hyp[i+2][0]
            Delta_I = LItoA_ESR(ydat,0.05,10**10)
            
            if k == 1 and l==2:
                freq = freq[ : -1]
                Delta_I = Delta_I[ : -1] * -1
             
            z = np.column_stack((z,Delta_I))
        
        z = np.delete(z, 0, 1) #delete row of zeros from initialization
        
        im = axs[k][l].pcolor(current,freq,z, cmap=colors)
        axs[k][l].set_ylabel('Frequency (GHz)')
        axs[k][l].set_xlabel('Setpoint current (pA)')
        axs[k][l].set_xlim([40,90])
        axs[k][l].set_ylim([11.6,13.5])
        cbar = fig.colorbar(im,ax=axs[k][l])#,ticks=[-0.1,0.1])
        cbar.set_label(r'$\Delta I$ (pA)')
        plt.tight_layout()
plt.savefig('../plots/structures_esr.pdf')