# -*- coding: utf-8 -*-
"""
Created on Tue Jun 27 13:38:52 2023

@author: lmveldman
"""

import os
import sys
import inspect

### CHANGING TO CORRECT DIRECTORY
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
grandparentdir = os.path.dirname(parentdir)
sys.path.insert(0, grandparentdir) 

from data_analysis_functions import *
from simulation_functions_v3 import *
from scipy.ndimage.filters import gaussian_filter1d

files = ['ESR_167.tf','ESR_248.tf']

y = 'Lock-In Y (V)'
x = 'Frequency (Hz)'

### INITIAL GUESSES ###
#(f,f_0_A,f_0_B,Gamma_A,Gamma_B,q_A,q_B,A,Delta_F,I_A,I_B,I_C,I_D)
p0 = [ 
    [12.6,0.1,0,0,0.05,0.35,0.05],
    [11.25,11.7,0.03,0.05,0.2,0.2,0,0.230,0.04,0.01,0.08,0.01]]

bias = []
for i,name in enumerate(files):
    ########### import and read files
    file = '../data/'+ name
    data, header = ReadFile_ESR(file)
    currentstpt = float(header[1][3])*1e12
    biasstpt = float(header[1][4])*1000
    bias.append(round(biasstpt))
    
    ############ remove NaN values in x and y data if present
    ydat = np.array(data[y])[~np.isnan(np.array(data[y]))]
    xdat = np.array(data[x])[~np.isnan(np.array(data[x]))]
    
    ############# Convert axes to correct units
    freq = xdat*10**-9
    Delta_I = LItoA_ESR(ydat,0.01,10**9)
    
    ############# Fitting parameters:  f,f_0,Gamma,q,A,Delta_F,I_A,I_B
    if i == 0:
        popt, pcov = curve_fit(Two_Fano, freq, Delta_I, p0=p0[i])
    if i ==1:
        popt, pcov = curve_fit(Four_Fano, freq, Delta_I, p0=p0[i])
    
    plt.figure(figsize=(6.4/1.5,4.8/1.5))
    if i == 0:
        plt.plot(freq,(Delta_I-popt[3])*1000,c='grey')
        plt.plot(freq, (Two_Fano(freq, *popt)-popt[3])*1000, c='black')
        plt.text(12.62, 200, '$\Delta f$'+' = {} MHz \n'.format(round(popt[4]*1000,1)),verticalalignment='top')
    if i == 1:
        plt.plot(freq,(Delta_I-popt[6])*1000,c='grey')
        plt.plot(freq, (Four_Fano(freq, *popt)-popt[6])*1000, c='black')
        plt.text(11.8, 700, '$\Delta f$'+' = {} MHz \n'.format(round(popt[7]*1000,1)),verticalalignment='top')
    plt.ylabel(r'$\Delta$I (fA)')
    plt.xlabel('Frequency (GHz)')
    plt.tight_layout()
    plt.savefig('../plots/dimer_fit_{}.pdf'.format(i))
   