# -*- coding: utf-8 -*-
"""
Created on Thu Jun 29 17:12:57 2023

@author: lmveldman
"""

import os
import sys
import inspect

### CHANGING TO CORRECT DIRECTORY
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
grandparentdir = os.path.dirname(parentdir)
sys.path.insert(0, grandparentdir) 

from data_analysis_functions import *
from simulation_functions_v3 import *
from scipy.ndimage.filters import gaussian_filter1d


##############################
### HAMILTONIAN PARAMETERS ###
##############################

x = [0,4.5,7.5,10.5,7.5,10.5]
y = [-0.5,0,2,4,-3,-6]
s = [0.5,0.5,0.5,0.5,0.5,0.5]

g = [ [1.95,1.98,1.75],
     [1.75,1.98,1.95],
     [1.75,1.98,1.95],
     [1.75,1.98,1.95],
     [1.75,1.98,1.95],
     [1.75,1.98,1.95]] #specify g-factor for each atom
T = 0.4 # [K]
D_0 = 0.165
field_angle = (90-15.5)*np.pi/180
tip_angle = 0
N = len(s) #number of atoms
dim = get_dim(s)
spin_mat = get_spin_mat(s)

############# J and D couplings determined from fit to dimer data:
r = get_r(x,y)
theta = get_angle(x,y)-field_angle
dec = 0.122
j_0 = 0.722
d_0 = 0.158

J,D = get_J_D_from_fit(r,theta,j_0,d_0,dec)

B = [0,0,0.480]
B_tip = [0,0,0.055]

tipspin = 0 # Spin that is affected by the tipfield and which is read out

### Plot structure (very optional)
# plot_structure(x,y)

#############################
### PLOT DENSITY MATRICES ###
#############################

field_list = [0.042,0.05510204,0.0575] #0575
# field_list = np.linspace(0.04,0.06,50)
for i in field_list:
    B_tip = [0,0,i]
    H = build_H_heis(dim,s,J) + build_H_zeeman(dim,s,g,B,B_tip,tipspin) + build_H_dipole(dim,s,D)
    
    ### Initial state
    psi = basis([2,2,2,2,2,2],[0,1,1,1,1,1])
    
    psi_energy = psi.transform(H.eigenstates()[1])
    mat = qutip.states.ket2dm(Qobj(psi_energy[0:7]))
    
    
    fig, ax = matrix_histogram(mat,limits=[-0.25,0.75],colorbar=0, options= {'cmap':'Reds'})

    ax.set_xticks([0.5,1.5,2.5,3.5,4.5,5.5,6.5],
           [r'$\left|0\right\rangle$',
            r'$\left|1\right\rangle$',
            r'$\left|2\right\rangle$',
            r'$\left|3\right\rangle$',
            r'$\left|4\right\rangle$',
            r'$\left|5\right\rangle$',
            r'$\left|6\right\rangle$'], rotation=0)
    
    ax.set_yticks([0.5,1.5,2.5,3.5,4.5,5.5,6.5],
           [r'$\left|0\right\rangle$',
            r'$\left|1\right\rangle$',
            r'$\left|2\right\rangle$',
            r'$\left|3\right\rangle$',
            r'$\left|4\right\rangle$',
            r'$\left|5\right\rangle$',
            r'$\left|6\right\rangle$'], rotation=0)
    
    plt.savefig('../plots/density_matrix_{}mT.pdf'.format(round(i*1000)))

