# -*- coding: utf-8 -*-
"""
Created on Mon Feb 27 11:53:58 2023

@author: lmveldman
"""

import os
import sys
import inspect

### CHANGING TO CORRECT DIRECTORY
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
grandparentdir = os.path.dirname(parentdir)
sys.path.insert(0, grandparentdir) 

from data_analysis_functions import *
from simulation_functions_v3 import *
from scipy.ndimage.filters import gaussian_filter1d

##############################
### HAMILTONIAN PARAMETERS ###
##############################

x = [0,4.5,]
y = [-0.5,0]
s = [0.5,0.5]
g = [ [1.95,1.98,1.75],
     [1.75,1.98,1.95]] #specify g-factor for each atom
T = 0.4 # [K]
D_0 = 0.165
field_angle = (90-15.5)*np.pi/180
tip_angle = 0
N = len(s) #number of atoms
dim = get_dim(s)
spin_mat = get_spin_mat(s)

############# J and D couplings determined from fit to dimer data:
r = get_r(x,y)
theta = get_angle(x,y)-field_angle
dec = 0.122
j_0 = 0.722
d_0 = 0.158

J,D = get_J_D_from_fit(r,theta,j_0,d_0,dec)
print(J)
print(D)

B = [0,0,0.480]
tipspin = 0 # Spin that is affected by the tipfield and which is read out

### Plot structure (very optional)
# plot_structure(x,y)

### Initialize figure
fig, axs = plt.subplots(1,3,figsize=(6.4*3/2,4.8/2), gridspec_kw={'width_ratios': [1, 3, 3]})
for i in axs:
    i.tick_params(direction='in')
    
########################
### PLOT EIGENSTATES ###
########################

energies = []
bmin = 0.048 # in Tesla
bmax = 0.061 # in Tesla
tip_sweep = np.linspace(bmin,bmax,50)    

for b in tip_sweep:
    B_tip = Build_B(b,tip_angle)
    H = build_H_heis(dim,s,J) + build_H_zeeman(dim,s,g,B,B_tip,tipspin) + build_H_dipole(dim,s,D)
    energy = H.eigenstates()[0]
    energies.append(energy)
    
im = axs[0].plot(np.transpose(np.transpose(energies)[1:N+1]),tip_sweep*1000,c='darkred')
axs[0].set_xlabel('Energy (GHz)')
axs[0].set_ylabel('Tip field (mT)')
axs[0].set_ylim(bmin*1000, bmax*1000)
axs[0].set_yticks([50,55,60])

#################################
### PLOT LINDBLAD SIMULATIONS ###
#################################

### DEFINING PARAMETERS FOR LINDBLAD SOLVER
T_1_e = 150  #ns
T_2_e = 50   #ns
stepsize = 0.1
tmin = int(0)
tmax = int(70)
times = np.linspace(tmin,tmax,int((tmax-tmin)/stepsize))

### CALCULATE
e_traces = []
n_traces = []
stepsize = 0.0005 # in Tesla
sweep = np.linspace(bmin,bmax,int((bmax-bmin)/stepsize))

### Initial state
psi = basis([2,2],[0,1])

for b in sweep:
    B_tip = Build_B(b,tip_angle)

    ### BUILDING HAMILTONIAN
    H = build_H_heis(dim,s,J) + build_H_zeeman(dim,s,g,B,B_tip,tipspin) + build_H_dipole(dim,s,D)

    ### LINDBLAD SOLVE
    M = solve_master_decay(H,psi,times,T_1_e,T_2_e,dim,N,0,s)
    # e_traces.append(M)
    e_traces.append(M[0][0])

### Optional Gaussian filtering to mimic tip shaking
smearing = 0.0025 # in Tesla
e_traces_filtered = []
for i in np.transpose(e_traces):
    e_traces_filtered.append(gaussian_filter1d(i, smearing/stepsize ))
e_traces_filtered = np.transpose(e_traces_filtered)

colors = 'RdBu'
im = axs[1].pcolor(times,sweep*1000,e_traces_filtered,cmap=colors)
axs[1].set_xlabel('Delta t (ns)')
axs[1].set_yticklabels([])
cbar = fig.colorbar(im,ax=axs[1],ticks=[])
cbar.set_label('<Sz> electron')

##############################
### PLOT EXPERIMENTAL DATA ###
##############################

# Convert lockin to number of electron per pulse
# Parameters for conversion
lockinfreq = 270 # frequency of the lockin (Hz)
lockinsens = 0.100 # lockin sensitivity (V)
nbprobepulse = 6172# number of probe pulses
gain = 10**11 # gain of the current amplifier (I/V)
qel = 1.602*10**-19 # charge of an electron in Coulomb

####### Generate list of names at file location
listfiles = GenList([511,510,509,508,507,506,505,504,503]+list(range(498,503))+[512,513],'../data/dimer/Pprobe_rev_00{}.dat')
npts = 600
x='Time delta (s)'
y='Lock-In Y (V)'
cut = [0,0]

### Fit using different fit types and subtract the exponential decay
M,t,c,M_fit = SubtractFit(listfiles=listfiles)

im = axs[2].pcolor(t,c,M,cmap=colors) 
axs[2].set_xlim([0,70])
axs[2].set_xlabel('Delta t (ns)')
axs[2].set_ylabel('Setpoint current (nA)')
cbar = fig.colorbar(im,ax=axs[2],ticks=[])
cbar.set_label('Pump-probe signal (a.u.)')

plt.tight_layout()
plt.savefig('../plots/fig_2_dimer.pdf')
