# -*- coding: utf-8 -*-
"""
Created on Wed Jun 28 16:59:10 2023

@author: lmveldman
"""

import os
import sys
import inspect

### CHANGING TO CORRECT DIRECTORY
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
grandparentdir = os.path.dirname(parentdir)
sys.path.insert(0, parentdir) 

from data_analysis_functions import *
from simulation_functions_v3 import *
from scipy.ndimage.filters import gaussian_filter1d


##############################
### HAMILTONIAN PARAMETERS ###
##############################

x = [0,4.5,8.5,12.5]
y = [-0.5,0,0,0]
s = [0.5,0.5,0.5,0.5]
g = [ [1.95,1.98,1.75],
     [1.75,1.98,1.95],
     [1.75,1.98,1.95], 
     [1.75,1.98,1.95]] # specify g-factor for each atom
T = 0.4 # [K]
D_0 = 0.165
field_angle = (90-15.5)*np.pi/180
tip_angle = 0
N = len(s) #number of atoms
dim = get_dim(s)
spin_mat = get_spin_mat(s)

############# J and D couplings determined from fit to dimer data:
r = get_r(x,y)
theta = get_angle(x,y)-field_angle
dec = 0.122
j_0 = 0.722
d_0 = 0.158

J,D = get_J_D_from_fit(r,theta,j_0,d_0,dec)
print(J)
print(D)

B = [0,0,0.480]
tipspin = 0 # Spin that is affected by the tipfield and which is read out

### Plot structure ### (very optional)
# plot_structure(x,y)

### Initialize figure
fig, axs = plt.subplots(1,2,figsize=(6.4,4.8/1.5), gridspec_kw={'width_ratios': [2, 1]})
for i in axs:
    i.tick_params(direction='in')
    
########################
### PLOT EIGENSTATES ###
########################

B_ext = 0.480
B_tip = 0.100
B_angle = 0

### number of sample points per hamiltonian part
B_pts = 500
Btip_pts = 150
B_sweep = np.linspace(B_ext/B_pts,B_ext,B_pts) #sweep range in T
Btip_sweep = np.linspace(B_tip/Btip_pts,B_tip,Btip_pts) #sweep range in T

energies = []

for b in B_sweep:
    B = Build_B(b,B_angle)
    H = build_H_heis(dim,s,J) + build_H_zeeman(dim,s,g,B,[0,0,0],tipspin)
    energy = H.eigenstates()[0]
    energies.append(energy)

for b in Btip_sweep:
    B = Build_B(b,B_angle)
    B_ext_max = Build_B(B_ext,B_angle)
    H = build_H_heis(dim,s,J) + build_H_zeeman(dim,s,g,B_ext_max,B,tipspin)
    energy = H.eigenstates()[0]
    energies.append(energy)
    
# Color cycler to make single magnon eigenstates different color
from cycler import cycler
colors = ['grey']
for i in range(4):
    colors.append('darkred')
for i in range(16):
    colors.append('grey')
custom_cycler = (cycler(color=colors))    
    
### PLOTTING ###
axs[0].set_prop_cycle(custom_cycler)
axs[0].plot(energies);
axs[0].axvline(x=B_pts,c='black',alpha=0.7) # plot separation lines
axs[0].set_ylabel('Energy (GHz)');
axs[0].set_ylim([-30,40]);
axs[0].set_xlim(0,B_pts+Btip_pts)
axs[0].set_xticks([B_pts/2,B_pts+Btip_pts/2],
       [
        r'$B_{ext}$ (mT)', 
        r'$B_{tip}$ (mT)'], rotation=0)

axs[1].plot([i* 1000 for i in Btip_sweep[40:Btip_pts-40]],np.transpose(np.transpose(energies[B_pts+40:B_pts+Btip_pts-40])[1:5]),c='darkred');
axs[1].set_ylabel('Energy (GHz)');
axs[1].set_xlabel(r'$B_{tip}$ (mT)');

plt.tight_layout()
plt.savefig('eigenstates.pdf')