# -*- coding: utf-8 -*-
"""
Created on Fri Feb  3 16:36:59 2023

@author: lmveldman
"""

### IMPORTING LIBRARIES ###

import pySPM
import pandas as pd
import os
import matplotlib.pyplot as plt
import matplotlib
from mpl_toolkits.axes_grid1.anchored_artists import (AnchoredSizeBar)
import matplotlib.font_manager as fm
import numpy as np
from scipy.optimize import curve_fit
import warnings
warnings.filterwarnings('ignore')

####################
### TOPOGRAPHIES ###
####################

def Get_Scan_Direction(TopoFile, JT = False):
    if JT ==False:
        data= pd.read_csv(TopoFile,nrows=75,encoding='latin1')
    else:
        data= pd.read_csv(TopoFile,nrows=50)
    df = pd.DataFrame(data=data)
    direction_ind = df.loc[df[':NANONIS_VERSION:'].str.contains(':SCAN_DIR:')].index
    direction =(df[':NANONIS_VERSION:'][direction_ind[0]+1])
    return direction

def Plot_Topo(filename, xlim = None, ylim = None, slope_correction = False, barsize = 2):
    fig,ax = plt.subplots()#figsize=(10,10))
    if slope_correction == False:
#         scan_TOPO = pySPM.SXM(filename).get_channel('Z').show(ax=ax,cmap= 'Blues_r')
        A = pySPM.SXM(filename).get_channel('Z')*1e12 #change to nm
        A.zero_min().show() #make zero minimum color value
        scan_TOPO = A.show(ax=ax,cmap= 'Blues_r')
        cbar = plt.colorbar(scan_TOPO,ax=ax,fraction=0.04,label='bla')
        cbar.set_label('\u0394 Z (pm)', rotation=270)
#         cbar.ax.set_ylabel('# of contacts', rotation=270)
    else:
        scan_TOPO = pySPM.SXM(filename).get_channel('Z').correct_plane(inline=False).show(ax=ax,cmap= 'Blues_r')
    plt.setp(plt.gcf().get_axes(), xticks=[], xlabel='', ylabel='', title='')
    plt.yticks([])
    direction = Get_Scan_Direction(filename)
    fontprops = fm.FontProperties(size=20)
    bar = AnchoredSizeBar(ax.transData, barsize, '{} nm'.format(barsize), 4, frameon=False, pad=1, fontproperties=fontprops, color="w",size_vertical=0.02,label_top=True)
    ax.add_artist(bar)
    if xlim != None:
        ax.set_xlim(xlim[0], xlim[1])
    if ylim != None:
        ax.set_ylim(ylim[0], ylim[1])
    if direction == 'down':
        ax.invert_yaxis()
    cbar.set_label('\u0394 Z (pm)', rotation=270, labelpad=15)

####################
### ESR ANALYSIS ###
####################

def ReadFile_ESR(file):
    header = pd.read_csv(file, sep = '\t', nrows = 17, names=[0,1]) 
    channels = header[1][15].split(';')
    names = []
    for i in range(len(channels)):
        names.append(channels[i])
    data = pd.read_csv(file, header = 16, sep='\t', names=names)
    return data, header


def LItoA_ESR(LIY,sens,gain):
    I_RMS = LIY*(sens/10)/gain
    Delta_I = I_RMS*2*np.sqrt(2)*np.pi/4
#     Delta_I = Delta_I-np.min(Delta_I)
    return Delta_I*10**12 #return in pA

def Fano(f,I_peak,f_0,Gamma,A,q):
    delta = (f-f_0)/(Gamma/2)
    return I_peak*(1+delta*2*q)/(1+delta**2) + A

def GenList(files, basename):
    listfiles =[]
    for i in files:
        listfiles.append(basename.format(i))
    return listfiles

def Normalise(data):
    norm = (data-min(data))/abs(max(data)-min(data))
#     norm = (data-sum(data)/len(data))
    return norm

#########################
### ESR FIT FUNCTIONS ###
########################

def Six_Fano(f,f_0,Gamma,q,A,Delta_F,
                I_A,I_B,I_C,I_D,I_E,I_F):
    f_0_A = f_0-2.5*Delta_F
    f_0_B = f_0-1.5*Delta_F
    f_0_C = f_0-0.5*Delta_F
    f_0_D = f_0+0.5*Delta_F
    f_0_E = f_0+1.5*Delta_F
    f_0_F = f_0+2.5*Delta_F
    delta_A = (f-f_0_A)/(Gamma/2)
    delta_B = (f-f_0_B)/(Gamma/2)
    delta_C = (f-f_0_C)/(Gamma/2)
    delta_D = (f-f_0_D)/(Gamma/2)
    delta_E = (f-f_0_E)/(Gamma/2)
    delta_F = (f-f_0_F)/(Gamma/2)
    return (I_A*(1+delta_A*2*q)/(1+delta_A**2) 
            + I_B*(1+delta_B*2*q)/(1+delta_B**2)
            + I_C*(1+delta_C*2*q)/(1+delta_C**2)
            + I_D*(1+delta_D*2*q)/(1+delta_D**2)
            + I_E*(1+delta_E*2*q)/(1+delta_E**2)
            + I_F*(1+delta_F*2*q)/(1+delta_F**2)
            +A
            )

def Two_Fano(f,f_0,Gamma,q,A,Delta_F,
                I_A,I_B):
    f_0_A = f_0
    f_0_B = f_0+Delta_F
    delta_A = (f-f_0_A)/(Gamma/2)
    delta_B = (f-f_0_B)/(Gamma/2)
    return (I_A*(1+delta_A*2*q)/(1+delta_A**2) 
            + I_B*(1+delta_B*2*q)/(1+delta_B**2)
            +A
            )

def Four_Fano(f,f_0_A,f_0_C,Gamma_A,Gamma_C,q_A,q_B,A,Delta_F,
                I_A,I_B,I_C,I_D):
    f_0_A = f_0_A
    f_0_B = f_0_A+Delta_F
    f_0_C = f_0_C
    f_0_D = f_0_C+Delta_F
    delta_A = (f-f_0_A)/(Gamma_A/2)
    delta_B = (f-f_0_B)/(Gamma_A/2)
    delta_C = (f-f_0_C)/(Gamma_C/2)
    delta_D = (f-f_0_D)/(Gamma_C/2)
    return (I_A*(1+delta_A*2*q_A)/(1+delta_A**2) 
            + I_B*(1+delta_B*2*q_A)/(1+delta_B**2)
            + I_C*(1+delta_C*2*q_B)/(1+delta_C**2)
            + I_D*(1+delta_D*2*q_B)/(1+delta_D**2)
            +A
            )

def Six_Fano_Boltzmann(f,f_0,Gamma,q,A,Delta_F,I,T):
    f_0_A = f_0-2.5*Delta_F
    f_0_B = f_0-1.5*Delta_F
    f_0_C = f_0-0.5*Delta_F
    f_0_D = f_0+0.5*Delta_F
    f_0_E = f_0+1.5*Delta_F
    f_0_F = f_0+2.5*Delta_F
    
    E = []
    kb = 8.617e-5*241799 #in GHz
    for i in range(6):
        E.append(i*Delta_F)
    Boltz = np.exp(-(np.array(E))/(kb*T))
    Z = np.sum(Boltz)
    P = Boltz/Z

    I_A = I*P[0]#Boltz[0]
    I_B = I*P[1]#Boltz[1]
    I_C = I*P[2]#Boltz[2]
    I_D = I*P[3]#Boltz[3]
    I_E = I*P[4]#Boltz[4]
    I_F = I*P[5]#Boltz[5]
    # print(P)
    delta_A = (f-f_0_A)/(Gamma/2)
    delta_B = (f-f_0_B)/(Gamma/2)
    delta_C = (f-f_0_C)/(Gamma/2)
    delta_D = (f-f_0_D)/(Gamma/2)
    delta_E = (f-f_0_E)/(Gamma/2)
    delta_F = (f-f_0_F)/(Gamma/2)
    return (I_A*(1+delta_A*2*q)/(1+delta_A**2) 
            + I_B*(1+delta_B*2*q)/(1+delta_B**2)
            + I_C*(1+delta_C*2*q)/(1+delta_C**2)
            + I_D*(1+delta_D*2*q)/(1+delta_D**2)
            + I_E*(1+delta_E*2*q)/(1+delta_E**2)
            + I_F*(1+delta_F*2*q)/(1+delta_F**2)
            +A
           )

###########################
### PUMP-PROBE ANALYSIS ###
###########################

def ReadFile_PP(file,datalen=9):
    # datalen is 11 or 9 depening on how many things are saved for PP data
    header = pd.read_csv(file, sep = '\t', nrows = 21, names=list(range(0,datalen)))
    names = []
    data = []
    for i in range(datalen):
        names.append(header[i][20])
    data = pd.read_csv(file, header = 20, sep='\t', names=names)
    return data, header

def LI_to_electrons(lockin,lockinsens,gain,lockinfreq,nbprobepulse,qel):
    # Convert lockin to current rms 
    Irms = lockin*lockinsens/10/gain
    # Convert rms current to peak-to-peak current accounting for square form of the signal - see Supplementary S.Baumann, Science 350 (2015)
    deltaI = 2*np.sqrt(2)*np.pi/4*Irms
    # Convert peak-to-peak current to number of electron per probe pulse
    electrons = deltaI/lockinfreq/nbprobepulse/qel
    return electrons

def CutPoints(xdata,ydata,start,stop):
    xdatacut = xdata[start:len(xdata)-stop]
    xdatacut = xdatacut.reset_index(drop=True)
    ydatacut = ydata[start:len(ydata)-stop]
    ydatacut = ydatacut.reset_index(drop=True)
    return xdatacut, ydatacut

################################
### PUMP-PROBE FIT FUNCTIONS ###
################################

def Swapfit(t,f,T_1,T_2,A,B,C,phi):
    return C + A*np.exp(-t/T_1) + B*np.exp(-t/T_2)*np.sin(2*np.pi*f*t+phi)

def Hyperswapfit(t,f,T_1,T_2,A,B,C,phi,f_n,T_2_n,B_n,phi_n):
    return C + A*np.exp(-t/T_1) + B*np.exp(-t/T_2)*np.sin(2*np.pi*f*t+phi) + B_n/2*(np.exp(-t/T_2_n) + np.exp(-t/T_2) ) * np.sin(2*np.pi*f_n*t+phi_n)

def Expfit(t,T_1,A,C):
    return C + A*np.exp(-t/T_1)    

def Hyperswapfit2(t,f,T_1,T_2,A,B,C,phi,f_n,T_2_n,B_n,phi_n):
    return C + A*np.exp(-t/T_1) + B_n/2*(np.exp(-t/T_2_n) + np.exp(-t/T_2) ) *(np.sin(2*np.pi*f*t+phi) + np.sin(2*np.pi*f_n*t+phi_n))

def Hyperswapfit3(t,f,T_1,T_2,A,B,C,phi,f_n,T_2_n,B_n,phi_n):
    return C + A*np.exp(-t/T_1) + (B*np.exp(-t/T_2) + B_n*np.exp(-t/T_2_n)*np.sin(2*np.pi*f_n*t+phi_n) )* np.sin(2*np.pi*f*t+phi)

def Hyperswapfit4(t,f,T_1,T_2,A,B,C,phi,f_n,T_2_n,B_n,phi_n):
    return C + A*np.exp(-t/T_1) + np.exp(-t/T_2)*(B + B_n * np.sin(2*np.pi*f_n*t+phi_n) ) * np.sin(2*np.pi*f*t+phi) + 0*T_2_n

def Hyperswapfit5(t,f,T_1,T_2,A,B,C,phi,f_n,T_2_n,B_n,phi_n,f_3,phi_3):
    return C + A*np.exp(-t/T_1) + (B*np.exp(-t/T_2) + B_n*np.exp(-t/T_2_n)* np.sin(2*np.pi*f_n*t+phi_n))*( np.sin(2*np.pi*f*t+phi) + np.sin(2*np.pi*f_3*t+phi_3))

def Hyperswapfit6(t,f,T_1,T_2,A,B,C,phi,f_n,B_n,phi_n,phi_3,D):
    return C + A*np.exp(-t/T_1) + np.exp(-t/T_2) *( B_n*np.sin(2*np.pi*f_n*t+phi_n) + B*np.sin(2*np.pi*f*t+phi) + D*np.sin(2*np.pi*(f+f_n)*t+phi_3) )

def SubtractFit(listfiles,x = 'Time delta (s)', y = 'Lock-In Y (V)', fittype=Expfit, p0=[60,0.3,1.3],cut=[0,0]):
    M = []
    c = []
    M_fit = []
    # plt.figure()
    for i in listfiles:
        data,header = ReadFile_PP(i)
        t,trace = CutPoints(data[x]*1e9,data[y],cut[0],cut[1])
        t = t-min(t)
        # plt.plot(t,trace)
        if fittype == Expfit:
            popt, pcov=curve_fit(fittype, t, trace, p0)
            fit = Expfit(t, *popt)
            # plt.plot(t,fit)
            # M_fit.append(fit-fit)
            # print(popt)
        if fittype == Swapfit:
            popt, pcov=curve_fit(fittype, t, trace, p0)
            swapfit = Swapfit(t, *popt)
            fit = Expfit(t, T_1=popt[1], A=popt[3], C=popt[5])
            # plt.plot(t,swapfit)
            # plt.plot(fit)
            swap = swapfit-fit
            M_fit.append(swap)
            # print(popt)
        cor = trace-fit
        # cor = cor - sum(cor)/len(cor)
        M.append(cor)
        currentstpt = round(float(header[1][15])*1e12)
        c.append(currentstpt)
    return M,t,c,M_fit

#############
### dI/dV ###
#############

def read_spec(spec_filename):
    f = open(spec_filename,'r')
    all_data = f.read()
    lines = all_data.split('\n')
    header = lines[0:47]
    channels = lines[49].split('\t')
    d = np.zeros((len(lines) - 51, len(channels)))
    for i in range(len(lines) - 51):
        d[i,:] = lines[50+i].split('\t')
    f.close
    return header, channels, d

def spec_plot(filename, title=''):
    header, channels, data = read_spec(filename)
    
    plt.figure()
    plt.plot(data[:,0]*1e3, data[:,5], color='darkgoldenrod', linewidth=1, label = filename)
    plt.xlabel('Bias (mV)')
    plt.ylabel('Lock-in Y (V)')
    plt.legend(loc='upper right',fontsize='xx-small')
    plt.grid(alpha=0.5,markevery=5)
    plt.title(title)
    plt.show()





