# -*- coding: utf-8 -*-
"""
Created on Fri Feb  3 16:36:59 2023

@author: lmveldman
"""

### IMPORTING LIBRARIES ###

import pySPM
import pandas as pd
import os
import matplotlib.pyplot as plt
import matplotlib
from mpl_toolkits.axes_grid1.anchored_artists import (AnchoredSizeBar)
import matplotlib.font_manager as fm
import numpy as np
from scipy.optimize import curve_fit
import warnings
warnings.filterwarnings('ignore')

####################
### TOPOGRAPHIES ###
####################

def Get_Scan_Direction(TopoFile, JT = False):
    if JT ==False:
        data= pd.read_csv(TopoFile,nrows=75,encoding='latin1')
    else:
        data= pd.read_csv(TopoFile,nrows=50)
    df = pd.DataFrame(data=data)
    direction_ind = df.loc[df[':NANONIS_VERSION:'].str.contains(':SCAN_DIR:')].index
    direction =(df[':NANONIS_VERSION:'][direction_ind[0]+1])
    return direction

def Plot_Topo(filename, xlim = None, ylim = None, slope_correction = False, barlen = 5):
    fig,ax = plt.subplots()#figsize=(10,10))
    if slope_correction == False:
#         scan_TOPO = pySPM.SXM(filename).get_channel('Z').show(ax=ax,cmap= 'Blues_r')
        A = pySPM.SXM(filename).get_channel('Z')*1e12 #change to nm
        A.zero_min().show() #make zero minimum color value
        scan_TOPO = A.show(ax=ax,cmap= 'Blues_r')
        cbar = plt.colorbar(scan_TOPO,ax=ax,fraction=0.04,label='bla')
        cbar.set_label('\u0394 Z (pm)', rotation=270)
#         cbar.ax.set_ylabel('# of contacts', rotation=270)
    else:
        scan_TOPO = pySPM.SXM(filename).get_channel('Z').correct_plane(inline=False).show(ax=ax,cmap= 'Blues_r')
    plt.setp(plt.gcf().get_axes(), xticks=[], yticks=[], xlabel='', ylabel='', title='')
    direction = Get_Scan_Direction(filename)
    fontprops = fm.FontProperties(size=20)
    bar = AnchoredSizeBar(ax.transData, barlen, '{} nm'.format(barlen), 4, frameon=False, pad=1, fontproperties=fontprops, color="w",size_vertical=0.05,label_top=True)
    ax.add_artist(bar)
    if xlim != None:
        ax.set_xlim(xlim[0], xlim[1])
    if ylim != None:
        ax.set_ylim(ylim[0], ylim[1])
    if direction == 'down':
        ax.invert_yaxis()
    cbar.set_label('\u0394 Z (pm)', rotation=270, labelpad=15)

####################
### ESR ANALYSIS ###
####################

def ReadFile_ESR(file):
    header = pd.read_csv(file, sep = '\t', nrows = 17, names=[0,1]) 
    channels = header[1][15].split(';')
    names = []
    for i in range(len(channels)):
        names.append(channels[i])
    data = pd.read_csv(file, header = 16, sep='\t', names=names)
    return data, header

def LItoA_ESR(LIY,sens,gain):
    I_RMS = LIY*(sens/10)/gain
    Delta_I = I_RMS*2*np.sqrt(2)*np.pi/4
    return Delta_I*10**12 #return in pA

def Single_Fano(f,I_peak,f_0,Gamma,A,q):
    delta = (f-f_0)/(Gamma/2)
    return I_peak*(1+delta*2*q)/(1+delta**2) + A

def Lin_Fit(x,a,b):
    return a+b*x

def GenList(files, basename):
    listfiles =[]
    for i in files:
        listfiles.append(basename.format(i))
    return listfiles

def Normalise(data):
    norm = (data-min(data))/abs(max(data)-min(data))
    return norm

###########################
### PUMP-PROBE ANALYSIS ###
###########################

def ReadFile_PP(file,datalen=12):
    # datalen is 11 or 9 depening on how many things are saved for PP data
    header = pd.read_csv(file, sep = '\t', nrows = 33, names=list(range(0,datalen)))
    names = []
    data = []
    for i in range(datalen):
        names.append(header[i][32])
    data = pd.read_csv(file, header = 32, sep='\t', names=names)
    return data, header

def ReadFile_PP_old(file,datalen=11):
    # datalen is 11 or 9 depening on how many things are saved for PP data
    header = pd.read_csv(file, sep = '\t', nrows = 21, names=list(range(0,datalen)))
    names = []
    data = []
    for i in range(datalen):
        names.append(header[i][20])
    data = pd.read_csv(file, header = 20, sep='\t', names=names)
    return data, header

def LI_to_electrons(lockin,lockinsens,gain,lockinfreq,nbprobepulse,qel):
    # Convert lockin to current rms 
    Irms = lockin*lockinsens/10/gain
    # Convert rms current to peak-to-peak current accounting for square form of the signal - see Supplementary S.Baumann, Science 350 (2015)
    deltaI = 2*np.sqrt(2)*np.pi/4*Irms
    # Convert peak-to-peak current to number of electron per probe pulse
    electrons = deltaI/lockinfreq/nbprobepulse/qel
    return electrons

################################
### PUMP-PROBE FIT FUNCTIONS ###
################################

def Expfit(t,T_1,A,C):
    return C + A*np.exp(-t/T_1)    
