# -*- coding: utf-8 -*-
"""
Created on Thu Feb 23 13:44:49 2023

@author: lmveldman
"""

### HERE WE FIT THE ESR DATA THAT SHOWS SPIN PUMPING

import os
import sys
import inspect

### IMPORTING MODULE FROM PARENT DIRECTORY
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
grandparentdir = os.path.dirname(parentdir)
sys.path.insert(0, parentdir) 

from data_analysis_functions import *

#%%
####################################################
############ FITTING ESR SPIN PUMPING ##############
####################################################

########### channels to extract
x = 'Frequency (Hz)'
y = 'Lock-In Y (V)'
z = 'Power (dBm)'
cmap = plt.cm.get_cmap('autumn')

########### initialize arrays for reference data and parameters
popt_hyp = []
perror_hyp = []
freq_hyp = []
data_hyp = []

############ enter files NB: files ESR_850.tf seems to be damaged
files = GenList([262,267,270,273,275,276,278,281,284,286],'../data/single_spin_low_field/ESR_{}.tf')
B = [360,290,200,160,120,80,40,20,10,0]

########### offset traces in plot
offset = [-i/1000 + max(B)/1000 for i in B]

############ List of inital guesses: I_peak,f_0,Gamma,A,q
p0 = [ 
      [0.1,10.6,0.2,0,0],
      [0.1,8.6,0.2,0,0],
      [0.1,6.2,0.2,0,0],
      [0.1,5.6,0.2,0,0],
      [0.1,4.6,0.2,0,0],
      [0.1,3,0.2,0,0],
      [0.07,1.8,0.2,0,0],
      [0.07,1.5,0.2,0,0],
      [0.1,1,0.2,0,0],
      [0.1,0.5,0.2,0,0],
      ]

bias = []
current = []
res = []
for i,name in enumerate(files):
    ########### import and read files..
    file = files[i]
    data, header = ReadFile_ESR(file)
    currentstpt = float(header[1][3])*1e12
    biasstpt = float(header[1][4])*1000
    bias.append(round(biasstpt))
    current.append(currentstpt)
    
    ############ remove NaN values in x and y data if present
    ydat = np.array(data[y])[~np.isnan(np.array(data[y]))]
    xdat = np.array(data[x])[~np.isnan(np.array(data[x]))]
    power = np.array(data[z])[~np.isnan(np.array(data[x]))]

    ############# Convert axes to correct units
    freq = xdat*10**-9
    Delta_I = LItoA_ESR(ydat,0.05,10**11)
    
    ############ plotting for the fitting process
    plt.plot(freq, Delta_I+offset[i],'o',c=cmap(i/len(files)),alpha=0.2,markersize=2, label = file + '\n' + '{:.1f} pA, {:.1f} mV'.format(currentstpt,biasstpt)) 
    plt.plot(freq, Single_Fano(freq, *p0[i])+offset[i], c='blue')
    
    ############# Fitting parameters:  f,f_0,Gamma,q,A,Delta_F,I_A,I_B,I_C,I_D,I_E,I_F
    popt, pcov = curve_fit(Single_Fano, freq, Delta_I, p0=p0[i])#, bounds=bounds[i])
    print(popt)
    res.append(popt[1])
    
    ############# save all reference atom parameters in arrays
    popt_hyp.append(popt)
    perror_hyp.append(np.sqrt(np.diag(pcov)))
    freq_hyp.append(freq)
    data_hyp.append(Delta_I)
    
    
    cmap = plt.cm.get_cmap('autumn')
    plt.plot(freq, Single_Fano(freq, *popt)+offset[i], c=cmap(i/len(files)))
    plt.plot(freq, Delta_I+offset[i],'o',c=cmap(i/len(files)),alpha=0.2,markersize=2, label = file + '\n' + '{:.1f} pA, {:.1f} mV'.format(currentstpt,biasstpt)) 
    plt.xlabel('f - f\u2080 (GHz)')
    plt.ylabel('\u0394 I (pA)')



#%%

### MAIN FIGURE ###
offset = [-i/1000*1.3 + max(B)/1000 for i in B]
fig, axs = plt.subplots(3,1,figsize=(12.8/2.54,11/2.54), gridspec_kw={'height_ratios': [3, 1, 1]})
cmap = plt.cm.get_cmap('copper')
for i in range(len(files)):
    axs[0].plot(freq_hyp[i]-popt_hyp[i][0], Single_Fano(freq_hyp[i], *popt_hyp[i])-popt_hyp[i][3] + offset[i], c=cmap(i/len(files)),label='bla')
    axs[0].plot(freq_hyp[i]-popt_hyp[i][0], data_hyp[i]-popt_hyp[i][3]+offset[i],c=cmap(i/len(files)),alpha=0.5,markersize=2,label='bla') 
axs[0].set_xticks([])
axs[0].set_ylabel('\u0394 I (pA)')
axs[0].tick_params(direction="in")

### INSET FIGURE ###
popt, pcov = curve_fit(Lin_Fit, B, res,p0=[0.1,0])
# These are in unitless percentages of the figure size. (0,0 is bottom left)
left, bottom, width, height = [0.775, 0.785, 0.15, 0.15]
ax2 = fig.add_axes([left, bottom, width, height],facecolor='white')
# (x,y) width, height
axs[0].add_patch(plt.Rectangle((7.15, .09), 3.8, .33, ec="black", fc="white",zorder=2))
for i in range(len(res)):
    ax2.scatter(B[i],res[i],c=cmap(i/len(files)))
ax2.plot(B,Lin_Fit(np.array(B),*popt),c='black')
ax2.set_xlabel(r'$B_{ext}$'+' (mT)')
ax2.set_ylabel(r'$f_{0}$'+' (GHz)')
ax2.tick_params(direction="in")
plt.tight_layout()


### TRANSFER FUNCTION PLOT ###
def dBmtoVpp(dBm):
    #input in dBm
    Z = 50 #impedance
    P = 10**(dBm/10)
    Vrms = np.sqrt(P*Z*1000) 
    Vpp = 2*np.sqrt(2)*Vrms
    return Vpp # in mV

def VpptodBm(Vpp):
    #input in mV
    Z = 50 # impedance
    P = 10*np.log10(1000* (1/(2*np.sqrt(2))*Vpp/1000)**2/Z )
    return P # in dBm

junction = 11 # in [mV]. Voltage oscillation amplitude measured in the junction
junction_power = VpptodBm(junction)

TF = junction_power - power

axs[1].tick_params(direction="in")
axs[1].plot(freq,TF,c='black')
axs[1].set_xticks([])
axs[1].set_yticks([-40,-30,-20,-10])
axs[1].set_ylabel('TF (dBm)')
plt.tight_layout()

### TEMPERATURE PLOT ###
file = GenList([287],'../data/single_spin_low_field/ESR_{}.tf')
data, header = ReadFile_ESR(file[0])
temp = np.array(data['Temperature D (K)'])[~np.isnan(np.array(data['Temperature D (K)']))]

axs[2].tick_params(direction="in")
axs[2].plot(freq[2::],temp[2::]*1000,c='black')
axs[2].set_yticks([400,450,500,550])
axs[2].set_xlabel('Frequency (GHz)')
axs[2].set_ylabel('T (mK)')

plt.tight_layout()
plt.savefig('../plots/single_spin_low_field_and_tf.pdf')
