# -*- coding: utf-8 -*-
"""
Created on Mon Feb 27 11:53:58 2023

@author: lmveldman
"""

import os
import sys
import inspect

### CHANGING TO CORRECT DIRECTORY
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
grandparentdir = os.path.dirname(parentdir)
sys.path.insert(0, parentdir) 

from data_analysis_functions import *

#%%

# Convert lockin to number of electron per pulse
# Parameters for conversion
lockinfreq = 415.6 # frequency of the lockin (Hz)
lockinsens = 0.010 # lockin sensitivity (V)
nbprobepulse = 2406# number of probe pulses
gain = 10**9 # gain of the current amplifier (I/V)
qel = 1.602*10**-19 # charge of an electron in Coulomb

####### Generate list of names at file location
listfiles = GenList([1150],'../data/pp_explainer/Pprobe_rev_0{}.dat')
npts = 600
x='Time delta (s)'
y='Lock-In Y (V)'

#%%
### FIT TRACES WITHOUT OSCILLATION ###

# Select files
file = listfiles[0] #13

# Initial guesses
#       T_1,A,C
p0 = [[150,0.1,0.27]]
t_0 = 55 # end of the pump pulse

# Initialize
treated_swap_data = []
swap_current = []

# Read files
data, header = ReadFile_PP_old(file)
currentstpt = round(float(header[1][15])*1e12,2)
print(currentstpt)
biasstpt = round(float(header[1][16])*1000)
t = data[x][0:npts]*1e9 - t_0
trace = data[y][0:npts]

# Convert y axis
trace = LI_to_electrons(trace,lockinsens,gain,lockinfreq,nbprobepulse,qel)

# Fit data
# popt, pcov = curve_fit(Swapfit, t, trace, p0)
popt, pcov = curve_fit(Expfit, t, trace, p0)
p_sigma = np.sqrt(np.diag(pcov))

expfit = Expfit(t, *popt)

# Plotting
plt.figure(figsize=(12.8/2.54/1.5, 9.6/2.54/1.5))
plt.plot(t,expfit,c='black')
plt.plot(t,trace,c='grey')
plt.xlabel('Time (ns)')
plt.ylabel('# electrons per probe pulse')
plt.text(350, 4.1, r'$T_{1}=$'+'{} ns \n'.format(round(popt[0]*1,0)),
            verticalalignment='top')
plt.tick_params(direction='in')
plt.tight_layout()
plt.savefig('../plots/pp_explainer.pdf')
