# -*- coding: utf-8 -*-
"""
Created on Thu Feb 23 13:44:49 2023

@author: lmveldman
"""

import os
import sys
import inspect

### IMPORTING MODULE FROM PARENT DIRECTORY
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
grandparentdir = os.path.dirname(parentdir)
sys.path.insert(0, parentdir) 

from data_analysis_functions import *

#%%
##########################################################
############ FITTING HYPERFINE SPIN PUMPING ##############
##########################################################

########### channels to extract
x = 'Frequency (Hz)'
y = 'Lock-In Y (V)'
z = 'Power (dBm)'
cmap = plt.cm.get_cmap('autumn')

########### initialize arrays for reference data and parameters
popt_hyp = []
perror_hyp = []
freq_hyp = []
data_hyp = []

############ enter files
files = GenList([866],'../data/esr_explainer/ESR_A{}.tf')

########### offset traces in plot if needed
offset = [0]

############ List of inital guesses: I_peak,f_0,Gamma,A,q
p0 = [[0.175,12.3,0.1,-0.075,1]]
     
bias = []
current = []
res = []
for i,name in enumerate(files):
    ########### import and read files
    file = files[i]
    data, header = ReadFile_ESR(file)
    
    ########### Extract current en bias setpoint
    currentstpt = float(header[1][3])*1e12
    biasstpt = float(header[1][4])*1000
    bias.append(round(biasstpt))
    current.append(currentstpt)
    
    ############ remove NaN values in x and y data if present
    ydat = np.array(data[y])[~np.isnan(np.array(data[y]))]
    xdat = np.array(data[x])[~np.isnan(np.array(data[x]))]
    power = np.array(data[z])[~np.isnan(np.array(data[x]))]

    ############# Convert axes to correct units
    freq = xdat*10**-9
    Delta_I = LItoA_ESR(ydat,0.05,10**10)
    
    ############ plotting for the fitting process
    plt.plot(freq, Delta_I+offset[i],'o',c=cmap(i/len(files)),alpha=0.2,markersize=2, label = file + '\n' + '{:.1f} pA, {:.1f} mV'.format(currentstpt,biasstpt)) 
    plt.plot(freq, Single_Fano(freq, *p0[i]), c='blue')
    
    ############# Fitting parameters:  f,f_0,Gamma,q,A,Delta_F,I_A,I_B,I_C,I_D,I_E,I_F
    popt, pcov = curve_fit(Single_Fano, freq, Delta_I, p0=p0[i])
    print(popt)
    res.append(popt[1])
    
    ############# save all reference atom parameters in arrays
    popt_hyp.append(popt)
    perror_hyp.append(np.sqrt(np.diag(pcov)))
    freq_hyp.append(freq)
    data_hyp.append(Delta_I)
    
    ############# Creating final plot
    plt.figure(figsize=(12.8/2.54/1.5, 9.6/2.54/1.5))
    cmap = plt.cm.get_cmap('autumn')
    plt.plot(freq, 1000*(Single_Fano(freq, *popt)-popt[3]), c='black')
    plt.plot(freq, 1000*(Delta_I-popt[3]),c='grey',alpha=0.6,markersize=2, label = file + '\n' + '{:.1f} pA, {:.1f} mV'.format(currentstpt,biasstpt)) 
    plt.xlabel('Frequency (GHz)')
    plt.ylabel('\u0394 I (fA)')
    plt.tick_params(direction='in')
plt.tight_layout()
plt.savefig('../plots/esr_explainer.pdf')
