%==========================================================================
% [init.m] B747 RECOVER robust design case study initialization file 
%
%     Initialize paths and third-party software
%
%     Optional: 
%       [1] Valid IQCLab installation
%
%   Author: T.S.C. Pollack
%   Copyright (2024) T.S.C. Pollack
%==========================================================================

% Add MODEL paths
mdl_pdir = '..\_MODELS';

% addpath(rec_pdir); 
addpath(mdl_pdir);

% Add CLAWs path
addpath('_CLAWS/IMF_INDI_QMCV'); 
addpath('_CLAWS/IMF_INDI_MOD'); 
addpath('_CLAWS/PID_PF'); 

% Add FUNCTIONS path
addpath('_FUNCTIONS/0_MISC'); 
addpath('_FUNCTIONS/1_GENERATION'); 
addpath('_FUNCTIONS/2_SYNTHESIS'); 
addpath('_FUNCTIONS/3_ANALYSIS'); 
addpath('_FUNCTIONS/4_PLOTTING'); 
addpath('_FUNCTIONS/5_EXPORT'); 

% Set IQCLab availability yes/no
iqclab_available = 0;

% Set IQCLab directory, if available
iqclab_dir = '';

% Initialize IQCLab
if iqclab_available    
    run(iqclab_dir);
end
