%==========================================================================
% [open_umbrella.m] Open stored data in umbrella.mat format
%
%   Author: T.S.C. Pollack
%   Copyright (2024) T.S.C. Pollack
%==========================================================================

% Show IQC options
options.iqc

% Soft + hard objective evolutions
INFO.GAMMAtab
INFO.MUDtab

% Worst-case norms
WCG_SYN
WCG_AP
WCG_IQC_LTI
WCG_IQC_LTV

WCG_N_SYN
WCG_N_TAB

% Worst-case uncertainty sets
WCU_AP
INFO.WCUtab{end}

% D-scale fitting
[INFO.MUtab{:}]'-[INFO.MUDtab{:}]'

% Show final CLAW 
showBlockValue(K_CLAW)

%% Convert if necessary
if exist('C_vc','var')
    
    C_vc_syn = zpk(getBlockValue(K_vc,'C_vc'))
    Kp_syn = dcgain(C_vc_syn)
    Ki_syn = Kp_syn*getBlockValue(K_vc,'Ki')   
    
    K_vc_comp = fcn_convert_Kvc(K_vc);
    C_vc_comp = zpk(getBlockValue(K_vc_comp,'C_vc'))    
    Kp_comp = dcgain(C_vc_comp)
    Ki_comp = Kp_comp*getBlockValue(K_vc_comp,'Ki')

end