%==========================================================================
% [plt_results.m] Generate overview of results
%
%   Author: T.S.C. Pollack
%   Copyright (2024) T.S.C. Pollack
%==========================================================================

%% --- GET SIMULATION DATA ---

% Create correponding nominal system description
B747_NSYS = ss(B747_USYS);

% Select model(synthesis/analysis)
UCL_PLT = A_UCL;

% Sample uncertainties
UCL_SAMPLED = usample(UCL_PLT,options.plt.n_sample);

% Sample worst-case uncertainty
UCL_WC = usubs(UCL_PLT,WCU_AG_AP);

% Get nominal system
NCL = ss(UCL_PLT);

%% --- PLOTTING ---
 
% Settings
Tstep = 6;

if plt_figs
    
    close all;

    % C* tracking response
    figure
    step(UCL_SAMPLED(out_idx_cstar,in_idx_wr),Tstep);
    grid on; hold on;
    step(NCL(out_idx_cstar,in_idx_wr),Tstep,'r--');
    step(UCL_WC(out_idx_cstar,in_idx_wr),Tstep,'c');
    step(H_des);
    xlabel('Time');
    ylabel('C* (-)');
    
    % Pitch rate tracking response
    figure
    step(180/pi*UCL_SAMPLED(out_idx_q,in_idx_wr),Tstep);
    grid on; hold on;
    step(180/pi*NCL(out_idx_q,in_idx_wr),Tstep,'r--');
    CL_DC = bode(NCL(out_idx_q,in_idx_wr),1e-2);
    BA_DC = dcgain(B747_SYS(1,1));
    step(180/pi*B747_SYS(1,1)/BA_DC*CL_DC,Tstep,'k--');
    step(180/pi*UCL_WC(out_idx_q,in_idx_wr),Tstep,'c');
    xlabel('Time');
    ylabel('Pitch rate (deg/s)');
    
    % Normal acceleration tracking response
    figure
    step(UCL_SAMPLED(out_idx_nz,in_idx_wr),Tstep);
    grid on; hold on;
    step(NCL(out_idx_nz,in_idx_wr),Tstep,'r--');
    step(UCL_WC(out_idx_nz,in_idx_wr),Tstep,'c');
    xlabel('Time');
    ylabel('Normal acceleration (g)');
        
    % Ganged elevator tracking response
    figure
    step(UCL_SAMPLED(out_idx_de,in_idx_wr),Tstep);
    grid on; hold on;
    step(NCL(out_idx_de,in_idx_wr),Tstep,'r--'); 
    step(UCL_WC(out_idx_de,in_idx_wr),Tstep,'c'); 
    ylabel('Ganged elevator deflection (deg)');  
    
    % Ganged elevator tracking response - rate
    figure
    step(tf('s')*UCL_SAMPLED(out_idx_de,in_idx_wr),Tstep);
    grid on; hold on;
    step(tf('s')*NCL(out_idx_de,in_idx_wr),Tstep,'r--'); 
    step(tf('s')*UCL_WC(out_idx_de,in_idx_wr),Tstep,'c'); 
    ylabel('Ganged elevator rate (deg/s)');  
    
    % Weighted model-following error tracking frequency response
    figure
    bodeplot(UCL_SAMPLED(out_idx_z_eps_mcv,in_idx_wr));
    grid on; hold on;
    bodeplot(NCL(out_idx_z_eps_mcv,in_idx_wr),'r--'); 
    bodeplot(UCL_WC(out_idx_z_eps_mcv,in_idx_wr),'c'); 
    
    % Drop-back plot
    t = 0:0.01:15;
    ubox = zeros(size(t));
    tbox = 0:0.01:5;
    ubox(t < tbox(end)) = 1;
    figure
    lsim(180/pi*NCL(out_idx_q,in_idx_wr)/tf('s'),ubox,t)
    grid on; hold on;
    lsim(180/pi*NCL(out_idx_q,in_idx_wr),ubox,t);
    y_drb = lsim(NCL(out_idx_q,in_idx_wr)/tf('s'),ubox,t);
    ylim(180/pi*[-0.05,0.25]);
    
    % 1-cos gust input generation
    dt = 0.001;
    t = 0:dt:2*pi*2;
    tg = 0:dt:2*pi/2;
    tng = t(length(tg)+1:end);
    ag = 1/2*(1-cos(2*tg));
    ag = [ag, 0*tng];
    
    % C* gust response
    figure
    lsim(UCL_SAMPLED(out_idx_cstar,in_idx_wg),ag,t);
    grid on; hold on;
    lsim(NCL(out_idx_cstar,in_idx_wg),ag,t,'r--');
    lsim(UCL_WC(out_idx_cstar,in_idx_wg),ag,t,'c');
    xlabel('Time');
    ylabel('C* (-)');
        
    % Pitch rate gust response
    figure
    lsim(UCL_SAMPLED(out_idx_q,in_idx_wg),ag,t);
    grid on; hold on;
    lsim(NCL(out_idx_q,in_idx_wg),ag,t,'r--');
    lsim(UCL_WC(out_idx_q,in_idx_wg),ag,t,'c');
    B747_NCL_P = B747_USYS.NominalValue;
    lsim(B747_NCL_P(1,4),ag,t,'k--')     
    
    % Normal acceleration gust response
    figure
    lsim(UCL_SAMPLED(out_idx_nz,in_idx_wg),ag,t);
    grid on; hold on;
    lsim(NCL(out_idx_nz,in_idx_wg),ag,t,'r--');
    lsim(UCL_WC(out_idx_nz,in_idx_wg),ag,t,'c');
    xlabel('Time');
    ylabel('Normal acceleration (g)');
        
    % Ganged elevator gust response
    figure
    lsim(UCL_SAMPLED(out_idx_de,in_idx_wg),ag,t);
    grid on; hold on;
    lsim(NCL(out_idx_de,in_idx_wg),ag,t,'r--');  
    lsim(UCL_WC(out_idx_de,in_idx_wg),ag,t,'c');  
    ylabel('Ganged elevator deflection (deg)'); 
        
    % Ganged elevator gust response
    figure
    lsim(tf('s')*UCL_SAMPLED(out_idx_de,in_idx_wg),ag,t);
    grid on; hold on;
    lsim(tf('s')*NCL(out_idx_de,in_idx_wg),ag,t,'r--');  
    lsim(tf('s')*UCL_WC(out_idx_de,in_idx_wg),ag,t,'c');  
    ylabel('Ganged elevator rate (deg/s)'); 
    
    % Weighted model-following error gust frequency response
    figure
    bodeplot(UCL_SAMPLED(out_idx_z_eps_mcv,in_idx_wg));
    grid on; hold on;   
    bodeplot(NCL(out_idx_z_eps_mcv,in_idx_wg),'r--'); 
    bodeplot(UCL_WC(out_idx_z_eps_mcv,in_idx_wg),'c'); 
    
    % C* disturbance response
    figure
    step(UCL_SAMPLED(out_idx_cstar,in_idx_wxi),Tstep);
    grid on; hold on;
    step(NCL(out_idx_cstar,in_idx_wxi),Tstep,'r--'); 
    step(UCL_WC(out_idx_cstar,in_idx_wxi),Tstep,'c'); 
    xlabel('Time');
    ylabel('C* (-)');
        
    % Pitch rate disturbance response
    figure
    step(UCL_SAMPLED(out_idx_q,in_idx_wxi),Tstep);
    grid on; hold on;
    step(NCL(out_idx_q,in_idx_wxi),Tstep,'r--'); 
    step(UCL_WC(out_idx_q,in_idx_wxi),Tstep,'c'); 
    B747_NCL_P = B747_USYS.NominalValue;
    
    % Normal acceleration disturbance response
    figure
    step(UCL_SAMPLED(out_idx_nz,in_idx_wxi),Tstep);
    grid on; hold on;
    step(NCL(out_idx_nz,in_idx_wxi),Tstep,'r--'); 
    step(UCL_WC(out_idx_nz,in_idx_wxi),Tstep,'c');
    xlabel('Time');
    ylabel('Normal acceleration (g)');
        
    % Ganged elevator disturbance response
    figure
    step(UCL_SAMPLED(out_idx_de,in_idx_wxi),Tstep);
    grid on; hold on;
    step(NCL(out_idx_de,in_idx_wxi),Tstep,'r--'); 
    step(UCL_WC(out_idx_de,in_idx_wxi),Tstep,'c'); 
    ylabel('Ganged elevator deflection (deg)'); 
        
    % Ganged elevator disturbance response - rate
    figure
    step(tf('s')*UCL_SAMPLED(out_idx_de,in_idx_wxi),Tstep);
    grid on; hold on;
    step(tf('s')*NCL(out_idx_de,in_idx_wxi),Tstep,'r--'); 
    step(tf('s')*UCL_WC(out_idx_de,in_idx_wxi),Tstep,'c'); 
    ylabel('Ganged elevator rate (deg/s)'); 
    
    % Weighted model-following error disturbance frequency response
    figure
    bodeplot(UCL_SAMPLED(out_idx_z_eps_mcv,in_idx_wxi));
    grid on; hold on;   
    bodeplot(NCL(out_idx_z_eps_mcv,in_idx_wxi),'r--'); 
    bodeplot(UCL_WC(out_idx_z_eps_mcv,in_idx_wxi),'c'); 
    
end