function phase_lst_wrapped = phase_wrapper(phase_lst,varargin)
%   PHASE_WRAPPER Auxiliary function to wrap phase between [-180,180] deg
%   in Bode diagrams
%
%       Author: T.S.C. Pollack
%       Copyright (2024) T.S.C. Pollack

    if isempty(varargin)
        phase_l = -180;
        phase_u = 180;
    else
        phase_l = varargin{1};
        phase_u = varargin{2};
    end

    idx_l = find(phase_lst < phase_l); idx_u = find(phase_lst > phase_u);
    
    while ~isempty(idx_l) || ~isempty(idx_u) 

        phase_lst(idx_l) = phase_lst(idx_l) + 360;
        phase_lst(idx_u) = phase_lst(idx_u) - 360;

        idx_l = find(phase_lst < phase_l); idx_u = find(phase_lst > phase_u);
        
    end
    
    phase_lst_wrapped = phase_lst;

end

