%==========================================================================
% [plt_ds_sim_sq.m] Plot pilot stick response (square)
%
%   Note: before using this script, an umbrella.mat file must be loaded
%
%   Author: T.S.C. Pollack
%   Copyright (2024) T.S.C. Pollack
%==========================================================================

%% --- USER SETTINGS ---

% Set file name
ffname = 'FIG_DS_STEP_PID_PLT4';

% Specify colors for [NOMINAL, SAMPLED, WCASE]
clr_order = [6,1,1];

% Specify line width
LineWidthSetting = 3;

% Specify font size
font_size = 15;

% Save plot yes/no
save_plt = 0;

% Create legend yes/no
add_lgd  = 1;

% Add annotation yes/no
annotate = 0;

% Specify simulation settings
dt = 1e-2; T = 0:dt:6;

%% --- GET SIMULATION DATA ---

% Select model(synthesis/analysis)
UCL_PLT = A_UCL_R;

% Sample uncertainties
UCL_SAMPLED = usample(UCL_PLT,options.plt.n_sample);

% Sample worst-case uncertainty
[~,WCU_R_AP_l] = wcgain(A_UCL_P(1,1)); 
[~,WCU_R_AP_u] = wcgain(H_des-A_UCL_P(1,1)); 
UCL_WC_l = usubs(UCL_PLT,WCU_R_AP_l);
UCL_WC_u = usubs(UCL_PLT,WCU_R_AP_u);

% Get nominal system
NCL = ss(UCL_PLT);
    
% Get responses
SSYS_cstar_ds  = UCL_SAMPLED(out_idx_cstar,in_idx_wr);
WLSYS_cstar_ds = UCL_WC_l(out_idx_cstar,in_idx_wr);
WUSYS_cstar_ds = UCL_WC_u(out_idx_cstar,in_idx_wr);
NSYS_cstar_ds  = NCL(out_idx_cstar,in_idx_wr);

SSYS_nz_ds     = UCL_SAMPLED(out_idx_nz,in_idx_wr);
WLSYS_nz_ds    = UCL_WC_l(out_idx_nz,in_idx_wr);
WUSYS_nz_ds    = UCL_WC_u(out_idx_nz,in_idx_wr);
NSYS_nz_ds     = NCL(out_idx_nz,in_idx_wr);

SSYS_q_ds     = 180/pi*UCL_SAMPLED(out_idx_q,in_idx_wr);
WLSYS_q_ds    = 180/pi*UCL_WC_l(out_idx_q,in_idx_wr);
WUSYS_q_ds    = 180/pi*UCL_WC_u(out_idx_q,in_idx_wr);
NSYS_q_ds     = 180/pi*NCL(out_idx_q,in_idx_wr);

SSYS_dde_ds     = tf('s')*UCL_SAMPLED(out_idx_de,in_idx_wr);
WLSYS_dde_ds    = tf('s')*UCL_WC_l(out_idx_de,in_idx_wr);
WUSYS_dde_ds    = tf('s')*UCL_WC_u(out_idx_de,in_idx_wr);
NSYS_dde_ds     = tf('s')*NCL(out_idx_de,in_idx_wr);

%% --- PLOT ---

% Set color theme
clr_theme = [ [0, 0.4470, 0.7410]; ...
            [0.8500, 0.3250, 0.0980]; ...
            [0.4660, 0.6740, 0.1880]; ...
            [0.4940, 0.1840, 0.5560]; ...  
            [0.6350, 0.0780, 0.1840]; ...
            [0.75, 0.75, 0.75]; ...
            [0.75, 0.75, 0]; ...
            [0, 0.75, 0.75]; ...
            [0.9290, 0.6940, 0.1250]];

% Get files in specified directory
dir_lst = dir; dir_lst = dir_lst(3:end);

% Create figure [left bottom width height]
FIG = figure; FIG.Position = [300 59 560*2 620];

% Simulate and plot response
for i = 1:options.plt.n_sample

    if i == 1
        sp1 = subplot(2,2,1);
        sp1.Position = sp1.Position + [-0.02 -0.03 0.04 0.07];
    
        % Create textbox
        if annotate
            annotation(FIG,'textbox',[0.314 0.896 0.162 0.054],'String',...
                strcat('$\gamma_{\delta_s \rightarrow z_{mf}} = '...
                ,num2str(round(WCG_R_AP.UpperBound,2)),'$'),...
                'Interpreter','latex','FontSize',20,...
                'BackgroundColor',[1 1 1]);
        end
    end
    
    if i < options.plt.n_sample      
        
        if i == 1
            [y_cstar_ref,~] = step(H_des,T);
            [y_cstar_ds,~]  = step(NSYS_cstar_ds,T);
            [y_cstar_ds_wcl,~]  = step(WLSYS_cstar_ds,T);
            [y_cstar_ds_wcu,~]  = step(WUSYS_cstar_ds,T);
            [y_cstar_ds_s,~] = step(SSYS_cstar_ds(:,:,i,1),T); 
       
            plot(sp1,T,y_cstar_ref,'r--','LineWidth',LineWidthSetting);
            grid on; hold on;
            plot(sp1,T,y_cstar_ds,'color',clr_theme(clr_order(2),:),...
                    'LineStyle','-','LineWidth',LineWidthSetting);
            plot(sp1,T,y_cstar_ds_wcl,'color',clr_theme(clr_order(3),:),...
                    'LineStyle','-.','LineWidth',LineWidthSetting);
            plot(sp1,T,y_cstar_ds_s,'color',clr_theme(clr_order(1),:),...
                    'LineStyle','-','LineWidth',LineWidthSetting); 
            plot(sp1,T,y_cstar_ds_wcu,'color',clr_theme(clr_order(3),:),...
                    'LineStyle','-.','LineWidth',LineWidthSetting);
            
        else
            [y_cstar_ds,~] = step(SSYS_cstar_ds(:,:,i,1),T);
            plot(sp1,T,y_cstar_ds,'color',clr_theme(clr_order(1),:),...
                    'LineStyle','-','LineWidth',LineWidthSetting);            
        end      
        
    else
        
        [y_cstar_ref,~] = step(H_des,T);
        [y_cstar_ds,~]  = step(NSYS_cstar_ds,T);
        [y_cstar_ds_wcl,~]  = step(WLSYS_cstar_ds,T);
        [y_cstar_ds_wcu,~]  = step(WUSYS_cstar_ds,T);
        
        plot(sp1,T,y_cstar_ds_wcl,'color',clr_theme(clr_order(3),:),...
                'LineStyle','-.','LineWidth',LineWidthSetting);
        plot(sp1,T,y_cstar_ds_wcu,'color',clr_theme(clr_order(3),:),...
                'LineStyle','-.','LineWidth',LineWidthSetting);
        plot(sp1,T,y_cstar_ds,'color',clr_theme(clr_order(2),:),...
                'LineStyle','-','LineWidth',LineWidthSetting);
        plot(sp1,T,y_cstar_ref,'r--','LineWidth',LineWidthSetting);
        
        ylim(sp1,[-0.1,1.4]);
        ylabel(sp1,'$C^{*}$ (-)','Interpreter','latex','FontSize',...
                font_size);
        set(sp1,'TickLabelInterpreter','latex','FontSize',font_size)
        set(sp1,'XTickLabel',[])
        
    end

    % Add legend
    if add_lgd
        legend(sp1,'Reference', 'Nominal', 'Worst-case', 'Samples', ...
            'Orientation','horizontal','NumColumns',1, ...
            'Interpreter','latex','Location','southeast','FontSize',...
                font_size);
    end

    if i == 1
        sp2 = subplot(2,2,2);
        sp2.Position = sp2.Position + [0 -0.03 0.04 0.07];
    end
    
    if i <options.plt.n_sample        
        
        if i == 1
            [y_q_ds,~] = step(NSYS_q_ds,T);
        
            plot(sp2,T,y_q_ds,'color',clr_theme(clr_order(2),:),...
                    'LineStyle','-','LineWidth',LineWidthSetting);
            grid on; hold on;
        end
        
        [y_q_ds,~] = step(SSYS_q_ds(:,:,i,1),T);
       
        plot(sp2,T,y_q_ds,'color',clr_theme(clr_order(1),:),'LineStyle',...
                '-','LineWidth',LineWidthSetting);
        
    else
        
        [y_q_ds,~] = step(NSYS_q_ds,T);
        [y_q_ds_wcl,~] = step(WLSYS_q_ds,T);
        [y_q_ds_wcu,~] = step(WUSYS_q_ds,T);
        
        plot(sp2,T,y_q_ds_wcl,'color',clr_theme(clr_order(3),:),...
                'LineStyle','-.','LineWidth',LineWidthSetting);
        grid on; hold on;
        plot(sp2,T,y_q_ds_wcu,'color',clr_theme(clr_order(3),:),...
                'LineStyle','-.','LineWidth',LineWidthSetting);
        plot(sp2,T,y_q_ds,'color',clr_theme(clr_order(2),:),...
                'LineStyle','-','LineWidth',LineWidthSetting);
        
        ylim(sp2,[-0.2,3.5]);
        ylabel(sp2,'Pitch rate (deg/s)','Interpreter','latex',...
                'FontSize',font_size);
        set(sp2,'TickLabelInterpreter','latex','FontSize',font_size)
        set(sp2,'XTickLabel',[])
        
    end
        

    if i == 1
        sp3 = subplot(2,2,3);
        sp3.Position = sp3.Position + [-0.02 -0.01 0.04 0.07];
    end
    
    if i < options.plt.n_sample         
        
        if i == 1
            [y_nz_ds,~] = step(NSYS_nz_ds,T);
        
            plot(sp3,T,y_nz_ds,'color',clr_theme(clr_order(2),:),...
                    'LineStyle','-','LineWidth',LineWidthSetting);
            grid on; hold on;
        end 
        
        [y_nz_ds,~] = step(SSYS_nz_ds(:,:,i,1),T);
       
        plot(sp3,T,y_nz_ds,'color',clr_theme(clr_order(1),:),...
                'LineStyle','-','LineWidth',LineWidthSetting);
        grid on; hold on;
        
    else
        
        [y_nz_ds,~] = step(NSYS_nz_ds,T);
        [y_nz_ds_wcl,~] = step(WLSYS_nz_ds,T);
        [y_nz_ds_wcu,~] = step(WUSYS_nz_ds,T);
        
        plot(sp3,T,y_nz_ds_wcl,'color',clr_theme(clr_order(3),:),...
                'LineStyle','-.','LineWidth',LineWidthSetting);
        grid on; hold on;
        plot(sp3,T,y_nz_ds_wcu,'color',clr_theme(clr_order(3),:),...
                'LineStyle','-.','LineWidth',LineWidthSetting);
        plot(sp3,T,y_nz_ds,'color',clr_theme(clr_order(2),:),...
                'LineStyle','-','LineWidth',LineWidthSetting);
        
        ylim(sp3,[-0.1,0.9]);
        ylabel(sp3,'Normal acceleration (g)','Interpreter','latex',...
                'FontSize',font_size);
        set(sp3,'TickLabelInterpreter','latex','FontSize',font_size)
        xlabel(sp3,'Time (s)','Interpreter','latex','FontSize',font_size);
        
    end       
        

    if i == 1
        sp4 = subplot(2,2,4);
        sp4.Position = sp4.Position+ [0 -0.01 0.04 0.07];
    end
    
    if i < options.plt.n_sample         
        
        if i == 1
            [y_dde_ds,~] = step(NSYS_dde_ds,T);
        
            plot(sp4,T,y_dde_ds,'color',clr_theme(clr_order(2),:),...
                    'LineStyle','-','LineWidth',LineWidthSetting);
            grid on; hold on;
        end 
        
        [y_dde_ds,~] = step(SSYS_dde_ds(:,:,i,1),T);
       
        plot(sp4,T,y_dde_ds,'color',clr_theme(clr_order(1),:),...
                'LineStyle','-','LineWidth',LineWidthSetting);
        grid on; hold on;
        
    else
        
        [y_dde_ds,~] = step(NSYS_dde_ds,T);
        [y_dde_ds_wcl,~] = step(WLSYS_dde_ds,T);
        [y_dde_ds_wcu,~] = step(WUSYS_dde_ds,T);
        
        plot(sp4,T,y_dde_ds_wcl,'color',clr_theme(clr_order(3),:),...
                'LineStyle','-.','LineWidth',LineWidthSetting);
        grid on; hold on;
        plot(sp4,T,y_dde_ds_wcu,'color',clr_theme(clr_order(3),:),...
                'LineStyle','-.','LineWidth',LineWidthSetting);
        plot(sp4,T,y_dde_ds,'color',clr_theme(clr_order(2),:),...
                'LineStyle','-','LineWidth',LineWidthSetting);
        
        ylim(sp4,[-40,15]);
        xlabel(sp4,'Time (s)','Interpreter','latex','FontSize',font_size);
        ylabel(sp4,'Deflection rate (deg/s)','Interpreter','latex',...
                'FontSize',font_size);
        set(sp4,'TickLabelInterpreter','latex','FontSize',font_size)
        
        % Plot rate limit
        plot(sp4,T,-37*ones(size(T)),'k--','LineWidth',LineWidthSetting);
        
    end     

end

%% Save plot

FIG.Renderer = 'painters';

if save_plt
    if ~exist('_FIGURES/', 'dir')
        mkdir('_FIGURES/');
    end
    saveas(FIG,strcat('_FIGURES/',ffname,'.fig'));
    saveas(FIG,strcat('_FIGURES/',ffname,'.png'));
    saveas(FIG,strcat('_FIGURES/',ffname,'.emf'));
    saveas(FIG,strcat('_FIGURES/',ffname),'epsc');
end