%==========================================================================
% [plt_rs_nichols.m] Plot input/output Nichols plot
%
%   Author: T.S.C. Pollack
%   Copyright (2024) T.S.C. Pollack
%==========================================================================

%% --- USER SETTINGS ---

close all;

% Set file name
ffname = 'FIG_RS_NLI_WC';

% Set data sources
res_dir = '..\..\..\..\_FIGDATA\';

f1 = strcat(res_dir,'b747_h30kft_M0.85_n1_xcg0.25\PI\batch\umbrella_plt.mat');
f2 = strcat(res_dir,'b747_h30kft_M0.85_n1_xcg0.25\PID\batch\umbrella_plt.mat');
f3 = strcat(res_dir,'b747_h30kft_M0.85_n1_xcg0.25\HB-INDI-QMCV\batch\umbrella_plt.mat');
f4 = strcat(res_dir,'b747_h30kft_M0.85_n1_xcg0.25\HB-INDI-CSTARMCV\batch\umbrella_plt.mat');

fnames{1} = f1; fnames{2} = f2; fnames{3} = f3; fnames{4} = f4; 

% Set file destination
fsdes = '../../../_RESULTS/RS/';

% Specify theme
clr_order = [1,3,2,4];
st_order = {'-','-','--','-'};

% Specify line width
LineWidthSetting = 3;

% Specify font size
font_size = 15;

% Save plot yes/no
save_plt = 0;

% Set plot mode nominal/worst-case
nplt_mode = 'wc';

% Create legend yes/no
add_lgd  = 0;

% Set analysis point
ap = 'AP_es';

%% --- GET SIMULATION DATA ---

for p_i = 1:length(fnames)

    % Import data
    load(fnames{p_i})

    if strcmp(nplt_mode,'nom')
        
        % Load nominal data
        BL_TAB{p_i}    = ss(getLoopTransfer(A_UCL,ap,-1));
        
    elseif strcmp(nplt_mode,'wc')

        % Look up worst-case perturbation per AP
        if strcmp(ap,'AP_act')
            WCU_MF = WCU_N_MF_TAB{2};
            WCU_HF = WCU_N_HF_TAB{2};
        elseif strcmp(ap,'AP_es')
            WCU_MF = WCU_N_MF_TAB{3};
            WCU_HF = WCU_N_HF_TAB{3};
        elseif strcmp(ap,'AP_q_m')
            WCU_MF = WCU_N_MF_TAB{4};
            WCU_HF = WCU_N_HF_TAB{4};
        elseif strcmp(ap,'AP_alpha_m')
            WCU_MF = WCU_N_MF_TAB{5};
            WCU_HF = WCU_N_HF_TAB{5};
        elseif strcmp(ap,'AP_nz_m')
            WCU_MF = WCU_N_MF_TAB{6};
            WCU_HF = WCU_N_HF_TAB{6};
        end

        % Load worst-case uncertainty data
        BL_TAB{p_i}    = getLoopTransfer(usubs(A_UCL,WCU_MF),ap,-1);
        
    end
    
end

%% --- PLOT ---

% Set color theme
clr_theme = [ [0, 0.4470, 0.7410]; ...
            [0.8500, 0.3250, 0.0980]; ...
            [0.4660, 0.6740, 0.1880]; ...
            [0.4940, 0.1840, 0.5560]; ...  
            [0.6350, 0.0780, 0.1840]; ...
            [0.75, 0.75, 0.75]; ...
            [0.75, 0.75, 0]; ...
            [0, 0.75, 0.75]; ...
            [0.9290, 0.6940, 0.1250]];
        
% Get files in specified directory        
dir_lst = dir; dir_lst = dir_lst(3:end);

% Create figure [left bottom width height]
FIG = figure; FIG.Position = [300 59 560 400];

% Simulate and plot response
for p_i = 1:length(fnames)
    
        [MAG,PHASE] = nichols(BL_TAB{p_i});   
        PHASE = phase_wrapper(PHASE,-361,-1);        
    
        if p_i == 1 
            sp1 = subplot(1,1,1);  
        end   
            
        plot(sp1,PHASE(:),mag2db(MAG(:)),'color',clr_theme(clr_order(p_i),:),'LineStyle',st_order{p_i},'LineWidth',LineWidthSetting);
        grid on; hold on;             
        
end

draw_nichols_region(6,36.87,sp1,-180);
    
xlim(sp1,[-290,-40]);
ylim(sp1,[-30,20]);
xlabel(sp1,'Phase (deg)','Interpreter','latex','FontSize',font_size);
ylabel(sp1,'Magnitude (dB)','Interpreter','latex','FontSize',font_size);
set(sp1,'TickLabelInterpreter','latex','FontSize',font_size)

% Add legend
if add_lgd
    legend(sp1,'PI','PID','HB-INDI ($q$ MCV)','HB-INDI ($C^*$ MCV)',...
        'Orientation','vertical','NumColumns',2, ...
        'Interpreter','latex','Location','NorthWest','FontSize',font_size);
end   

%% Save plot

FIG.Renderer = 'painters';

if save_plt
    saveas(FIG,strcat(fsdes,ffname,'.fig'));
    saveas(FIG,strcat(fsdes,ffname,'.png'));
    saveas(FIG,strcat(fsdes,ffname,'.emf'));
    saveas(FIG,strcat(fsdes,ffname),'epsc');
end