%==========================================================================
% [plt_rs_lio.m] Plot input/output loop transfer function
%
%   Author: T.S.C. Pollack
%   Copyright (2024) T.S.C. Pollack
%==========================================================================

%% --- USER SETTINGS ---

close all; clear all; clc;

% Set file name
ffname = 'FIG_RS_LI_NOM';

% Set data sources
res_dir = '..\..\..\..\_FIGDATA\';

f1 = strcat(res_dir,'b747_h30kft_M0.85_n1_xcg0.25\PI\batch\umbrella_plt.mat');
f2 = strcat(res_dir,'b747_h30kft_M0.85_n1_xcg0.25\PID\batch\umbrella_plt.mat');
f3 = strcat(res_dir,'b747_h30kft_M0.85_n1_xcg0.25\HB-INDI-QMCV\batch\umbrella_plt.mat');
f4 = strcat(res_dir,'b747_h30kft_M0.85_n1_xcg0.25\HB-INDI-CSTARMCV\batch\umbrella_plt.mat');

fnames{1} = f1; fnames{2} = f2; fnames{3} = f3; fnames{4} = f4; 

% Set file destination
fsdes = '../../../_RESULTS/RS/';

% Specify theme
clr_order = [1,3,2,4];
st_order = {'-','-','--','-'};

% Specify line width
LineWidthSetting = 3;

% Specify font size
font_size = 12;

% Save plot yes/no
save_plt = 0;

% Set plot mode nominal/worst-case
lplt_mode = 'nom';

% Set plot mode gain only or gain & phase
plt_phase = 0;

% Add legend yes/no
add_lgd = 1;

% Set analysis point
ap = 'AP_es';

% Set frequency spectrum of interest
omega = logspace(-2,2,100);

%% --- GET SIMULATION DATA ---

for p_i = 1:length(fnames)

    % Import data
    load(fnames{p_i});
    
    % Look up worst-case perturbation per AP
    if strcmp(ap,'AP_act')
        WCU = WCU_N_MF_TAB{2};
    elseif strcmp(ap,'AP_es')
        WCU = WCU_N_MF_TAB{3};
    elseif strcmp(ap,'AP_q_m')
        WCU = WCU_N_MF_TAB{4};
    elseif strcmp(ap,'AP_alpha_m')
        WCU = WCU_N_MF_TAB{5};
    elseif strcmp(ap,'AP_nz_m')
        WCU = WCU_N_MF_TAB{6};
    end    

    % Get BL response
    if strcmp(lplt_mode,'nom')
        BL_TAB{p_i} = ss(getLoopTransfer(A_UCL,ap,-1));
    elseif strcmp(lplt_mode,'wc')
        BL_TAB{p_i} = getLoopTransfer(usubs(A_UCL,WCU),ap,-1);
    end
    
end

%% --- MISC ---

% Set color theme
clr_theme = [ [0, 0.4470, 0.7410]; ...
            [0.8500, 0.3250, 0.0980]; ...
            [0.4660, 0.6740, 0.1880]; ...
            [0.4940, 0.1840, 0.5560]; ...  
            [0.6350, 0.0780, 0.1840]; ...
            [0.75, 0.75, 0.75]; ...
            [0.75, 0.75, 0]; ...
            [0, 0.75, 0.75]; ...
            [0.9290, 0.6940, 0.1250]];

%% --- PLOT ---

% Preliminaries        
FIG = figure; 

if plt_phase
    FIG.Position = [300 59 560 800]; 
else
    FIG.Position = [300 59 560 400];     
end

% --- Plot magnitude ---
for p_i = 1:length(fnames)
    
    if p_i == 1
        if plt_phase
            sp1 = subplot(2,1,1);    
            sp1.Position = sp1.Position + [0 -0.05 0 0.05];
        else
            sp1 = subplot(1,1,1);
        end
    end
    
    % Get response data
    [NL_MAG,~] = bode(BL_TAB{p_i},omega); 

    % Plot nominal response
    semilogx(sp1,omega,mag2db(NL_MAG(:)),'color',...
        clr_theme(clr_order(p_i),:),'LineStyle',st_order{p_i},...
        'LineWidth',LineWidthSetting);   
    grid on; hold on;  
 
end

xlim([omega(1),omega(end)]); ylim([-40,50]);
if ~plt_phase
    xlabel(sp1,'Frequency (rad/s)','Interpreter','latex','FontSize',...
            font_size);
end
ylabel(sp1,'Magnitude (dB)','Interpreter','latex','FontSize',font_size);
set(sp1,'TickLabelInterpreter','latex','FontSize',font_size)

% Add legend
if add_lgd
    legend(sp1,'PI','PID','HB-INDI ($q$ MCV)','HB-INDI ($C^*$ MCV)',...
        'Orientation','vertical','NumColumns',2, ...
        'Interpreter','latex','Location','southwest','FontSize',font_size);
end

% --- Plot phase ---
for p_i = 1:length(fnames)
    
    if p_i == 1
        if plt_phase
            sp2 = subplot(2,1,2);    
            sp2.Position = sp2.Position + [0 0 0 0.05];  
        else
            break
        end
    end
    
    % Get response data
    [~,NL_PHASE] = bode(BL_TAB{p_i},omega); 
    NL_PHASE = phase_wrapper(NL_PHASE(:));

    % Plot nominal response
    semilogx(sp2,omega,NL_PHASE,'color',clr_theme(clr_order(p_i),:),...
        'LineStyle',st_order{p_i},'LineWidth',LineWidthSetting);       
    grid on; hold on;   
    
end 

if plt_phase
    xlim([omega(1),omega(end)]); ylim([-180,180]);
    xlabel(sp2,'Frequency (rad/s)','Interpreter','latex','FontSize',...
                font_size);
    ylabel(sp2,'Phase (deg)','Interpreter','latex','FontSize',font_size);
    set(sp2,'TickLabelInterpreter','latex','FontSize',font_size)
end

%% Save plot

FIG.Renderer = 'painters';

if save_plt
    saveas(FIG,strcat(fsdes,ffname,'.fig'));
    saveas(FIG,strcat(fsdes,ffname,'.png'));
    saveas(FIG,strcat(fsdes,ffname,'.emf'));
    saveas(FIG,strcat(fsdes,ffname),'epsc');
end