%==========================================================================
% [plt_rp_tio.m] Plot input/output complementary sensitivity function
%
%   Author: T.S.C. Pollack
%   Copyright (2024) T.S.C. Pollack
%==========================================================================

%% --- USER SETTINGS ---

close all; clear all; clc;

% Set file name
ffname = 'FIG_RP_TO_Q';

% Set data sources
res_dir = '..\..\..\..\_FIGDATA\';

f1 = strcat(res_dir,'b747_h30kft_M0.85_n1_xcg0.25\PI\batch\umbrella_plt.mat');
f2 = strcat(res_dir,'b747_h30kft_M0.85_n1_xcg0.25\PID\batch\umbrella_plt.mat');
f3 = strcat(res_dir,'b747_h30kft_M0.85_n1_xcg0.25\HB-INDI-QMCV\batch\umbrella_plt.mat');
f4 = strcat(res_dir,'b747_h30kft_M0.85_n1_xcg0.25\HB-INDI-CSTARMCV\batch\umbrella_plt.mat');

fnames{1} = f1; fnames{2} = f2; fnames{3} = f3; fnames{4} = f4; 

% Set file destination
fsdes = '../../../_RESULTS/RS/';

% Specify colors
clr_order = [1,3,2,4];

% Specify line width
LineWidthSetting = 3;

% Specify font size
font_size = 15;

% Save plot yes/no
save_plt = 1;

% Add legend yes/no
add_lgd = 1;

% Set analysis point
ap = 'AP_q_m';

% Add overlap yes/no
add_overlap = 1;

% Set frequency spectrum of interest
omega = logspace(-2,2,100);

%% --- GET SIMULATION DATA ---

for p_i = 1:length(fnames)

    % Import data
    load(fnames{p_i});

    % Load tracking error weight
    Wu = options.unc.Wunc_q;
    
    % Look up worst-case perturbation per AP
    if strcmp(ap,'AP_act')
        WCU = WCU_N_TAB{2};
    elseif strcmp(ap,'AP_es')
        WCU = WCU_N_TAB{3};
    elseif strcmp(ap,'AP_q_m')
        WCU = WCU_N_TAB{4};
    elseif strcmp(ap,'AP_alpha_m')
        WCU = WCU_N_TAB{5};
    elseif strcmp(ap,'AP_nz_m')
        WCU = WCU_N_TAB{6};
    end    

    % Get nominal BL response
    NLi      = ss(getLoopTransfer(A_UCL,ap,-1));
    NTi{p_i} = NLi/(1+NLi);
    
end

%% --- MISC ---

% Set color theme
clr_theme = [ [0, 0.4470, 0.7410]; ...
            [0.8500, 0.3250, 0.0980]; ...
            [0.4660, 0.6740, 0.1880]; ...
            [0.4940, 0.1840, 0.5560]; ...  
            [0.6350, 0.0780, 0.1840]; ...
            [0.75, 0.75, 0.75]; ...
            [0.75, 0.75, 0]; ...
            [0, 0.75, 0.75]; ...
            [0.9290, 0.6940, 0.1250]];

%% --- PLOT ---

% Preliminaries        
FIG = figure; FIG.Position = [300 59 560 320]; 

% --- Plot nominal magnitude ---
for p_i = 1:length(fnames)
    
    if p_i == 1
        sp1 = subplot(1,1,1);    
        [W_MAG,~]  = bode(1/Wu,omega);
        semilogx(sp1,omega,mag2db(W_MAG(:)),'k--','LineWidth',LineWidthSetting);     
        grid on; hold on;  
    end
    
    % Get response data
    [NTi_MAG,~] = bode(NTi{p_i},omega); 

    % Plot nominal response
    semilogx(sp1,omega,mag2db(NTi_MAG(:)),'color',clr_theme(clr_order(p_i),:),'LineStyle','-','LineWidth',LineWidthSetting);        
         
    if add_overlap
        if p_i == 3
            [NTi_MAG,~] = bode(NTi{1},omega); 
            semilogx(sp1,omega,mag2db(NTi_MAG(:)),'color',clr_theme(clr_order(1),:),'LineStyle','--','LineWidth',LineWidthSetting,'HandleVisibility','off');   
        end
    end
    
end

xlim([omega(1),omega(end)]); ylim([-40,10]);
xlabel(sp1,'Frequency (rad/s)','Interpreter','latex','FontSize',font_size);
ylabel(sp1,'Magnitude (dB)','Interpreter','latex','FontSize',font_size);
set(sp1,'TickLabelInterpreter','latex','FontSize',font_size)

% Add legend
if add_lgd
legend(sp1,'$W_{q}^{-1}$',...
    'Orientation','horizontal','NumColumns',1, ...
    'Interpreter','latex','Location','NorthWest','FontSize',font_size);
end

%% Save plot

FIG.Renderer = 'painters';

if save_plt
    saveas(FIG,strcat(fsdes,ffname,'.fig'));
    saveas(FIG,strcat(fsdes,ffname,'.png'));
    saveas(FIG,strcat(fsdes,ffname,'.emf'));
    saveas(FIG,strcat(fsdes,ffname),'epsc');
end