%==========================================================================
% [plt_rp_sio.m] Plot input/output sensitivity function 
%
%   Author: T.S.C. Pollack
%   Copyright (2024) T.S.C. Pollack, Delft University of Technology
%==========================================================================

%% --- USER SETTINGS ---

close all; clear all; clc;

% Set file name
ffname = 'FIG_RP_SO_NZ_WC';

% Set data sources
res_dir = '..\..\..\..\_FIGDATA\';

f1 = strcat(res_dir,'b747_h30kft_M0.85_n1_xcg0.25\PI\batch\umbrella_plt.mat');
f2 = strcat(res_dir,'b747_h30kft_M0.85_n1_xcg0.25\PID\batch\umbrella_plt.mat');
f3 = strcat(res_dir,'b747_h30kft_M0.85_n1_xcg0.25\HB-INDI-QMCV\batch\umbrella_plt.mat');
f4 = strcat(res_dir,'b747_h30kft_M0.85_n1_xcg0.25\HB-INDI-CSTARMCV\batch\umbrella_plt.mat');

fnames{1} = f1; fnames{2} = f2; fnames{3} = f3; fnames{4} = f4; 

% Set file destination
fsdes = '../../../_RESULTS/RP/SIO/';

% Specify theme
clr_order = [1,3,2,4];
st_order = {'-','-','--','-'};

% Specify line width
LineWidthSetting = 3;

% Specify font size
font_size = 15;

% Save plot yes/no
save_plt = 0;

% Set plot mode nominal/worst-case
plt_mode = 'wc';

% Add annotation yes/no
annotate = 0;

% Add overlap yes/no
add_overlap = 0;

% Set analysis point
ap = 'AP_es';

% Set frequency spectrum of interest
omega = logspace(-3,2,100);

%% --- GET SIMULATION DATA ---

for p_i = 1:length(fnames)

    % Import data
    load(fnames{p_i});
    
    % Look up worst-case perturbation per AP
    if strcmp(ap,'AP_act')
        WCU = WCU_N_TAB{2};
    elseif strcmp(ap,'AP_es')
        WCU = WCU_N_TAB{3};
    elseif strcmp(ap,'AP_q_m')
        WCU = WCU_N_TAB{4};
    elseif strcmp(ap,'AP_alpha_m')
        WCU = WCU_N_TAB{5};
    elseif strcmp(ap,'AP_nz_m')
        WCU = WCU_N_TAB{6};
    end    

    % Get nominal BL response
    NLi       = ss(getLoopTransfer(A_UCL,ap,-1));
    NSi{p_i} = 1/(1+NLi);
    
    % Get worst-case BL response
    WCLi      = getLoopTransfer(usubs(A_UCL,WCU),ap,-1);
    WCSi{p_i} = 1/(1+WCLi);
    
end

%% --- MISC ---

% Set color theme
clr_theme = [ [0, 0.4470, 0.7410]; ...
            [0.8500, 0.3250, 0.0980]; ...
            [0.4660, 0.6740, 0.1880]; ...
            [0.4940, 0.1840, 0.5560]; ...  
            [0.6350, 0.0780, 0.1840]; ...
            [0.75, 0.75, 0.75]; ...
            [0.75, 0.75, 0]; ...
            [0, 0.75, 0.75]; ...
            [0.9290, 0.6940, 0.1250]];

%% --- PLOT ---

% Preliminaries        
FIG = figure; FIG.Position = [300 59 560 320]; 

if strcmp(plt_mode,'nom')

    % --- Plot nominal magnitude ---
    for p_i = 1:length(fnames)

        if p_i == 1
            sp1 = subplot(1,1,1);    
            semilogx(sp1,omega,mag2db(2)*ones(size(omega)),'k--','LineWidth',LineWidthSetting);        
            grid on; hold on;  
        end

        % Get response data
        [NSi_MAG,~] = bode(NSi{p_i},omega); 

        % Plot nominal response
        semilogx(sp1,omega,mag2db(NSi_MAG(:)),'color',clr_theme(clr_order(p_i),:),'LineStyle',st_order{p_i},'LineWidth',LineWidthSetting);     

%         if add_overlap
%             if p_i == 3
%                 [NSi_MAG,~] = bode(NSi{1},omega); 
%                 semilogx(sp1,omega,mag2db(NSi_MAG(:)),'color',clr_theme(clr_order(1),:),'LineStyle','--','LineWidth',LineWidthSetting,'HandleVisibility','off');   
%             end
%         end     

    end

elseif strcmp(plt_mode,'wc')

    % --- Plot worst-case magnitude ---
    for p_i = 1:length(fnames)

        if p_i == 1
            sp1 = subplot(1,1,1);    
            semilogx(sp1,omega,mag2db(2)*ones(size(omega)),'k--','LineWidth',LineWidthSetting);        
            grid on; hold on;  
        end
        
        % Get response data
        [WCSi_MAG,~] = bode(WCSi{p_i},omega); 

        % Plot worst-case response
        semilogx(sp1,omega,mag2db(WCSi_MAG(:)),'color',clr_theme(clr_order(p_i),:),'LineStyle',st_order{p_i},'LineWidth',LineWidthSetting);

    end

end

xlim([omega(1),omega(end)]); ylim([-15,10]);
xlabel(sp1,'Frequency (rad/s)','Interpreter','latex','FontSize',font_size);
ylabel(sp1,'Magnitude (dB)','Interpreter','latex','FontSize',font_size);
set(sp1,'TickLabelInterpreter','latex','FontSize',font_size)

% Create textbox
if annotate
    clear annotation
    annotation('textbox',...
        [0.163 0.690 0.129 0.111],...
        'String',{'6 dB'},...
        'Interpreter','latex',...
        'FontSize',font_size, ...
        'EdgeColor','none');
end

%% Save plot

FIG.Renderer = 'painters';

if save_plt
    saveas(FIG,strcat(fsdes,ffname,'.fig'));
    saveas(FIG,strcat(fsdes,ffname,'.png'));
    saveas(FIG,strcat(fsdes,ffname,'.emf'));
    saveas(FIG,strcat(fsdes,ffname),'epsc');
end