%==========================================================================
% [run_iqc.m] Perform IQC analysis for specified uncertainties
%
%     Required: 
%       [1] Valid IQCLab installation
%
%   Author: T.S.C. Pollack
%   Copyright (2024) T.S.C. Pollack
%==========================================================================

% Use uncertainty weight OUT diagrams for better numerical conditioning 
if any(strfind(options.claw.mode,'hort'))
    IC_BL_WUNCOUT = linearize('BL_IMF_INDI_MOD');
elseif any(strfind(options.claw.mode,'hodc'))
    IC_BL_WUNCOUT = linearize('BL_IMF_INDI_QMCV');
elseif strfind(options.claw.mode,'pi') || strfind(options.claw.mode,'pid') 
    IC_BL_WUNCOUT = linearize('BL_PID_PF');
end

% Rename I/O
IC_BL_WUNCOUT = fcn_sys_iocleaner(IC_BL_WUNCOUT);

% Connect airframe and complex uncertainties
BL_WUNCOUT  = lft(IC_BL_WUNCOUT,B747_USYS);
UBL_WUNCOUT = lft(Delta_c,BL_WUNCOUT);

% Connect analysis points
A_UCL_WUNCOUT   = lft(APs,UBL_WUNCOUT);
A_UCL_P_WUNCOUT = A_UCL_WUNCOUT(1:2,:);

% Generate LFT data
[P_UCL_P,~,BLKSTRUCT.perf,NORMUNC.perf] = lftdata(A_UCL_P_WUNCOUT); 

% Run IQC analysis;
% !!!VERY IMPORTANT!!!: MOSEK solution status must be 'OPTIMAL'
ploc_tab = [-10,-20,-30,-40];
WCG_IQC_LTI_TAB = zeros(size(ploc_tab));
WCG_IQC_LTV_TAB = zeros(size(ploc_tab));

for i = 1:length(ploc_tab)

    % Set ploc
    options.iqc.ploc = ploc_tab(i);
    
    % First run analysis for LTI perturbations
    options.iqc.param_type = 'lti';

    % Get IQC uncertainty block
    [Delta_iqc.perf,pe.perf] = fcn_iqc_conv(BLKSTRUCT.perf,...
                                                NORMUNC.perf,options.iqc);

    % Convert to balanced realization
    P_UCL_P_BAL  = balreal(P_UCL_P);
    
    % Run analysis
    prob_perf = iqcanalysis(P_UCL_P_BAL,[Delta_iqc.perf,{pe.perf}],...
                    'SolChk','on','gmax',1e3,'Solver','mosek','Parser',...
                    'Yalmip','Display','on','eps',1e-8,'FeasbRad',1e7);
    
    % Save worst-case gamma          
    WCG_IQC_LTI_TAB(i) = prob_perf.gamma;      
              
    % Then run analysis for LTV perturbations
    options.iqc.param_type = 'ltv_fast';

    % Get IQC uncertainty block
    [Delta_iqc.perf,pe.perf] = fcn_iqc_conv(BLKSTRUCT.perf,...
                                                NORMUNC.perf,options.iqc);

    % Convert to balanced realization
    P_UCL_P_BAL  = balreal(P_UCL_P);
    
    % Run analysis
    prob_perf = iqcanalysis(P_UCL_P_BAL,[Delta_iqc.perf,{pe.perf}],...
                    'SolChk','on','gmax',1e3,'Solver','mosek','Parser',...
                    'Yalmip','Display','on','eps',1e-8,'FeasbRad',1e7);
              
    % Save worst-case gamma          
    WCG_IQC_LTV_TAB(i) = prob_perf.gamma;  
              
end

% Display results
WCG_IQC_LTI_TAB
WCG_IQC_LTV_TAB