%==========================================================================
% [reffq.m] Get insight into desired flying qualities (FQ)
%
%   Author: T.S.C. Pollack
%   Copyright (2024) T.S.C. Pollack
%==========================================================================

clear all; close all; clc;

% Define Laplace operator
s = tf('s'); 

% Set reference dynamics 
w0 = 0.9; D = 0.8; w3 = 1.1;
H_des = w0^2/w3*(s+w3)/(s^2+2*D*w0*s+w0^2);

% Load bare airframe model
mdl_pdir  = '..\..\..\_MODELS';
fname_mdl = 'b747_h30kft_M0.85_n1_xcg0.25_def_f1'; 

load(strcat(mdl_pdir,'\',fname_mdl,'.mat'));
load(strcat(mdl_pdir,'\',fname_mdl,'.tri'),'-mat');

% Create short-period model
A_lin_sp = b747_lin.A([2,5],[2,5]);
B_lin_sp = b747_lin.B([2,5],[17:21,26:29]);
B_lin_sp(2,:) = 0.*B_lin_sp(2,:);
C_lin_sp = b747_lin.C([2,5,69],[2,5]);
D_lin_sp = b747_lin.D([2,5,69],[17:21,26:29]);

% Rename model
B747_SYS = ss(A_lin_sp,B_lin_sp,C_lin_sp,D_lin_sp);

% Get trim airspeed
V0 = x0(4);

% Misc parameters
g      = 9.81; % m/s^2

% C* settings
knz = 1; kq = 12.4;

% Nominal actuator model
act_w_n  = 20;
act_zeta = sqrt(1/2);
act_del  = 0; 

H_act = tf(act_w_n^2,[1 2*act_zeta*act_w_n act_w_n^2]);

% Get outputs
Za  = B747_SYS.A(2,2);
Gq  = B747_SYS(1,1);
Gnz = B747_SYS(2,1)*-Za*V0/g;

% Get conversion transfer functions
H_qc = minreal(Gq/(Gnz + kq*Gq));
H_nzc = minreal(Gnz/(Gnz + kq*Gq));

% Get attitude transfer function
H_theta = H_qc*H_des/s;

% Get flight path transfer function
H_gamma = H_nzc*H_des/s/g;

% Attitude and flight path bandwidth
figure
bode(H_theta); 
grid on; hold on;

figure
bode(H_gamma); 
grid on; hold on;

% Drop-back
t = 0:0.01:15;
ubox = zeros(size(t));
tbox = 0:0.01:5;
ubox(t < tbox(end)) = 1;
figure
lsim(180/pi*H_theta,ubox,t)
grid on; hold on;
lsim(180/pi*H_theta*s,ubox,t)
ylim(180/pi*[-0.05,0.25]);

% Control surface rate activity
H_elev_rate = minreal(H_qc*H_des/Gq/4)*H_act*s;

figure
step(H_elev_rate,5); grid on; hold on; step(tf(-37),5,'k--');