function [wcn_tab,wcun_tab] = fcn_wc_nichols(M,FreqInterval) 
%   FCN_WC_NICHOLS Get worst-case Nichols (disk) margins
%
%       Author: T.S.C. Pollack
%       Copyright (2024) T.S.C. Pollack

    % Initialize
    wcn_tab = zeros(1,6);
    mu_tab = zeros(1,6);
    
    % Perform robustness analysis
    for m = 2:6
        
        % Get worst-case gamma
        [wcgn,wcun] = wcgain(M(m-1,m-1,:,:,m),FreqInterval);
        wcn_tab(m)  = wcgn.UpperBound;  
        wcun_tab{m} = wcun;           
        
    end

end

