%==========================================================================
% [init_dp_claw.m] Initialize CLAW for specified mode
%
%   Author: T.S.C. Pollack
%   Copyright (2024) T.S.C. Pollack
%==========================================================================

% FREE PI      
if strcmp(options.claw.mode,'pi')  

    % FI parameters based on nominal model
    Mq  = B747_NSYS.A(1,1); 
    Ma  = B747_NSYS.A(1,2); 
    Mde = B747_NSYS.B(1,1);
    Zq  = B747_NSYS.A(2,1); 
    Za  = B747_NSYS.A(2,2);

    Vm = kq*g;

    g0 = w1*w0^2; g1 = w0^2+2*D*w0*w1; g2 = 2*D*w0 + w1;
    a0 = Za*Mq-Ma; a1 = -Za-Mq; b0 = -Mde*Za/g*(V0+Vm); b1 = Mde*Vm/g;

    Ki0 = g0/b0; 
    Kq0 = (g1-a0+b0/b1*(a1-g2)-b1*Ki0)/(Mde*(Za+b0/b1));
    Kp0 = 1/b1*(a1-Mde*Kq0-g2); 
    Kf0 = 1/b1*w0^2/w3;

    K_ff   = tunableGain('Kf',Kf0);
    Ki     = tunableGain('Ki',Ki0);
    Kp     = tunableGain('Kp',Kp0);
    Kq     = tunableGain('Kq',Kq0);
    Ka     = tunableGain('Ka',0);

    K_ff.Gain.Free = 1;
    Ki.Gain.Free = 1;
    Kp.Gain.Free = 1;
    Kq.Gain.Free = 1;
    Ka.Gain.Free = 0;

% LOW-ORDER POLE PLACEMENT PI     
elseif strcmp(options.claw.mode,'pp_pi') 

    Kw0     = tunableGain('w0',w0);
    KD      = tunableGain('D',D);
    Kw1     = tunableGain('w1',w1);  
    Kw3     = tunableGain('w3',w3); 
    Ka      = tunableGain('Ka',0);

    Kw0.Gain.Free = 0;
    KD.Gain.Free  = 0;
    Kw1.Gain.Free = 1;
    Kw3.Gain.Free = 0;
    Ka.Gain.Free  = 0;

    Mq  = B747_NSYS.A(1,1,:,:); 
    Ma  = B747_NSYS.A(1,2,:,:); 
    Mde = B747_NSYS.B(1,1,:,:);
    Zq  = B747_NSYS.A(2,1,:,:); 
    Za  = B747_NSYS.A(2,2,:,:); 

    Vm = kq*g;
    a0 = Za.*Mq-Ma; a1 = -Za-Mq; b0 = -Mde.*Za/g.*(V0+Vm); b1 = Mde.*Vm/g;

    Kg0 = Kw1*Kw0^2; 
    Kg1 = Kw0^2+2*KD*Kw0*Kw1; 
    Kg2 = 2*KD*Kw0 + Kw1;

    Ki = Kg0/b0; 
    Kq = (Kg1-a0+b0./b1*(a1-Kg2)-b1*Ki)/(Mde.*(Za+b0./b1));
    Kp = 1./b1*(a1-Mde*Kq-Kg2); 
    K_ff = 1./b1*Kw0^2/Kw3;
    
% FREE PID 
elseif strcmp(options.claw.mode,'pid')

    % FI parameters based on nominal model
    Mq  = B747_NSYS.A(1,1); 
    Ma  = B747_NSYS.A(1,2); 
    Mde = B747_NSYS.B(1,1);
    Zq  = B747_NSYS.A(2,1); 
    Za  = B747_NSYS.A(2,2);

    Vm = kq*g;

    g0 = w1*w0^2; g1 = w0^2+2*D*w0*w1; g2 = 2*D*w0 + w1;
    a0 = Za*Mq-Ma; a1 = -Za-Mq; b0 = -Mde*Za/g*(V0+Vm); b1 = Mde*Vm/g;

    Ki0 = g0/b0; 
    Kq0 = (g1-a0+b0/b1*(a1-g2)-b1*Ki0)/(Mde*(Za+b0/b1));
    Kp0 = 1/b1*(a1-Mde*Kq0-g2); 
    Kf0 = 1/b1*w0^2/w3;
    Kqdot0 = 0;

    K_ff  = tunableGain('Kf',Kf0);
    Ki    = tunableGain('Ki',Ki0);
    Kp    = tunableGain('Kp',Kp0); Kp.Gain.Minimum = 0; % pos. sign
    Kq    = tunableGain('Kq',Kq0); Kq.Gain.Minimum = 0; % pos. sign
    Kqdot = tunableGain('Kqdot',Kqdot0);

    K_ff.Gain.Free = 1; K_ff = genss(K_ff);
    Ki.Gain.Free = 1; Ki = genss(Ki);
    Kp.Gain.Free = 1; Kp = genss(Kp);
    Kq.Gain.Free = 1; Kq = genss(Kq);
    Kqdot.Gain.Free = 1; Kqdot = genss(Kqdot);
        
    % Define differentiator parameter
    tau_d   = tunableGain('tau_d',20); tau_d.Gain.Free = 1; 
    tau_d.Gain.Minimum = 1; tau_d.Gain.Maximum = 100; tau_d = genss(tau_d);

% LOW-ORDER POLE PLACEMENT PID 
elseif strfind(options.claw.mode,'pp_pid')

    Kw0     = tunableGain('w0',w0); 
    KD      = tunableGain('D',D);   
    Kw1     = tunableGain('w1',w1); 
    Kw3     = tunableGain('w3',w3); 
    Kqdot   = tunableGain('Kqdot',0); Kqdot.Gain.Maximum = 0; % neg. sign

    Kw0.Gain.Free = 0; Kw0 = genss(Kw0);
    KD.Gain.Free  = 0; KD = genss(KD);
    Kw1.Gain.Free = 1; Kw1 = genss(Kw1); 
    Kw3.Gain.Free = 0; Kw3 = genss(Kw3);
    Kqdot.Gain.Free  = 1; Kqdot = genss(Kqdot);

    Mq  = B747_NSYS.A(1,1,:,:); 
    Ma  = B747_NSYS.A(1,2,:,:); 
    Mde = B747_NSYS.B(1,1,:,:);
    Zq  = B747_NSYS.A(2,1,:,:); 
    Za  = B747_NSYS.A(2,2,:,:); 

    Vm = kq*g; 
    a0 = Za*Mq-Ma; a1 = -Za-Mq; b0 = -Mde*Za/g*(V0+Vm); b1 = Mde*Vm/g;

    Kg0 = Kw1*Kw0^2; 
    Kg1 = Kw0^2+2*KD*Kw0*Kw1; 
    Kg2 = 2*KD*Kw0 + Kw1;

    % Pole placement
    K_ff = 1/b1*Kw0^2/Kw3; 
    Ki   = Kg0/b0; 
    Kq   = (Kg1-a0+b0/b1*(a1-Kg2)-b1*Ki)/(Mde*(Za+b0/b1));
    Kp   = 1/b1*(a1-Mde*Kq-Kg2); 
    
    % Transform back
    K_ff = K_ff*(1+Mde*Kqdot);
    Ki   = Ki*(1+Mde*Kqdot);
    Kp   = Kp*(1+Mde*Kqdot) - Kqdot*Ma/Za/(V0/g);
    Kq   = Kq*(1+Mde*Kqdot) + Kqdot*Ma/Za*Vm/V0 + Kqdot*Mq;
        
    % Define differentiator parameter
    wn_f   = tunableGain('wn_f',20); 
    wn_f.Gain.Minimum = 1e-4; wn_f.Gain.Maximum = 100; wn_f = genss(wn_f);

% IMF-INDI (MODULAR)
elseif strfind(options.claw.mode,'hort')
    
    % Set compensator gains
    K_ff0 = w0^2/w3;
    Kp0   = 2*D*w0;
    Ki0   = w0^2;
    
    K_ff = tunableGain('Kf',K_ff0 - Kp0); K_ff.Gain.Free = 1; K_ff = genss(K_ff);
    Ki   = tunableGain('Ki',Ki0);  Ki.Gain.Minimum = 0; Ki.Gain.Free = 1; Ki = genss(Ki);
    Kp   = tunableGain('Kp',Kp0);  Kp.Gain.Minimum = 0; Kp.Gain.Free = 1; Kp = genss(Kp);
    
    % Define inversion parameters
    tau_f   = tunableGain('tau_f',20); 
    tau_f.Gain.Minimum = 1e-4; tau_f.Gain.Maximum = 100; tau_f = genss(tau_f);
    
    Kc     = tunableGain('Kc',0);  
    Kc.Gain.Minimum = 0; Kc.Gain.Maximum = 1;  Kc = genss(Kc);
    
 % IMF-INDI (DECOUPLED, QMCV)
elseif strfind(options.claw.mode,'hodc')

    Za = B747_NSYS.A(2,2,:,:); 
    Vm = kq*g;    
    b0 = -Za/g*(V0+Vm); b1 = Vm/g;
    
    g0 = w1*w0^2; 
    g1 = w0^2+2*D*w0*w1; 
    g2 = 2*D*w0 + w1;

    % Pole placement
    K_ff0 = 1/b1*w0^2/w3;
    Ki0   = g0/b0;
    Kq0   = (-g1+b0/b1*(Za+g2)+b1*Ki0)/(Za+b0./b1);
    Kp0   = 1/b1*(Za-Kq0+g2);  
    
    K_ff = tunableGain('Kf',K_ff0); K_ff.Gain.Minimum = 0; K_ff.Gain.Free = 1; K_ff = genss(K_ff);  
    Ki   = tunableGain('Ki',Ki0);  Ki.Gain.Minimum = 0; Ki.Gain.Free = 1; Ki = genss(Ki);  
    Kp   = tunableGain('Kp',Kp0);  Kp.Gain.Minimum = 0; Kp.Gain.Free = 1; Kp = genss(Kp);
    Kq   = tunableGain('Kq',Kq0);  Kq.Gain.Minimum = 0; Kq.Gain.Free = 1; Kq = genss(Kq);
    
    % Define inversion parameters
    tau_f   = tunableGain('tau_f',20);      
    tau_f.Gain.Minimum = 1e-4; tau_f.Gain.Maximum = 100; tau_f = genss(tau_f);
    
    Kc     = tunableGain('Kc',0);  Kc.Gain.Free = 1;
    Kc.Gain.Minimum = 0; Kc.Gain.Maximum = 1;  Kc = genss(Kc);

end   