%==========================================================================
% [gen_dp_claw.m] Generate CLAW elements for specified mode
%
%   Author: T.S.C. Pollack
%   Copyright (2024) T.S.C. Pollack
%==========================================================================

%% --- PRELIMINARIES ---
    
% Set Laplace operator
s = tf('s');

%% --- CONFIGURE CONTROL LAWS ---  
    
% IMF-INDI-MOD (HB-S)
if strcmp(options.claw.mode,'horthbc')

    % Virtual control
    K_vc   = Kp + Ki/s;

    % Angular acceleration filter
    tau_f = 100; % rad/s    
    filter_1lp_der   = feedback(tau_f,1/s);             
    filter_1lp       = feedback(tau_f/s,1);           
    K_qdot = [Kc*filter_1lp_der, 1-Kc*filter_1lp];     

    % Synchronization filter
    if strcmp(options.claw.sync,'as')
        K_syn  = [tf(1), tf(0)];
    elseif strcmp(options.claw.sync,'am')
        K_syn  = [tf(0), H_act];
    elseif strcmp(options.claw.sync,'cc')
        K_syn  = [tf(0), tf(1)];
    end     
   
% IMF-INDI-MOD (HB-CF)
elseif strcmp(options.claw.mode,'horthbf')

    % Virtual control
    K_vc   = Kp + Ki/s;

    % Angular acceleration filter
    filter_1lp_der   = feedback(tau_f,1/s);             
    filter_1lp       = feedback(tau_f/s,1);           
    K_qdot = [filter_1lp_der, 1-filter_1lp];     

    % Synchronization filter
    if strcmp(options.claw.sync,'as')
        K_syn  = [tf(1), tf(0)];
    elseif strcmp(options.claw.sync,'am')
        K_syn  = [tf(0), H_act];
    elseif strcmp(options.claw.sync,'cc')
        K_syn  = [tf(0), tf(1)];
    end   
   
% IMF-INDI-MOD (HB-SCF)
elseif strcmp(options.claw.mode,'horthbfc')

    % Virtual control
    K_vc   = Kp + Ki/s;

    % Angular acceleration filter
    filter_1lp_der   = feedback(tau_f,1/s);             
    filter_1lp       = feedback(tau_f/s,1);           
    K_qdot = [Kc*filter_1lp_der, 1-Kc*filter_1lp];     

    % Synchronization filter
    if strcmp(options.claw.sync,'as')
        K_syn  = [tf(1), tf(0)];
    elseif strcmp(options.claw.sync,'am')
        K_syn  = [tf(0), H_act];
    elseif strcmp(options.claw.sync,'cc')
        K_syn  = [tf(0), tf(1)];
    elseif strcmp(options.claw.sync,'none')
        K_syn  = [tf(0), tf(0)];
    end       

% IMF-INDI-QMCV (HB-S)
elseif strcmp(options.claw.mode,'hodchbc')

    % Virtual control
    K_vc   = [Ki/s,-Kp,-Kq];

    % Angular acceleration filter
    tau_f = 100; % rad/s      
    filter_1lp_der   = feedback(tau_f,1/s);             
    filter_1lp       = feedback(tau_f/s,1);           
    K_qdot = [Kc*filter_1lp_der, 1-Kc*filter_1lp];   

    % Synchronization filter
    if strcmp(options.claw.sync,'as')
        K_syn  = [tf(1), tf(0)];
    elseif strcmp(options.claw.sync,'am')
        K_syn  = [tf(0), H_act];
    elseif strcmp(options.claw.sync,'cc')
        K_syn  = [tf(0), tf(1)];
    end 
    
% IMF-INDI-QMCV (HB-CF)
elseif strcmp(options.claw.mode,'hodchbf')

    % Virtual control
    K_vc   = [Ki/s,-Kp,-Kq];

    % Angular acceleration filter
    filter_1lp_der   = feedback(tau_f,1/s);             
    filter_1lp       = feedback(tau_f/s,1);           
    K_qdot = [filter_1lp_der, 1-filter_1lp];   

    % Synchronization filter
    if strcmp(options.claw.sync,'as')
        K_syn  = [tf(1), tf(0)];
    elseif strcmp(options.claw.sync,'am')
        K_syn  = [tf(0), H_act];
    elseif strcmp(options.claw.sync,'cc')
        K_syn  = [tf(0), tf(1)];
    end 

% IMF-INDI-QMCV (HB-SCF)
elseif strcmp(options.claw.mode,'hodchbfc')

    % Virtual control
    K_vc   = [Ki/s,-Kp,-Kq];

    % Angular acceleration filter
    filter_1lp_der   = feedback(tau_f,1/s);             
    filter_1lp       = feedback(tau_f/s,1);           
    K_qdot = [Kc*filter_1lp_der, 1-Kc*filter_1lp];  

    % Synchronization filter
    if strcmp(options.claw.sync,'as')
        K_syn  = [tf(1), tf(0)];
    elseif strcmp(options.claw.sync,'am')
        K_syn  = [tf(0), H_act];
    elseif strcmp(options.claw.sync,'cc')
        K_syn  = [tf(0), tf(1)];
    elseif strcmp(options.claw.sync,'none')
        K_syn  = [tf(0), tf(0)];
    end 
    
% FREE PID
elseif strcmp(options.claw.mode,'pid')

    % Compensator
    K_vc   = [Ki/s,Kp,Kq];

    % Angular acceleration 
    tau_d = 100; % rad/s                        
    filter_1lp_der   = feedback(tau_d,1/s);            
    K_qdot = Kqdot*filter_1lp_der;  

    % Synchronization filter
    K_syn  = [tf(0), tf(0)];
  
% LOW-ORDER POLE-PLACEMENT PID
elseif strcmp(options.claw.mode,'pp_pid')

    % Compensator
    K_vc   = [Ki/s,Kp,Kq];

    % Angular acceleration
    tau_d = 100; % rad/s                        
    filter_1lp_der   = feedback(tau_d,1/s);            
    K_qdot = Kqdot*filter_1lp_der;  

    % Synchronization filter
    K_syn  = [tf(0), tf(0)];  
    
% FREE PI
elseif strcmp(options.claw.mode,'pi')

    % Compensator
    K_vc   = [Ki/s,Kp,Kq];

    % Angular acceleration          
    K_qdot = tf(0);  

    % Synchronization filter
    K_syn  = [tf(0), tf(0)];
  
% LOW-ORDER POLE-PLACEMENT PI
elseif strcmp(options.claw.mode,'pp_pi')

    % Compensator
    K_vc   = [Ki/s,Kp,Kq];

    % Angular acceleration filter       
    K_qdot = tf(0);  

    % Synchronization filter
    K_syn  = [tf(0), tf(0)];  
    
end     