function SYS = fcn_sys_iocleaner(SYS)
%   FCN_SYS_IOCLEANER Cleans up system input and output name strings
%
%       Author: T.S.C. Pollack
%       Copyright (2024) T.S.C. Pollack

    for i = 1:length(SYS.InputName)
        io_flag = strfind(SYS.InputName{i},'/');
        if io_flag
            SYS.InputName{i} = SYS.InputName{i}(io_flag+1:end);
        end
    end

    for i = 1:length(SYS.OutputName)
        io_flag = strfind(SYS.OutputName{i},'/');
        if io_flag
            SYS.OutputName{i} = SYS.OutputName{i}(io_flag+1:end);
        end
    end

end

