function NSTRUCT = fcn_gen_nstruct(mdl_mode)
%   FCN_GEN_NSTRUCT Sets appropriate gains per channel to model Nichols 
%   exclusion regions as per Bates & Postlethwaite (2002; Ch. 3.5)
%
%       Author: T.S.C. Pollack
%       Copyright (2024) T.S.C. Pollack

    % Initialize
    NSTRUCT.H_N_ACT_1    = 1; NSTRUCT.H_N_ACT_2   = 0; NSTRUCT.H_N_ACT_3   = 0;
    NSTRUCT.H_N_ES_1     = 1; NSTRUCT.H_N_ES_2    = 0; NSTRUCT.H_N_ES_3    = 0;
    NSTRUCT.H_N_Q_1      = 1; NSTRUCT.H_N_Q_2     = 0; NSTRUCT.H_N_Q_3     = 0;
    NSTRUCT.H_N_ALPHA_1  = 1; NSTRUCT.H_N_ALPHA_2 = 0; NSTRUCT.H_N_ALPHA_3 = 0;
    NSTRUCT.H_N_NZ_1     = 1; NSTRUCT.H_N_NZ_2    = 0; NSTRUCT.H_N_NZ_3    = 0;

    % Set path per model mode
    if strcmp(mdl_mode,'act')
        NSTRUCT.H_N_ACT_1    = 1.25; NSTRUCT.H_N_ACT_2   = 0.75/1.25; NSTRUCT.H_N_ACT_3   =   1;
    elseif strcmp(mdl_mode,'u')    
        NSTRUCT.H_N_ES_1     = 1.25; NSTRUCT.H_N_ES_2    = 0.75/1.25; NSTRUCT.H_N_ES_3    =   1; 
    elseif strcmp(mdl_mode,'q_m')    
        NSTRUCT.H_N_Q_1      = 1.25; NSTRUCT.H_N_Q_2     = 0.75/1.25; NSTRUCT.H_N_Q_3     =   1;                     
    elseif strcmp(mdl_mode,'alpha_m')      
        NSTRUCT.H_N_ALPHA_1  = 1.25; NSTRUCT.H_N_ALPHA_2 = 0.75/1.25; NSTRUCT.H_N_ALPHA_3 =   1;            
    elseif strcmp(mdl_mode,'nz_m') 
        NSTRUCT.H_N_NZ_1     = 1.25; NSTRUCT.H_N_NZ_2    = 0.75/1.25; NSTRUCT.H_N_NZ_3    =   1;       
    end    

end

