function [UCL,CL,Delta_c] = fcn_IC_LFT(IC_OL, BA_LTI, K_OBM, K_CLAW)
%   FCN_IC_LFT Connects control system interconnection elements according
%   to D-P-K LFT logic
%
%       Author: T.S.C. Pollack
%       Copyright (2024) T.S.C      
            
%% Close lower LFT interconnection paths (airframe + controller)

% Close loop with bare airframe
IC_CL = lft(IC_OL,BA_LTI);

% Close loop with inversion parameters
IC_CL_INV = lft(IC_CL,K_OBM);

% Close loop with control law
CL = lft(IC_CL_INV,K_CLAW);

% Rename I/O
CL = fcn_sys_iocleaner(CL);

%% Close upper LFT interconnection paths (uncertainties)

% Define complex uncertainty Delta blocks
Delta_act       = ultidyn('Delta_act',[1,1]);
Delta_q_m       = ultidyn('Delta_q_m',[1,1]);
Delta_alpha_m   = ultidyn('Delta_alpha_m',[1,1]);
Delta_nz_m      = ultidyn('Delta_nz_m',[1,1]);

Delta_c = append(Delta_act,Delta_q_m,Delta_alpha_m,Delta_nz_m);

% Close loop with Delta block
UCL = lft(Delta_c,CL);

end
