# ################################################
#   
#   geomParser.py - provides basic parsers for geometry data from GIS to text formats
#
#    --------
#
#  Copyright (c) 2016- N.J. Hardebol, N.J.Hardebol@tudelft.nl - (a) 
#     (a) Delft University of Technology, Department of Geotechnology,  Stevinweg 1, 2628 CN Delft, the Netherlands
#
#   ---------
# 
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see http://www.gnu.org/licenses/.
#
# #############################################

"""
    The geomParser  module provide classe(s) and (member) functions for parsing GIS geometry data to text formats of choice
	Introduced this Parser for use by the LithoMechFrac libraries, such as the JJ4XFEM module
"""

import os
import shutil
import logging
import datetime

from osgeo import ogr

logger = logging.getLogger("LMF.geomParser")

class geomParser(object):
    def __init__( self,  _exportFilePath = None,  _importFeatLyrPath=None ):
        
        if _exportFilePath:
            self.set_exportFile( _exportFilePath )
        else: 
            self.set_exportFile( "D:\\fractGeoms.dat" )
        
        self.fracNameList2lvlSet = list()
        self.fracDefStrings = ""
        
        self.precision = 1.0e-6
        self.scale_factor =1000.0
        self.shift = [0.0, 0.0]
        
    def get_featureFile(self,  _importFeaturePath):
        driver = ogr.GetDriverByName("ESRI Shapefile")
        if not os.path.isfile( _importFeaturePath ):
            return False
        try: 
            _importFile = driver.Open(_importFeaturePath, 0)  
        except: return None
        if not _importFile: return None
        
        return _importFile
        
    def set_exportFile(self,  _exportFilepath):
        _basepath,  _exportFileNm = os.path.split(_exportFilepath)
        if not os.path.isdir( _basepath ):
            return False
        if os.path.isfile( _exportFilepath ):
            timestamp = datetime.datetime.now().strftime("_%d%m%y_%H%M")
            fileNm ,  fileExt = os.path.splitext( _exportFileNm )
            shutil.copyfile( _exportFilepath,  os.path.join( _basepath,  "%s_bkup_%s.%s" % (fileNm , timestamp, fileExt ) )  )
        self.exportFile = open( _exportFilepath , 'w')
        return True
    
    def add_featureLyr(self, featureLyr,  ifaceMdlName ):
        pass
        
    def set_shift(self,  _shift):
        self.shift = _shift
        
