# ################################################
#   
#   connectivityOperator.py - operators that support network connectivity calculations 
#
#    --------
#
#    Copyright (c) 2016 - N.J. Hardebol - N.J.Hardebol@tudelft.nl  - (a)
#     (a) Delft University of Technology, Department of Geotechnology,  Stevinweg 1, 2628 CN Delft, the Netherlands
#
#   ---------
# 
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see http://www.gnu.org/licenses/.
#
# #############################################

"""The topology Operations module provide classe(s) and (member) functions for window cursor operations:
    place window within digitizing surface, walk in given direction (rows and columns) with given step size, perform and collect (spatial/stistical calculations
"""
import __builtin__
#import os , sys
#import math
import logging

#import numpy
#import shapely
#from shapely import geos
#import qgis.core as QgsCore

from geomBasicOperations import *

logger = logging.getLogger("DigiFractLogger.connectivityOperator")

def gen_intersectionTopologyTable( terminationsTable,  curveList,  otherCurveList,  _outcropDomain,  _precision=0.01 ):
    
    logger.debug("in get_intersectionTopologyHDFTable() with len(curveList): %s" % len(curveList) )
    input_params = None
    __builtin__.recurrencyLvl +=1
    
    icurve = 0
    oldCurveListLength = len(curveList)
    
    while icurve < len( curveList ):
        logger.debug( "at beginning of get_intersectionTopologyList() with icurve/len(curveList): %s / %s " % ( icurve,len(curveList) ) )
        
        #-- the incoming curve that  gets cut by any other_curve that may touch or intersect. The icurve is fixed while going through while loop, however
        #--                   however the curve might get updated as it is cropped when intersecting another_curve in the curveList. If not, then you get in endless loop!
        ##if not  isinstance( curveList[icurve] ,  QgsCore.QgsGeometry ):
        ##    curve = curveList[icurve].geometry()
        ##else: curve =curveList[icurve]
        terminationsTable = add_endPointTypeRecords2TerminationTable( terminationsTable, curveList, icurve, 
                            otherCurveList,  _outcropDomain,  _precision )

        icurve+= 1
    
    #logger.debug("<<%s<< step_end returning old/new len(curveList): %s / %s" % (  __builtin__.recurrencyLvl, oldCurveListLength, len( curveList ) ) )
    __builtin__.recurrencyLvl -=1
    
    return terminationsTable

def set_InceptionAngles(termRowDict,  thisGeom = None, otherGeom  = None,   thisGeomEndPnt =None,  ):
    """gets and sets the inception angle between thisGeom at thisEndPnt with otherGeom and writes (sets) it to the termRowDict"""
    if not thisGeom:           #-- if thisGeom is None then the user already knows that thisGeom and otherGeom have no intersects
        #--                                               in that case set the angles to the NoData values of -999.99 and return
        termRowDict['angle1'] = -999.99
        termRowDict['angle3'] = -999.99
        termRowDict['angle5'] = -999.99
        return termRowDict
        
    if thisGeomEndPnt == None: thisGeomEndPnt = thisGeom #-- the function assumes that the intersectionPoint is already provided, 
                                                                                    #if not then take the thisGeom for intersectsAt()
    _pnt,  _u_on_othergeom,  vertexPair_on_othergeom,  _otherSegm  = intersectsAt(thisGeomEndPnt, otherGeom  )
    
    if not _otherSegm:           #-- if thisGeom is None then the user already knows that thisGeom and otherGeom have no intersects
        #--                                               in that case set the angles to the NoData values of -999.99 and return
        termRowDict['angle1'] = -999.99
        termRowDict['angle3'] = -999.99
        termRowDict['angle5'] = -999.99
        return termRowDict
    
    _angle = get_angle_at_u( thisGeom,  _otherSegm, 0.0)
    if _angle: 
        ##logger.debug("V-type intersect with angle with othercurve[%s] = %s at 0.0 m " % ( i_other_curve,  _angle) )
        termRowDict['angle1'] = _angle
    _angle = get_angle_at_u( thisGeom,  _otherSegm, 0.05)
    if _angle: 
        ##logger.debug("V-type intersect with angle with othercurve[%s] = %s at 0.03 m " % ( i_other_curve,  _angle) )
        termRowDict['angle3'] = _angle
    _angle = get_angle_at_u( thisGeom,  _otherSegm, 0.50)
    if _angle:
        ##logger.debug("V-type intersect with angle with othercurve[%s] = %s at 0.3 m " % ( i_other_curve,  _angle) )
        termRowDict['angle5'] = _angle
    
    return termRowDict

def get_angle_at_u( _otherGeom,  _thisSegm,  _u ):
    """get the angle between thisSegment and a segment from otherGeom at distance _u"""
    _thisDirVect =  DF_Vector.DF_Vect3D ( segmentDirVPnt( _thisSegm ) )
    #-- NJH  27-07-16!!!! POTENTIAL BUG HERE: at least not the behavior whished for
    #--   _u should be the distance from otherGeom endPoint closest to thisSegment.  
    _otherDirVector = DirVectAt( _otherGeom,  _u)
    _angle = get_interceptAngle( _thisDirVect , _otherDirVector )
    return _angle
    
def appendTermRowDict2TermTable( terminationsTable,  terminationRowDict ):
    if isinstance( terminationsTable ,  list ):
        terminationsTable.append( terminationRowDict )
    else:  #-- i.e. it is a H5Py (HDF5) table  the dictionary should be appended as a terminationsTable.row
        tableRowDict = terminationsTable.row
        for key,  value in terminationRowDict.iteritems():
            tableRowDict[key] = value   #--NJH 27-07: maybe not the correct way: does this make a shallow copy of the terminationRowDict into the  terminationsTable.row?
        tableRowDict.append()
    return True

def add_endPointTypeRecords2TerminationTable( terminationsTable, curveList, icurve, otherCurveList,  domain,  _precision=0.01 ):
    """See Sanderson & Nixon,  2015: The use of topology in fracture network characterization"""
    from shapely import wkt
    
    startPointFlag = None
    endPointFlag = None
    
    if not  isinstance( curveList[icurve] ,  QgsCore.QgsGeometry ):
        #-- NJH 31-07-2016: so the curve is a QgsFeature.: slower but better for now able to fetch the actual ID from the feature.attributes 
        geom = curveList[icurve].geometry()
        ID_curve = curveList[icurve].attributes()[0]
    else: 
        geom =curveList[icurve]
        ID_curve = icurve
    #geom =curveList[icurve]
    
    vertexList = geom.asPolyline()
    
    #logger.debug("in get_endPointType() with icurve: %s and vertexList: %s" % ( icurve , vertexList ) )
    if not len(vertexList) >= 1:
        return terminationsTable
    
    #-- Determine if the startPoint and endPoint sit within the domain. If not then the Flags are set to 99, 
    #--          then lineament extends to outside of the domain
    startPoint = vertexList[0]
    if not QgsCore.QgsGeometry().fromPoint(startPoint).intersects(domain):
        startPointFlag = 99
    startPointBuffered = QgsCore.QgsGeometry().fromPoint(startPoint).buffer( _precision , 11 )
    endPoint  = vertexList[-1]
    if not QgsCore.QgsGeometry().fromPoint(endPoint).intersects(domain):
        endPointFlag = 99
    endPointBuffered = QgsCore.QgsGeometry().fromPoint(endPoint).buffer( _precision , 11 )

    i_other_curve = 0
    while i_other_curve < len( otherCurveList ):
        ##logger.debug("in get_endPointType_v2() with icurve: %s and i_other_curve: %s" % ( icurve, i_other_curve ) )

        if not isinstance( otherCurveList[i_other_curve] ,  QgsCore.QgsGeometry ):
            #-- NJH 31-07-2016: so the curve is a QgsFeature.: slower but better for now able to fetch the actual ID from the feature.attributes 
            othergeom = otherCurveList[i_other_curve].geometry()
            ID_other_curve = otherCurveList[i_other_curve].attributes()[0]
        else: 
            othergeom = otherCurveList[i_other_curve]
            ID_other_curve = i_other_curve  #-- NJH 31-07-2016: this is not necessarily true, but if the curvelist holds geometries and not the features, 
                                                             #--    then there is no way to call for the attributes and find the corresponding id value at .attibutes[0]
    
        _overlapWithOtherCurve= normOverlap_withOtherGeom(geom,  othergeom,  0.01 )
        ##if _overlapWithOtherCurve > 0.99:
        ##if _overlapWithOtherCurve > 0.99 or shapely.wkt.loads( str(geom.exportToWkt() ) ).almost_equals( shapely.wkt.loads( str(othergeom.exportToWkt() ) )) :
        if _overlapWithOtherCurve > 0.99 or wkt.loads( str(geom.exportToWkt() ) ).almost_equals( wkt.loads( str(othergeom.exportToWkt() ) )) :
            #logger.debug( "<<%s<< step_-4.1 geom[%s] overlapping with othercurve[%s] ->  %s curve: %s | othercurve: %s" % ( __builtin__.recurrencyLvl, icurve,  i_other_curve, geom.intersection(othergeom).exportToWkt(), geom.exportToWkt(), othergeom.exportToWkt() ) )
            #logger.debug("in get_endPointType_v2() with _overlapWithOtherCurve occurs for icurve: %s with i_other_curve: %s" % ( icurve, i_other_curve ) )
            i_other_curve+= 1
            continue
            #return terminationsTable
        
        otherVertexList = othergeom.asPolyline()
        otherStartPoint = QgsCore.QgsGeometry.fromPoint( otherVertexList[0] )
        otherEndPoint = QgsCore.QgsGeometry.fromPoint( otherVertexList[-1] )
        
        #-- If startPointFlag is not already set at this point, then the startPoint sits within the domain and analyses should continue
        if startPointFlag  is None:
            if startPointBuffered.intersects(otherStartPoint) or startPointBuffered.intersects(otherEndPoint):
                #-- startPointType = 4  #-- 3 = V-type startPoint
                terminationRowDict = {}
                terminationRowDict['fractID']     = ID_curve
                terminationRowDict['fraclength'] = geom.length()
                terminationRowDict['otherfraclength'] = othergeom.length()
                terminationRowDict['pntType']         = 0
                terminationRowDict['otherFractID'] = ID_other_curve
                terminationRowDict['terminType'] = 4
                terminationRowDict['x'] = startPoint.x()
                terminationRowDict['y'] = startPoint.y()                
                
                set_InceptionAngles(terminationRowDict,  geom,  othergeom,  startPointBuffered )
                
                startPointFlag = 4
                appendTermRowDict2TermTable( terminationsTable,  terminationRowDict )
                i_other_curve+= 1
                continue
                
            elif startPointBuffered.intersects(othergeom):
                #-- startPointType = 2 #-- 2 = T/Y-type startPoint
                terminationRowDict = {}
                terminationRowDict['fractID'] = ID_curve
                terminationRowDict['fraclength'] = geom.length()
                terminationRowDict['otherfraclength'] = othergeom.length()
                terminationRowDict['pntType'] = 0
                terminationRowDict['otherFractID'] = ID_other_curve
                terminationRowDict['terminType'] = 2
                terminationRowDict['x'] = startPoint.x()
                terminationRowDict['y'] = startPoint.y()
                
                set_InceptionAngles(terminationRowDict, geom, othergeom, startPointBuffered )

                startPointFlag = 2
                appendTermRowDict2TermTable( terminationsTable,  terminationRowDict )
                i_other_curve+= 1
                continue
                #terminationDict[icurve]['othergeom']=i_other_curve       
        
        #-- If endPointFlag is not already set at this point, then the endPoint sits within the domain and analyses should continue
        if endPointFlag  is None:
            if endPointBuffered.intersects(otherStartPoint) or endPointBuffered.intersects(otherEndPoint):
                #endPointType = 4  #-- 4= V-type endPoint
                
                terminationRowDict = {}
                
                terminationRowDict['fractID'] = ID_curve
                terminationRowDict['fraclength'] = geom.length()
                terminationRowDict['otherfraclength'] = othergeom.length()
                terminationRowDict['pntType'] = 1
                terminationRowDict['otherFractID'] = ID_other_curve
                terminationRowDict['terminType'] = 4
                terminationRowDict['x'] = startPoint.x()
                terminationRowDict['y'] = startPoint.y()
                
                set_InceptionAngles(terminationRowDict,  geom, othergeom, endPointBuffered )
                
                endPointFlag = 4
                appendTermRowDict2TermTable( terminationsTable,  terminationRowDict )
                i_other_curve+= 1
                continue
                
            elif endPointBuffered.intersects(othergeom):
                #endPointType = 2 #-- 2 = T / Y-type endPoint
                
                terminationRowDict = {}
                terminationRowDict['fractID'] = ID_curve
                terminationRowDict['fraclength'] = geom.length()
                terminationRowDict['otherfraclength'] = othergeom.length()
                terminationRowDict['pntType'] = 1
                terminationRowDict['otherFractID'] = ID_other_curve
                terminationRowDict['terminType'] = 2
                terminationRowDict['x'] = startPoint.x()
                terminationRowDict['y'] = startPoint.y()
                
                set_InceptionAngles(terminationRowDict,  geom, othergeom, endPointBuffered )

                endPointFlag = 2
                appendTermRowDict2TermTable( terminationsTable,  terminationRowDict )
                i_other_curve+= 1
                continue
        
        if geom.buffer(_precision, 7).intersects(othergeom):
            #-- startPointType = 1; X intersection 
            terminationRowDict = {}
            terminationRowDict['fractID'] = ID_curve
            terminationRowDict['fraclength'] = geom.length()
            terminationRowDict['otherfraclength'] = othergeom.length()
            terminationRowDict['pntType'] = 2
            terminationRowDict['otherFractID'] =ID_other_curve
            terminationRowDict['terminType'] = 5
            xpoint = geom.intersection(othergeom).asPoint()
            terminationRowDict['x'] = xpoint.x()
            terminationRowDict['y'] = xpoint.y()
            
            set_InceptionAngles(terminationRowDict,  geom,  othergeom )
            appendTermRowDict2TermTable( terminationsTable,  terminationRowDict )
        
        i_other_curve+= 1
    
    if startPointFlag  is None:
        #I-type endPoint
        terminationRowDict = {}
        terminationRowDict['fractID'] = ID_curve
        terminationRowDict['fraclength'] = geom.length()
        terminationRowDict['otherfraclength'] = othergeom.length()
        terminationRowDict['pntType'] = 0
        terminationRowDict['otherFractID'] = -99
        terminationRowDict['terminType'] = 0
        terminationRowDict['x'] = startPoint.x()
        terminationRowDict['y'] = startPoint.y()
        set_InceptionAngles( terminationRowDict  ) #-- when not intersection, set_InceptionAngles will assign NoData values.
        appendTermRowDict2TermTable( terminationsTable,  terminationRowDict )
    
    if endPointFlag is None:
        #I-type endPoint
        terminationRowDict = {}
        terminationRowDict['fractID'] = ID_curve
        terminationRowDict['fraclength'] = geom.length()
        terminationRowDict['otherfraclength'] = othergeom.length()
        terminationRowDict['pntType'] = 1
        terminationRowDict['otherFractID'] = -99
        terminationRowDict['terminType'] = 0
        terminationRowDict['x'] = startPoint.x()
        terminationRowDict['y'] = startPoint.y()
        set_InceptionAngles( terminationRowDict  ) #-- when not intersection, set_InceptionAngles will assign NoData values.
        appendTermRowDict2TermTable( terminationsTable,  terminationRowDict )
    
    if not isinstance( terminationsTable,  list):
        terminationsTable.flush()    
        logger.debug( "in get_endPointType() with terminationsTable: %s" % ( terminationsTable.nrows ) )
    
    return terminationsTable
