import os, sys,  imp
import logging

logger = logging.getLogger("DigiFractLogger") 
logger.setLevel(logging.DEBUG)
#logger.setLevel(logging.INFO)

logFilePath = os.path.join( os.getcwd(),"logfile_DigiFract.log" )
if os.path.isfile(logFilePath): os.remove(logFilePath)

log2fileHandle = logging.FileHandler( logFilePath ,  mode='a' )
#log2fileHandle.setLevel(logging.DEBUG)
log2fileHandle.setLevel(logging.DEBUG)
##formatter = logging.Formatter('%(message)s')
formatter = logging.Formatter('%(asctime)s | %(name)s|%(levelname)s: %(message)s')
log2fileHandle.setFormatter(formatter)
logger.addHandler(log2fileHandle)

import numpy
from osgeo import ogr

from PyQt4 import QtCore
import qgis.core as QgsCore

QGIS_basePath = os.path.normpath( os.path.join( os.environ['OSGEO4W_ROOT'] , "apps\\qgis" ) )
QgsCore.QgsApplication.setPrefixPath( QGIS_basePath , True)
QgsCore.QgsApplication.initQgis()

from twoDGeomBaseLib.core import geomBasicOperations
from twoDGeomBaseLib.core import connectivityOperations

from stochSimLib import fractModelSets
from stochSimLib import StoSim_algorithms

#-- set simBaseFolder
simBaseFolder       = os.path.normpath("D:\\FracSim2D_StochFracNetworkModeller\\MODELS")
sys.path.insert(0 , os.path.join( os.path.join( simBaseFolder, "stochSimInput" ) ) )

simulationName    = "Step_By_Step_Simulation"
CfgFracMdlFileNm   = "sim4test_GeoConstraint_StepByStep"
print "sys.path: %s" % sys.path
mdlCgf = __import__( CfgFracMdlFileNm )

simoutputfolder = os.path.join( mdlCgf.simOutputFolder ,  simulationName )

translate_nd_rotate_domain_aligned_around_origin = False
translate_nd_rotate_fractstochparams                     = False
gen_intersection_points = False

_activeOutcropBoundIdx = 0

import __builtin__

def init_vectorLayer( name,  sourceString, defString,  coordSystDict ):
    _layer = QgsCore.QgsVectorLayer(  defString, "%sLayer" % name, "memory")
    sourceString = os.path.normpath( os.path.join( simBaseFolder, "%s" % ( simulationName ) , "successCentroids_%s_%s.shp" % (  _fractLevel.name ,  simulationName )  ) )
    logger.debug("in main() with sourceString for %sLayer: %s" % ( name ,  sourceString ) )
    QgsCore.QgsVectorFileWriter.writeAsVectorFormat( _layer, sourceString ,  'System', QgsCore.QgsCoordinateReferenceSystem( mdlCgf.epsgCode, QgsCore.QgsCoordinateReferenceSystem.EpsgCrsId ) )
    _layer = QgsCore.QgsVectorLayer( sourceString , "%sLayer" % name , "ogr")
    return _layer

    
def main_function():
    print( "Welcome to StatFrac - let's start the stochastic simulation" )
    logger.info( "# ##########################\n#Welcome to StatFrac - let's start the stochastic simulation\n# ##########################\n" )
    
    args = sys.argv[1:]
    
    __surfBoundGeom = QgsCore.QgsGeometry()
    print "mdlCgf.surfBoundGeomWkt : %s" % mdlCgf.surfBoundGeomWkt 
    _surfBoundGeom = __surfBoundGeom.fromWkt( mdlCgf.surfBoundGeomWkt )
    logger.debug("in main with __surfBoundGeom.exportToWkt(): %s"  %   __surfBoundGeom.exportToWkt() )
    logger.debug("in main with _surfBoundGeom.exportToWkt(): %s"  %   _surfBoundGeom.exportToWkt() )
    
    #simFractNetwork = mdlCgf.simFractNetwork( myLocationSpace.activeOutcropSpace ,  simulationName ,  simoutputfolder )
    sourcePath = os.path.join( simBaseFolder, "%s" % ( simulationName )  )
    myModelSpace = fractModelSets.Sfm_modelSpace( sourcePath,  _surfBoundGeom )
    simFractNetwork = mdlCgf.simFractNetwork( myModelSpace ) # myLocationSpace.activeOutcropSpace,  simulationName   )
    
    #-- NJH 26-07: so far the connectivityOperations only allows for 
    connOperator = connectivityOperations.connectivityOperatorSingleLyr( simFractNetwork )
    _injector = QgsCore.QgsGeometry().fromWkt( mdlCgf.injectorWkt )
    connOperator.set_injector( _injector  )   #
    _producer = QgsCore.QgsGeometry().fromWkt( mdlCgf.producerWkt )
    connOperator.set_producer( _producer )   #
    connOperator.set_precision(1.0e-3)
    
    for fractLevelIdx, _fractLevel  in enumerate( simFractNetwork.levels ):
        #centroidSuccessLayer = init_vectorLayer( name,  sourceString, defString,  coordSystDict )
        centroidSuccessLayer = QgsCore.QgsVectorLayer( "Point?field=id:integer&field=fractset:string&field=cause:string" , "centroids", "memory")
        sourceString = os.path.normpath( os.path.join( simBaseFolder, "%s" % ( simulationName ) , "successCentroids_%s_%s.shp" % (  _fractLevel.name ,  simulationName )  ) )
        logger.debug("in main() with sourceString for centroidSuccessLayer: %s" % sourceString )
        QgsCore.QgsVectorFileWriter.writeAsVectorFormat( centroidSuccessLayer, sourceString ,  'System', QgsCore.QgsCoordinateReferenceSystem( mdlCgf.epsgCode, QgsCore.QgsCoordinateReferenceSystem.EpsgCrsId ) )
        centroidSuccessLayer = QgsCore.QgsVectorLayer( sourceString , "centroidSuccessLayer", "ogr")      
        
        #centroidSuccessLayer = init_vectorLayer( name,  sourceString, defString,  coordSystDict )
        centroidFailureLayer = QgsCore.QgsVectorLayer( "Point?field=id:integer&field=fractset:string&field=cause:string" , "centroids", "memory")
        sourceString = os.path.normpath( os.path.join( simBaseFolder, "%s" % ( simulationName ) , "failureCentroids_%s_%s.shp" % (  _fractLevel.name ,  simulationName )  ) )
        logger.debug("in main() with sourceString for centroidFailureLayer: %s" % sourceString )
        QgsCore.QgsVectorFileWriter.writeAsVectorFormat( centroidFailureLayer,  sourceString  ,  'System', QgsCore.QgsCoordinateReferenceSystem( mdlCgf.epsgCode, QgsCore.QgsCoordinateReferenceSystem.EpsgCrsId ) )
        centroidFailureLayer = QgsCore.QgsVectorLayer(  sourceString, "centroidSuccessLayer" , "ogr")     
        
        _attempt = 1
        fractLevel = _fractLevel.deepcopy()
        while len( fractLevel.fractSetIdxs ) > 0:
            logger.info( "This is fractLevelIdx: %s | FractLevelNm: %s with FractLevelSets: %s" % ( fractLevelIdx,  fractLevel.name, fractLevel.fractSetIdxs ) )
            logger.debug( "fractLevel.superpositionprobs: %s and fractLevel.get_cumul_probs(): %s " % ( fractLevel.superpositionprobs,  fractLevel.get_cumul_probs() ) )
            randomIdx = StoSim_algorithms.Gen_RandomIdx( fractLevel.get_cumul_probs() )
            fractSetIdx = fractLevel.fractSetIdxs[randomIdx]
            logger.debug( "going to a newly (stochastically) generated fracture to FractSetName: %s" % simFractNetwork.fractSets[fractSetIdx].name )
        
            simFractNetwork.startEditing()
            randFractGenerator = simFractNetwork.fractSets[fractSetIdx].generator
            _continue = True
            __builtin__.recurrencyLvl = 0

            centroidSuccessLayer.startEditing()
            centroidFailureLayer.startEditing()
        
            #-- set randomFracture mode and placerConstraint base on previous generated fracture
            _continue = randFractGenerator.generate()
            if  _continue:
                logger.debug("in stochastic simulation outer loop in main script with randomFract: %s and _continue: %s" %  ( randFractGenerator.fracture, _continue ) )
                if randFractGenerator.fracture:
                    centroidFeat = QgsCore.QgsFeature( centroidSuccessLayer.dataProvider().fields() )
                    centroidFeat.setAttribute( 0, _attempt  )
                    centroidFeat.setAttribute( 1, simFractNetwork.fractSets[fractSetIdx].name )
                    centroidFeat.setAttribute( 2, 'success' )
                    centroidFeat.setGeometry( QgsCore.QgsGeometry.fromPoint( randFractGenerator.centroid ) )
                    _success = centroidSuccessLayer.addFeature( centroidFeat,  True )
                    _success = simFractNetwork.addFeature( randFractGenerator.fracture,  True )
                else:
                    centroidFeat = QgsCore.QgsFeature( centroidFailureLayer.dataProvider().fields() )
                    centroidFeat.setAttribute( 0, _attempt )
                    centroidFeat.setAttribute( 1, simFractNetwork.fractSets[fractSetIdx].name )
                    centroidFeat.setAttribute( 2, randFractGenerator.failureState )
                    centroidFeat.setGeometry( QgsCore.QgsGeometry.fromPoint( randFractGenerator.centroid ) )
                    centroidFailureLayer.addFeature( centroidFeat,  True )
            else:
                    centroidFeat = QgsCore.QgsFeature( centroidFailureLayer.dataProvider().fields() )
                    centroidFeat.setAttribute( 0, _attempt )
                    centroidFeat.setAttribute( 1, simFractNetwork.fractSets[fractSetIdx].name )
                    centroidFeat.setAttribute( 2, randFractGenerator.failureState )
                    centroidFeat.setGeometry( QgsCore.QgsGeometry.fromPoint( randFractGenerator.centroid ) )
                    logger.debug( "in outer loop in main script - with failed fracture centroid: %s " %  ( centroidFeat  ) ) 
                    centroidFailureLayer.addFeature( centroidFeat,  True )
                    
            _attempt +=1

            simFractNetwork.invertSelection()
            #fractlist = simFractNetwork.selectedFeatures() 
            fractlist = list(simFractNetwork.getFeatures(  QgsCore.QgsFeatureRequest().setFilterExpression( u'"SetNm" = \'%s\'' % ( simFractNetwork.fractSets[fractSetIdx]._name ) )) )
            _currentP21 = StoSim_algorithms.calc_P21( fractlist, simFractNetwork.dataSpace.domainBound )
            P21Limit = simFractNetwork.get_P21Limit( simFractNetwork.fractSets[fractSetIdx].name )
            logger.info("in main script with %s / %s (currentP21/P21Limit) for layer: %s" % ( _currentP21,  P21Limit,  simFractNetwork.fractSets[fractSetIdx].name ) )
            reachedP21limit = False
            if _currentP21 >= P21Limit: reachedP21limit = True
            simFractNetwork.removeSelection()
            simFractNetwork.commitChanges()
            
            #for fract in simFractNetwork[fractSetIdx].getFeatures():
            fractlist = list(simFractNetwork.getFeatures())
            #logger.debug( "in stochastic simulation outer loop in main script - with fract.geometry().exportToWkt(): %s" % ( fract.geometry().exportToWkt() ) )
            _geom = fractlist[ simFractNetwork.nextFreeFeatureID() -1].geometry()
            #logger.debug( "in stochastic simulation outer loop in main script - with just added fracture: %s" %  ( _geom.exportToWkt()   ) )

            centroidFailureLayer.commitChanges()
            centroidSuccessLayer.commitChanges()
            
            if reachedP21limit:
                #connOperator.checkSet4clusters( )
                #wellsBridged,  conn2injector,  conn2producer = connOperator.check2wells( _injector,  _producer )
                
                #logger.info(" ############ CONNECTIVITY REPORT  ##############")
                #logger.info(" # lines in connOperator.pLineaments: %s \t#" % connOperator.pLineaments.featureCount())
                #logger.info(" # N connected clusters for P21 of %s: %s" % ( _currentP21, len(connOperator.clusters) ) )
                #logger.info(" # clusters connected 2injector: %s 2producer %s" % ( conn2injector,  conn2producer  ) )
                #logger.info(" ############ CONNECTIVITY REPORT  ##############")
                
                ##if wellsBridged:
                #logger.debug("just before removing fractSet[%s] so that fractLevel contains: %s \nHowever, the  simFractNetwork.levels[%s] is untouched, right? %s" % ( fractSetIdx,  fractLevel.fractSetIdxs, fractLevelIdx,  simFractNetwork.levels[fractLevelIdx].fractSetIdxs ) )
                #connOperator.assign_clusterIdx()
                
                fractLevel.remove_set( fractSetIdx )
                reachedP21limit = False
                logger.debug("just removed fractSet[%s] so that fractLevel contains: %s \nHowever, the  simFractNetwork.levels[%s] is untouched, right? %s" % ( fractSetIdx,  fractLevel.fractSetIdxs, fractLevelIdx,  simFractNetwork.levels[fractLevelIdx].fractSetIdxs ) )
    
if( __name__ == "__main__" ):
    main_function()
