from stochSimLib import fractModelSets 
import numpy

import qgis.core as QgsCore

ProjectName    = "Whitby"
session_suffix = "02-06-15_2346"
OutcropNm      = "WHI6"

DigiSurfBound_FileNm = "boundaries.shp"
digiSurfaceIdx = 0
Fractures_FileNm = "fractures.shp"
Trackline_FileNm = "tracer.shp"

simOutputFolder = "D:\\research_ToughGas\\mdlStochNetwork\\nestStochFracProj\\output"

epsgCode = 28992
surfBoundGeomWkt = "POLYGON (( -4.0 -6.0, \
        -4.0 6.0, 4.0 6.0, \
        4.0 -6.0 , -4.0 -6.0 ))" ##- WTK Definition of a polygon (see: https://en.wikipedia.org/wiki/Well-known_text_representation_of_geometry)
        
injectorWkt = "LINESTRING(( -5.0 -5.0, -5.0 5.0 ))"
producerWkt = "LINESTRING(( 5.0 -5.0, 5.0 5.0 ))"

##bPointGeom = QgsCore.QgsPoint(647766.0,  6045364.0)

FalseNorthing = numpy.radians(-0.0)
FalseOrigin = None
	
class  simFractNetwork(fractModelSets.fractModelSets):
    def __init__ ( self, myDataSpace ):
        fractModelSets.fractModelSets.__init__( self, myDataSpace )

        self.add_simFractSet_n( 'F1-NS', generator_type= 'randomFracture', modelDomain= myDataSpace.domainBound )  ## Second term in this function defines the type of abutment you get, you can have nonHigherOrderIntersecting, placedAtHOrderFract (cannot intersect the defined FSET), randomFracture, noSelfIntersecting and noEqualLvlIntersecting 
        self.add_simFractSet_n( 'F2-EW', generator_type= 'randomFracture', modelDomain= myDataSpace.domainBound )  ## Second term in this function defines the type of abutment you get, you can have nonHigherOrderIntersecting, placedAtHOrderFract (cannot intersect the defined FSET), randomFracture, noSelfIntersecting and noEqualLvlIntersecting

        
        self.add_Level( 'L1', ['F1-NS'], [1.0] )
        self.add_Level( 'L2', ['F2-EW'], [ 1.0] )
        self.set_P21Limit( 'F1-NS', 2.677 ) ## Set the P21 limit of each fracture set      
        self.set_P21Limit( 'F2-EW', 0.996 ) ## Set the P21 limit of each fracture set
        
        self.fractSets[0].generator.set_sizeGenerator( 'expon', [0.5, 1/0.582, 1] )## Define the length function, you can have Power-law (shape, minlength, maxlength, sampling), uniform (loc, scale, size), lognorm (mean, std, samplesize), fixed (length) and exponential (loc, scale, size) here scale = 1/lambda recommended to set loc at 1
        self.fractSets[0].generator.set_orientGenerator( 'vonmises',   [numpy.radians(-88.38), 40, None , 1] ) 
        #--                     a kappa concentration param of 95, corresponds roughly with SD of 1/30*pi = 5degrees ; a kappa of 33.0, corresponds roughly with SD of 1/18*pi = 10degrees;  a kappa of 4.3, corresponds roughly with SD of 1/6*pi = 30degrees 
        #self.fractSets[0].generator.set_buffer_dist(0.15) ##-- Buffer distance (m) for each fracture set
        #self.fractSets[0].generator.set_proximity_condition(True)
        #self.fractSets[0].generator.set_nonSameLevelIntersect_condition(True)
        #self.fractSets[0].generator.set_nonIntersecting_fractSets( [ 'F1-NS', 'F2-EW'] ) ## Create fracture sets with density relations (or self abutment relations)
        
        #self[1].generator.set_sizeGenerator(    'lognorm',   [0.2, 0.5, 1] )
        self.fractSets[1].generator.set_sizeGenerator( 'expon', [0.13, 1/1.563, 1] )  ## Define the length function, you can have Power-law (shape, minlength, maxlength, sampling), uniform (loc, scale, size), lognorm (mean, std, samplesize), fixed (length) and exponential (loc = skewing the curve, lambda = incline, size)
        self.fractSets[1].generator.set_orientGenerator( 'vonmises',   [numpy.radians(177.68), 30.0, None , 1] )    #[-0.87, 1.0, 0.52 , 1] )   #[-0.87, 0.05, 0.05 , 1] )  
        #--                     a kappa concentration param of 95, corresponds roughly with SD of 1/30*pi = 5degrees ; a kappa of 33.0, corresponds roughly with SD of 1/18*pi = 10degrees;  a kappa of 4.3, corresponds roughly with SD of 1/6*pi = 30degrees 
        #self.fractSets[1].generator.set_buffer_dist(0.15) ##-- Buffer distance (m) for each fracture set
        #self.fractSets[1].generator.set_proximity_condition(True)
        #self.fractSets[1].generator.set_nonSameLevelIntersect_condition(True)
        #self.fractSets[1].generator.set_nonIntersecting_fractSets( [ 'F1-NS', 'F2-EW'] )## Create fracture sets with density relations (or self abutment relations)
        
        
 

