from stochSimLib import fractModelSets 
import numpy

import qgis.core as QgsCore

ProjectName    = "Whitby"
session_suffix = "02-06-15_2346"
OutcropNm      = "WHI6"

DigiSurfBound_FileNm = "boundaries.shp"
digiSurfaceIdx = 0
Fractures_FileNm = "fractures.shp"
Trackline_FileNm = "tracer.shp"

simOutputFolder = "D:\\research_ToughGas\\mdlStochNetwork\\nestStochFracProj\\output"

epsgCode = 28992
surfBoundGeomWkt = "POLYGON (( -1.25 -1.25, \
        -1.25 1.25, 1.25 1.25, \
        1.25 -1.25 , -1.25 -1.25 ))" ##- WTK Definition of a polygon (see: https://en.wikipedia.org/wiki/Well-known_text_representation_of_geometry)
        
injectorWkt = "LINESTRING(( -5.0 -5.0, -5.0 5.0 ))"
producerWkt = "LINESTRING(( 5.0 -5.0, 5.0 5.0 ))"

##bPointGeom = QgsCore.QgsPoint(647766.0,  6045364.0)

FalseNorthing = numpy.radians(-0.0)
FalseOrigin = None
	
class  simFractNetwork(fractModelSets.fractModelSets):
    def __init__ ( self, myDataSpace ):
        fractModelSets.fractModelSets.__init__( self, myDataSpace )

        self.add_simFractSet_n( 'F1-EW', generator_type= 'nonHigherOrderIntersecting', modelDomain= myDataSpace.domainBound )  ## Second term in this function defines the type of abutment you get, you can have nonHigherOrderIntersecting, placedAtHOrderFract (cannot intersect the defined FSET), randomFracture, noSelfIntersecting and noEqualLvlIntersecting 
        self.add_simFractSet_n( 'F2-NS', generator_type= 'nonHigherOrderIntersecting', modelDomain= myDataSpace.domainBound )  ## Second term in this function defines the type of abutment you get, you can have nonHigherOrderIntersecting, placedAtHOrderFract (cannot intersect the defined FSET), randomFracture, noSelfIntersecting and noEqualLvlIntersecting

        self.add_simFractSet_n( 'F3-ESE', generator_type= 'noSelfIntersecting', modelDomain= myDataSpace.domainBound )  ## Second term in this function defines the type of abutment you get, you can have nonHigherOrderIntersecting, placedAtHOrderFract (cannot intersect the defined FSET), randomFracture, noSelfIntersecting and noEqualLvlIntersecting 
        self.add_simFractSet_n( 'F4-ENE', generator_type= 'noSelfIntersecting', modelDomain= myDataSpace.domainBound )  ## Second term in this function defines the type of abutment you get, you can have nonHigherOrderIntersecting, placedAtHOrderFract (cannot intersect the defined FSET), randomFracture, noSelfIntersecting and noEqualLvlIntersecting
        self.add_simFractSet_n( 'F3-ESE_lo', generator_type= 'nonHigherOrderIntersecting', modelDomain= myDataSpace.domainBound )
        self.add_simFractSet_n( 'F4-ENE_lo', generator_type= 'nonHigherOrderIntersecting', modelDomain= myDataSpace.domainBound )  ## Second term in this function defines the type of abutment you get, you can have nonHigherOrderIntersecting, placedAtHOrderFract (cannot intersect the defined FSET), randomFracture, noSelfIntersecting and noEqualLvlIntersecting

        self.add_Level( 'L1', ['F1-EW'], [1.0] )
        self.add_Level( 'L2', ['F2-NS'], [1.0] )
        self.add_Level( 'L3', ['F3-ESE'], [1.0] )
        self.add_Level( 'L4', ['F4-ENE'], [1.0] )
        self.add_Level( 'L5', ['F3-ESE_lo', 'F4-ENE_lo'], [1.0, 1.0] )
        ## You can add multiple fracture sets in one level, the third term in the function defines the abutment probability
        
        
        
        self.set_P21Limit( 'F1-EW', 4.234) ## Set the P21 limit of each fracture set
        self.set_P21Limit( 'F2-NS', 1.117) ## Set the P21 limit of each fracture set      
        self.set_P21Limit( 'F3-ESE', 2.53) ## Set the P21 limit of each fracture set      
        self.set_P21Limit( 'F4-ENE', 1.0) ## Set the P21 limit of each fracture set
        self.set_P21Limit( 'F3-ESE_lo', 0.5) ## Set the P21 limit of each fracture set
        self.set_P21Limit( 'F4-ENE_lo', 0.5) ## Set the P21 limit of each fracture set
        self.fractSets[0].generator.set_sizeGenerator( 'fixed', [10.0] ) ## Define the length function, you can have Power-law (shape, minlength, maxlength, sampling), uniform (loc, scale, size), lognorm (mean, std, samplesize), fixed (length) and exponential (loc, scale, size) here scale = 1/lambda recommended to set loc at 1
        self.fractSets[0].generator.set_orientGenerator( 'vonmises',   [numpy.radians(90), 250, None , 1] ) 
        #--                     a kappa concentration param of 95, corresponds roughly with SD of 1/30*pi = 5degrees ; a kappa of 33.0, corresponds roughly with SD of 1/18*pi = 10degrees;  a kappa of 4.3, corresponds roughly with SD of 1/6*pi = 30degrees 
        self.fractSets[0].generator.set_buffer_dist(0.15) ##-- Buffer distance (m) for each fracture set
        self.fractSets[0].generator.set_proximity_condition(True)
        #self.fractSets[0].generator.set_nonSameLevelIntersect_condition(True)
        self.fractSets[0].generator.set_nonIntersecting_fractSets( [ 'F2-NS', 'F1-EW'] ) ## Create fracture sets with density relations (or self abutment relations)
        
        #self[1].generator.set_sizeGenerator(    'lognorm',   [0.2, 0.5, 1] )
        self.fractSets[1].generator.set_sizeGenerator( 'fixed', [7.5] ) ## Define the length function, you can have Power-law (shape, minlength, maxlength, sampling), uniform (loc, scale, size), lognorm (mean, std, samplesize), fixed (length) and exponential (loc = skewing the curve, lambda = incline, size)
        self.fractSets[1].generator.set_orientGenerator( 'vonmises',   [numpy.radians(0.0), 250.0, None , 1] )    #[-0.87, 1.0, 0.52 , 1] )   #[-0.87, 0.05, 0.05 , 1] )  
        #--                     a kappa concentration param of 95, corresponds roughly with SD of 1/30*pi = 5degrees ; a kappa of 33.0, corresponds roughly with SD of 1/18*pi = 10degrees;  a kappa of 4.3, corresponds roughly with SD of 1/6*pi = 30degrees 
        self.fractSets[1].generator.set_buffer_dist(0.15) ##-- Buffer distance (m) for each fracture set
        self.fractSets[1].generator.set_proximity_condition(True)
        #self.fractSets[1].generator.set_nonSameLevelIntersect_condition(True)
        self.fractSets[1].generator.set_nonIntersecting_fractSets( ['F2-NS', 'F1-EW'])## Create fracture sets with density relations (or self abutment relations)
        
        self.fractSets[2].generator.set_sizeGenerator( 'fixed', [5.0] ) ## Define the length function, you can have Power-law (shape, minlength, maxlength, sampling), uniform (loc, scale, size), lognorm (mean, std, samplesize), fixed (length) and exponential (loc, scale, size) here scale = 1/lambda recommended to set loc at 1
        self.fractSets[2].generator.set_orientGenerator( 'vonmises',   [numpy.radians(113), 100, None , 1] ) 
        #--                     a kappa concentration param of 95, corresponds roughly with SD of 1/30*pi = 5degrees ; a kappa of 33.0, corresponds roughly with SD of 1/18*pi = 10degrees;  a kappa of 4.3, corresponds roughly with SD of 1/6*pi = 30degrees 
        self.fractSets[2].generator.set_buffer_dist(0.25) ##-- Buffer distance (m) for each fracture set
        self.fractSets[2].generator.set_proximity_condition(True)
        self.fractSets[2].generator.set_nonSameLevelIntersect_condition(True)
        self.fractSets[2].generator.set_nonIntersecting_fractSets( ['F3-ESE'] ) ## Create fracture sets with density relations (or self abutment relations)
        
        #self[1].generator.set_sizeGenerator(    'lognorm',   [0.2, 0.5, 1] )
        self.fractSets[3].generator.set_sizeGenerator( 'fixed', [5.0] ) ## Define the length function, you can have Power-law (shape, minlength, maxlength, sampling), uniform (loc, scale, size), lognorm (mean, std, samplesize), fixed (length) and exponential (loc = skewing the curve, lambda = incline, size)
        self.fractSets[3].generator.set_orientGenerator( 'vonmises',   [numpy.radians(71.6), 100.0, None , 1] )    #[-0.87, 1.0, 0.52 , 1] )   #[-0.87, 0.05, 0.05 , 1] )  
        #--                    a kappa concentration param of 95, corresponds roughly with SD of 1/30*pi = 5degrees ; a kappa of 33.0, corresponds roughly with SD of 1/18*pi = 10degrees;  a kappa of 4.3, corresponds roughly with SD of 1/6*pi = 30degrees 
        self.fractSets[3].generator.set_buffer_dist(0.25) ##-- Buffer distance (m) for each fracture set
        self.fractSets[3].generator.set_proximity_condition(True)
        self.fractSets[3].generator.set_nonSameLevelIntersect_condition(True)
        self.fractSets[3].generator.set_nonIntersecting_fractSets( ['F4-ENE'])## Create fracture sets with density relations (or self abutment relations)
        
        self.fractSets[4].generator.set_sizeGenerator( 'fixed', [1.0] ) ## Define the length function, you can have Power-law (shape, minlength, maxlength, sampling), uniform (loc, scale, size), lognorm (mean, std, samplesize), fixed (length) and exponential (loc = skewing the curve, lambda = incline, size)
        self.fractSets[4].generator.set_orientGenerator( 'vonmises',   [numpy.radians(113), 100.0, None , 1] )    #[-0.87, 1.0, 0.52 , 1] )   #[-0.87, 0.05, 0.05 , 1] )  
        #--                    a kappa concentration param of 95, corresponds roughly with SD of 1/30*pi = 5degrees ; a kappa of 33.0, corresponds roughly with SD of 1/18*pi = 10degrees;  a kappa of 4.3, corresponds roughly with SD of 1/6*pi = 30degrees 
        self.fractSets[4].generator.set_buffer_dist(0.1) ##-- Buffer distance (m) for each fracture set
        self.fractSets[4].generator.set_proximity_condition(True)
        self.fractSets[5].generator.set_nonSameLevelIntersect_condition(True)
        self.fractSets[4].generator.set_nonIntersecting_fractSets( ['F2-NS', 'F1-EW',  'F3-ESE', 'F4-ENE, F3-ESE_lo', 'F4-ENE_lo'])## Create fracture sets with density relations (or self abutment relations)
        
        self.fractSets[5].generator.set_sizeGenerator( 'fixed', [1.0] ) ## Define the length function, you can have Power-law (shape, minlength, maxlength, sampling), uniform (loc, scale, size), lognorm (mean, std, samplesize), fixed (length) and exponential (loc = skewing the curve, lambda = incline, size)
        self.fractSets[5].generator.set_orientGenerator( 'vonmises',   [numpy.radians(71.6), 100.0, None , 1] )    #[-0.87, 1.0, 0.52 , 1] )   #[-0.87, 0.05, 0.05 , 1] )  
        #--                    a kappa concentration param of 95, corresponds roughly with SD of 1/30*pi = 5degrees ; a kappa of 33.0, corresponds roughly with SD of 1/18*pi = 10degrees;  a kappa of 4.3, corresponds roughly with SD of 1/6*pi = 30degrees 
        self.fractSets[5].generator.set_buffer_dist(0.1) ##-- Buffer distance (m) for each fracture set
        self.fractSets[5].generator.set_proximity_condition(True)
        self.fractSets[5].generator.set_nonSameLevelIntersect_condition(True)
        self.fractSets[5].generator.set_nonIntersecting_fractSets( ['F2-NS', 'F1-EW',  'F3-ESE', 'F4-ENE, F3-ESE_lo', 'F4-ENE_lo'])## Create fracture sets with density relations (or self abutment relations)
        
        
