from stochSimLib import fractModelSets 
import numpy

import qgis.core as QgsCore

ProjectName    = "Whitby"
session_suffix = "02-06-15_2346"
OutcropNm      = "WHI6"

DigiSurfBound_FileNm = "boundaries.shp"
digiSurfaceIdx = 0
Fractures_FileNm = "fractures.shp"
Trackline_FileNm = "tracer.shp"

simOutputFolder = "D:\\research_ToughGas\\mdlStochNetwork\\nestStochFracProj\\output"

epsgCode = 28992
surfBoundGeomWkt = "POLYGON (( -25.0 -25.0, \
        -25.0 25.0, 25.0 25.0, \
        25.0 -25.0 , -25.0 -25.0 ))" ##- WTK Definition of a polygon (see: https://en.wikipedia.org/wiki/Well-known_text_representation_of_geometry)
        
injectorWkt = "LINESTRING(( -5.0 -5.0, -5.0 5.0 ))"
producerWkt = "LINESTRING(( 5.0 -5.0, 5.0 5.0 ))"

##bPointGeom = QgsCore.QgsPoint(647766.0,  6045364.0)

FalseNorthing = numpy.radians(-0.0)
FalseOrigin = None
	
class  simFractNetwork(fractModelSets.fractModelSets):
    def __init__ ( self, myDataSpace ):
        fractModelSets.fractModelSets.__init__( self, myDataSpace )

        self.add_simFractSet_n( 'F1-NS', generator_type= 'nonHigherOrderIntersecting', modelDomain= myDataSpace.domainBound )  ## Second term in this function defines the type of abutment you get, you can have nonHigherOrderIntersecting, placedAtHOrderFract (cannot intersect the defined FSET), randomFracture, noSelfIntersecting and noEqualLvlIntersecting 
        self.add_simFractSet_n( 'F2-NWSE', generator_type= 'nonHigherOrderIntersecting', modelDomain= myDataSpace.domainBound )  ## Second term in this function defines the type of abutment you get, you can have nonHigherOrderIntersecting, placedAtHOrderFract (cannot intersect the defined FSET), randomFracture, noSelfIntersecting and noEqualLvlIntersecting
        self.add_simFractSet_n( 'F3-EW', generator_type= 'nonHigherOrderIntersecting', modelDomain= myDataSpace.domainBound )  ## Second term in this function defines the type of abutment you get, you can have nonHigherOrderIntersecting, placedAtHOrderFract (cannot intersect the defined FSET), randomFracture, noSelfIntersecting and noEqualLvlIntersecting

        
        self.add_simFractSet_n( 'F1-NS-LO', generator_type= 'nonHigherOrderIntersecting', modelDomain= myDataSpace.domainBound )  ## Second term in this function defines the type of abutment you get, you can have nonHigherOrderIntersecting, placedAtHOrderFract (cannot intersect the defined FSET), randomFracture, noSelfIntersecting and noEqualLvlIntersecting 
        self.add_simFractSet_n( 'F2-NWSE-LO', generator_type= 'nonHigherOrderIntersecting', modelDomain= myDataSpace.domainBound )  ## Second term in this function defines the type of abutment you get, you can have nonHigherOrderIntersecting, placedAtHOrderFract (cannot intersect the defined FSET), randomFracture, noSelfIntersecting and noEqualLvlIntersecting
        self.add_simFractSet_n( 'F3-EW-LO', generator_type= 'nonHigherOrderIntersecting', modelDomain= myDataSpace.domainBound )  ## Second term in this function defines the type of abutment you get, you can have nonHigherOrderIntersecting, placedAtHOrderFract (cannot intersect the defined FSET), randomFracture, noSelfIntersecting and noEqualLvlIntersecting
        
        self.add_Level( 'L1', ['F1-NS', 'F2-NWSE', 'F3-EW'], [1.0, 0.75, 0.75] )
        self.add_Level( 'L2', ['F1-NS-LO', 'F2-NWSE-LO', 'F3-EW-LO'], [1.0, 1.0, 1.0]) ## You can add multiple fracture sets in one level, the third term in the function defines the abutment probability
        
        self.set_P21Limit( 'F1-NS', 0.18 ) ## Set the P21 limit of each fracture set
        self.set_P21Limit( 'F2-NWSE', 0.04 ) ## Set the P21 limit of each fracture set       
        self.set_P21Limit( 'F3-EW', 0.047 ) ## Set the P21 limit of each fracture set
        
        self.set_P21Limit( 'F1-NS-LO', 0.14 ) ## Set the P21 limit of each fracture set
        self.set_P21Limit( 'F2-NWSE-LO', 0.2 ) ## Set the P21 limit of each fracture set       
        self.set_P21Limit( 'F3-EW-LO', 0.21) ## Set the P21 limit of each fracture set 
        
        self.fractSets[0].generator.set_sizeGenerator( 'fixed', [50.0] ) ## Define the length function, you can have Power-law (shape, minlength, maxlength, sampling), uniform (loc, scale, size), lognorm (mean, std, samplesize), fixed (length) and exponential (loc, scale, size) here scale = 1/lambda recommended to set loc at 1
        self.fractSets[0].generator.set_orientGenerator( 'vonmises',   [numpy.radians(15.7), 70, None , 1] ) 
        #--                     a kappa concentration param of 95, corresponds roughly with SD of 1/30*pi = 5degrees ; a kappa of 33.0, corresponds roughly with SD of 1/18*pi = 10degrees;  a kappa of 4.3, corresponds roughly with SD of 1/6*pi = 30degrees 
        self.fractSets[0].generator.set_buffer_dist(3.0) ##-- Buffer distance (m) for each fracture set
        self.fractSets[0].generator.set_proximity_condition(True)
        #self.fractSets[0].generator.set_nonSameLevelIntersect_condition(True)
        self.fractSets[0].generator.set_nonIntersecting_fractSets( [ 'F1-NS', 'F2-NWSE', 'F3-EW'], [1.0, 1.0, 0.0],  [1.0, 1.0, 1.0 ] ) ## Create fracture sets with density relations (or self abutment relations)
        
        #self[1].generator.set_sizeGenerator(    'lognorm',   [0.2, 0.5, 1] )
        self.fractSets[1].generator.set_sizeGenerator( 'fixed', [25.0] ) ## Define the length function, you can have Power-law (shape, minlength, maxlength, sampling), uniform (loc, scale, size), lognorm (mean, std, samplesize), fixed (length) and exponential (loc = skewing the curve, lambda = incline, size)
        self.fractSets[1].generator.set_orientGenerator( 'vonmises',   [numpy.radians(132.7), 80.0, None , 1] )    #[-0.87, 1.0, 0.52 , 1] )   #[-0.87, 0.05, 0.05 , 1] )  
        #--                     a kappa concentration param of 95, corresponds roughly with SD of 1/30*pi = 5degrees ; a kappa of 33.0, corresponds roughly with SD of 1/18*pi = 10degrees;  a kappa of 4.3, corresponds roughly with SD of 1/6*pi = 30degrees 
        self.fractSets[1].generator.set_buffer_dist(4.0) ##-- Buffer distance (m) for each fracture set
        self.fractSets[1].generator.set_proximity_condition(True)
        #self.fractSets[1].generator.set_nonSameLevelIntersect_condition(True)
        self.fractSets[1].generator.set_nonIntersecting_fractSets( [ 'F1-NS', 'F2-NWSE',  'F3-EW'], [1.0, 1.0, 0.0],  [1.0, 1.0, 1.0 ])## Create fracture sets with density relations (or self abutment relations)
        
        self.fractSets[2].generator.set_sizeGenerator( 'fixed', [25.0] ) ## Define the length function, you can have Power-law (shape, minlength, maxlength, sampling), uniform (loc, scale, size), lognorm (mean, std, samplesize), fixed (length) and exponential (std, mean, size)
        self.fractSets[2].generator.set_orientGenerator( 'vonmises',   [numpy.radians(69.47), 70.0, None , 1] )    #[-0.87, 1.0, 0.52 , 1] )   #[-0.87, 0.05, 0.05 , 1] )  
        #--                     a kappa concentration param of 95, corresponds roughly with SD of 1/30*pi = 5degrees ; a kappa of 33.0, corresponds roughly with SD of 1/18*pi = 10degrees;  a kappa of 4.3, corresponds roughly with SD of 1/6*pi = 30degrees 
        self.fractSets[2].generator.set_buffer_dist(4.0) ##-- Buffer distance (m) for each fracture set
        self.fractSets[2].generator.set_proximity_condition(True)
        #self.fractSets[2].generator.set_nonSameLevelIntersect_condition(True)
        self.fractSets[2].generator.set_nonIntersecting_fractSets( [ 'F1-NS', 'F2-NWSE',  'F3-EW']) ## Create fracture sets with density relations (or self abutment relations) 
        
        self.fractSets[3].generator.set_sizeGenerator( 'fixed', [15.0] )
        #self.fractSets[3].generator.set_sizeGenerator( 'expon', [-10.0, 1/0.106, 1] ) ## Define the length function, you can have Power-law (shape, minlength, maxlength, sampling), uniform (loc, scale, size), lognorm (mean, std, samplesize), fixed (length) and exponential (loc, scale, size) here scale = 1/lambda recommended to set loc at 1
        self.fractSets[3].generator.set_orientGenerator( 'vonmises',   [numpy.radians(14.74), 50, None , 1] ) 
        #--                     a kappa concentration param of 95, corresponds roughly with SD of 1/30*pi = 5degrees ; a kappa of 33.0, corresponds roughly with SD of 1/18*pi = 10degrees;  a kappa of 4.3, corresponds roughly with SD of 1/6*pi = 30degrees 
        self.fractSets[3].generator.set_buffer_dist(0.75) ##-- Buffer distance (m) for each fracture set
        self.fractSets[3].generator.set_proximity_condition(True)
        #self.fractSets[0].generator.set_nonSameLevelIntersect_condition(True)
        self.fractSets[3].generator.set_nonIntersecting_fractSets( [ 'F1-NS', 'F2-NWSE',  'F3-EW', 'F1-NS-LO', 'F2-NWSE-LO',  'F3-EW-LO']) ## Create fracture sets with density relations (or self abutment relations)
        
        self.fractSets[4].generator.set_sizeGenerator( 'fixed', [15.0] )
        #self.fractSets[4].generator.set_sizeGenerator( 'expon', [-5.0, 1/0.272, 1] ) ## Define the length function, you can have Power-law (shape, minlength, maxlength, sampling), uniform (loc, scale, size), lognorm (mean, std, samplesize), fixed (length) and exponential (loc = skewing the curve, lambda = incline, size)
        self.fractSets[4].generator.set_orientGenerator( 'vonmises',   [numpy.radians(135), 80.0, None , 1] )    #[-0.87, 1.0, 0.52 , 1] )   #[-0.87, 0.05, 0.05 , 1] )  
        #--                     a kappa concentration param of 95, corresponds roughly with SD of 1/30*pi = 5degrees ; a kappa of 33.0, corresponds roughly with SD of 1/18*pi = 10degrees;  a kappa of 4.3, corresponds roughly with SD of 1/6*pi = 30degrees 
        self.fractSets[4].generator.set_buffer_dist(0.75) ##-- Buffer distance (m) for each fracture set
        self.fractSets[4].generator.set_proximity_condition(True)
        #self.fractSets[1].generator.set_nonSameLevelIntersect_condition(True)
        self.fractSets[4].generator.set_nonIntersecting_fractSets( [ 'F1-NS', 'F2-NWSE',  'F3-EW', 'F1-NS-LO', 'F2-NWSE-LO',  'F3-EW-LO'])## Create fracture sets with density relations (or self abutment relations)
        
        self.fractSets[5].generator.set_sizeGenerator( 'fixed', [15.0] )
        #self.fractSets[5].generator.set_sizeGenerator( 'expon', [-4.25, 1/0.3, 1] ) ## Define the length function, you can have Power-law (shape, minlength, maxlength, sampling), uniform (loc, scale, size), lognorm (mean, std, samplesize), fixed (length) and exponential (std, mean, size)
        self.fractSets[5].generator.set_orientGenerator( 'vonmises',   [numpy.radians(79.77), 60.0, None , 1] )    #[-0.87, 1.0, 0.52 , 1] )   #[-0.87, 0.05, 0.05 , 1] )  
        #--                     a kappa concentration param of 95, corresponds roughly with SD of 1/30*pi = 5degrees ; a kappa of 33.0, corresponds roughly with SD of 1/18*pi = 10degrees;  a kappa of 4.3, corresponds roughly with SD of 1/6*pi = 30degrees 
        self.fractSets[5].generator.set_buffer_dist(0.75) ##-- Buffer distance (m) for each fracture set
        self.fractSets[5].generator.set_proximity_condition(True)
        #self.fractSets[2].generator.set_nonSameLevelIntersect_condition(True)
        self.fractSets[5].generator.set_nonIntersecting_fractSets( [ 'F1-NS', 'F2-NWSE',  'F3-EW', 'F1-NS-LO', 'F2-NWSE-LO',  'F3-EW-LO']) ## Create fracture sets with density relations (or self abutment relations) 


