function [Qe,Qo,mus,mua]=setup_checkerboard_parameter_functions(nt_sphere,p,t)
	% setup isotropic source Qe, i.e., Qo=0, and scattering and absorption parameters mus, mua according to a checkboard pattern.
	% see Figure 1 in Doelz et al, Journal of Scientific Computing (2022) 90:94 https://doi.org/10.1007/s10915-021-01757-9
np=size(p,2);
nt=size(t,2);

Qo = zeros(3*nt_sphere*nt,1);

% checkerboard
mid=(p(:,t(1,:))+p(:,t(2,:))+p(:,t(3,:)))/3;
x=mid(1,:); y=mid(2,:);
lattice = (x>=1 & x<=2).*((y>=1&y<=2) | (y>=3& y<=4) | (y>=5&y<=6));
lattice = lattice | ((x>=2&x<=3).*((y>=2& y<=3) | (y>=4&y<=5)));
lattice = lattice | ((x>=3&x<=4).*(y>=1& y<=2));
lattice = lattice | ((x>=4&x<=5).*((y>=2& y<=3) | (y>=4&y<=5)));
lattice = lattice | ((x>=5&x<=6).*((y>=1& y<=2) | (y>=3&y<=4) | (y>=5&y<=6)));

mus = 0*ones(1,nt);
mua = 0*ones(1,nt);

mus(not(lattice))=10;
mua(lattice)=1;
mua(not(lattice))=0.01;

x = p(1,:);
y = p(2,:);
Qe=1.*(x>3&x<4).*(y>3&y<4);
Qe =repmat(Qe(:),nt_sphere,1);
end