function [u,it,relres]=richardson(A,f,tol,maxIt,u,tau,pre,stopping,M)
if nargin<2,                    fprintf('Error not enough input arguments.\n'); end
if nargin<3 || isempty(tol),    tol=1e-6; end
if nargin<4 || isempty(maxIt),  maxIt=100; end
if nargin<5 || isempty(u),      u=0*f; end
if nargin<6 || isempty(tau), tau=1; end
if nargin<7 || isempty(pre), pre=@(x)x;end
if nargin<8 || isempty(stopping), stopping='relres';end
if nargin<9 || isempty(M), M=@(x)x;end
if ~(isa(A,'function_handle')),   A=@(x) A*x;end
if ~(isa(pre,'function_handle')), pre=@(x) pre*x;end
if ~(isa(M,'function_handle')), M=@(x) M*x;end

d = f - A(u); % compute residual
w = pre(d);   % preconditioned residual
d0=d;w0=w;
relres=1;du0=sqrt(w'*M(w));du=du0;res=sqrt(w'*d);
for it=1:maxIt
    u = u + tau * w; % updated iterate
	
	% check convergence
    if strcmp(stopping,'relres')
        if w'*d < tol^2*(w0'*d0) || it==maxIt, relres=sqrt((w'*d)/(w0'*d0));break,end;
    elseif strcmp(stopping,'aposteriori')
        du=w/tau;
        du=sqrt(du'*M(du));
        if du< tol*du0 || it==maxIt, relres=du/du0;break,end;
    end
    d = f - A(u); % compute residual
    w = pre(d); % preconditioned residual
end
end