function [p,e,t,prol,prol2]=refinemesh_eig(fd,p,e,t)


np=size(p,2);
nt=size(t,2);

% create new points at edge midpoints
[te,ue,be]=makeedgelist(t,e);
pn = 0.5*(p(:,ue(1,:))+p(:,ue(2,:)));
p=[p,pn];
npn=size(p,2);

% create elements
te=te+np;
t=[ t(1,:),  t(2,:),  t(3,:), te(1,:); ...
    te(1,:), te(2,:), te(3,:), te(2,:); ...
    te(3,:), te(1,:), te(2,:), te(3,:)];
t=[t;ones(1,size(t,2))];
% create boundary elements
be=be+np;
e=[ e(1,:), be; ...
    be,       e(2,:)];

% project points back to the boundary
if ~isempty(fd)
    deps=sqrt(eps); % times element size! (TODO)
    d=dD(p(1:2,np+1:end));
    dgradx=reshape((dD([p(1,np+1:end)+deps;p(2,np+1:end)])-d)/deps,1,npn-np); % Numerical
    dgrady=reshape((dD([p(1,np+1:end);p(2,np+1:end)+deps])-d)/deps,1,npn-np); % gradient = normal
    d=reshape(d,1,npn-np);
    p(1:2,np+1:end)=p(1:2,np+1:end)-[d.*dgradx;d.*dgrady];  % Project back to boundary
end

%prolongation operator pcw. linear
if nargout>3
n_np = size(p,2)-np; %number of new points
kk=[1:n_np]';
ue=ue';
ind=[kk,ue(:,1),0.5*ones(n_np,1);kk,ue(:,2),0.5*ones(n_np,1)];
prol2=sparse(ind(:,1),ind(:,2),ind(:,3),n_np,np);
prol=[speye(np);prol2];
end

%prolongation operator pcw. const
if nargout>4
prol2=repmat(speye(nt),4,1);
end


function [te,ued,bed]=makeedgelist(t,e)
%% make list of all edges
ed=[t(1,:),t(2,:),t(3,:);...
    t(2,:),t(3,:),t(1,:)];
sed=sort(ed);
[ued,ie,je]=unique(sed','rows'); 
ued=ued';

%% triangle to edge list
ned=size(ed,2);
te=reshape(je,ned/3,3)';

%% find boundary edges
ed=sort(e(1:2,:));
[b,i,j]=unique([ed';ued'],'rows');
bed=j(1:size(ed,2))'; 

