function [pn,tn,prol_pcw_lin,prol_pcw_const]=refine_sphere_mesh(p,t,radius,project)

np=size(p,2);

% make unique edges 
ed=[t(1,:),t(2,:),t(3,:);...
    t(2,:),t(3,:),t(1,:)];
sed=sort(ed);
[ue,ie,je]=unique(sed','rows'); 
ue=ue';

%% triangle to edge list
ned=size(ed,2);
te=reshape(je,ned/3,3)';

% create new points at edge midpoints
pn = 0.5*(p(:,ue(1,:))+p(:,ue(2,:)));
if project
    % project new points back to sphere
    len= sqrt(pn(1,:).^2+pn(2,:).^2+pn(3,:).^2);
    pn = pn./repmat(len/radius,3,1); 
end
pn=[p,pn];
npn=size(pn,2);

% create elements
te=te+np;
nt=size(t,2);
% tn=zeros(size(t,1),4*nt);

ind=[];
if size(t,1)>3
    ind=t(4:end,:);
end
tn=[ t(1,:),  t(2,:),  t(3,:), te(1,:); ...
    te(1,:), te(2,:), te(3,:), te(2,:); ...
    te(3,:), te(1,:), te(2,:), te(3,:); ...
    ind,      ind,    ind,      ind];

ind=reshape(reshape(1:4*nt,nt,4)',1,4*nt);
tn=tn(:,ind);

% %prolongation operator pcw. linear
if nargout>2
    % hat functions
    a1=[1,0,0;1/2,1/2,0;1/2,0,1/2];
    a2=[0,1,0;0,1/2,1/2;1/2,1/2,0];
    a3=[0,0,1;1/2,0,1/2;0,1/2,1/2];
    a4=[1/2,1/2,0;0,1/2,1/2;1/2,0,1/2];
    prol_pcw_lin=kron(speye(nt),[a1;a2;a3;a4]);
    % basis s1 s2 s3 -> just copy values
%     prol_pcw_lin=kron(speye(nt),repmat(speye(3),4,1)); % only s1,s2,s3
%     prol_pcw_lin=kron(speye(nt),repmat(speye(4),4,1)); % 1, s1, s2, s3
end
% %prolongation operator pcw. const
if nargout>3
prol_pcw_const=kron(speye(nt),ones(4,1));%repmat(speye(nt),4,1);
end
