function u=multigrid(geom,A,u,f,sm)
% MULTIGRID solves a linear equation for Au=f using a V-cycle:
% for iter=1:maxIter
%   u=multigrid(geom,A,u,f,sm);
% % check convergence
% end
%   geom is a geometry structure containing
%     p   the points         (optional)
%     e   the edges          (optional)
%     t   the triangles      (optional)
%     parent    parentmesh
%     level     mesh level. For level == 0 a direct solver u=A\f is used.
%     P   prolongation
%   sm number of pre and post smoothing steps.

if geom.level==0 % direct solve on lowest level
    u=A\f;
    return
else
    %pre smoothing: Gauss-Seidel
    for i=1:sm
        r  = A*u - f;
        du = tril(A)\r;
        u  = u - du;
    end
    
    % solve (approximately) correction equation on coarser grid: (P'*A*P)*du = P'*r
    du = multigrid(geom.parent,geom.P'*A*geom.P,0*(geom.P'*u),geom.P'*(A*u-f),sm);
    
    % apply correction
    u  = u - geom.P*du;
   
    %post smoothing: Gauss-Seidel (symmetric)
    for i=1:sm
        r  = A*u - f;
        du = triu(A)\r;
        u = u - du;
    end
end
end