function [ip,w]=int_rule_tri(precision,order)
% see https://people.sc.fsu.edu/~jburkardt/datasets/quadrature_rules_tri/quadrature_rules_tri.html

% implemented combinations for
% precision order
% 1,1 centroid
% 2,3 Strang1
% 3,4 Strang3
% 3,6 Strang4
% 3,7 Seven point
% 4,6 Strang 5
% 5,7 STRANG7
% 6,9 STRANG8
% 7,13 STRANG10
% 7,16 Gauss 4x4 not taken as the weights are only accuracte up to 1e-10..
% 8,19 TOMS584_19
% 9,19 TOMS612_19
% 11,28 TOMS612_28
% 13,37 TOMS706_37
% 15,64 GAUSS8X8

% implemented rules
impl=[1,2,3,3,3,4,5,6, 7, 8, 9,11,13,15;
      1,3,4,6,7,6,7,9,13,19,19,28,37,64];
if isempty(precision),precision=1;end
if nargin<2 || isempty(order)
    [~,j]=ismember(precision,impl(1,:));
    order=impl(2,j);
end

if sum(ismember(precision,impl(1,:)).*ismember(order,impl(2,:)))==0
    disp('No adequate integration rule. Centroid rule is chosen with order=precision=1');
    precision=1;
    order=1;
end

if precision==1 & order==1
    % CENTROID, the centroid rule, order 1, degree of precision 1.
    ip=[1/3, 1/3];
    w=1/2;
elseif precision == 2 & order==3
    %STRANG1, order 3, degree of precision 2.
    ip=[1/6, 1/6; ...
        2/3, 1/6; ...
        1/6, 2/3];
    
    w=[1/6; 1/6; 1/6];
elseif precision ==3 & order ==4
    %STRANG3, order 4, degree of precision 3.
    ip=[   0.33333333333333333333  0.33333333333333333333
        0.60000000000000000000  0.20000000000000000000
        0.20000000000000000000  0.60000000000000000000
        0.20000000000000000000  0.20000000000000000000];
    w=0.5*[-0.56250000000000000000
        0.52083333333333333333
        0.52083333333333333333
        0.52083333333333333333];
elseif precision == 3 & order == 6
    %STRANG4, order 6, degree of precision 3.
    ip=[  0.659027622374092  0.231933368553031
        0.659027622374092  0.109039009072877
        0.231933368553031  0.659027622374092
        0.231933368553031  0.109039009072877
        0.109039009072877  0.659027622374092
        0.109039009072877  0.231933368553031];
    w=1/12*ones(size(ip,1),1);
elseif precision == 3  & order==7
    %SEVEN_POINT, order 7, degree of precision 3.
    ip=[ 0.33333333333333333333  0.33333333333333333333
        1.00000000000000000000  0.00000000000000000000
        0.00000000000000000000  1.00000000000000000000
        0.00000000000000000000  0.00000000000000000000
        0.00000000000000000000  0.50000000000000000000
        0.50000000000000000000  0.00000000000000000000
        0.50000000000000000000  0.50000000000000000000];
    w=0.5*[  0.4500000000000000
        0.0500000000000000
        0.0500000000000000
        0.0500000000000000
        0.1333333333333333
        0.1333333333333333
        0.1333333333333333];
elseif precision == 4 & order==6
    % STRANG5, order 6, degree of precision 4.
    ip=[0.816847572980459, 0.091576213509771;
        0.091576213509771, 0.816847572980459;
        0.091576213509771, 0.091576213509771;
        0.108103018168070, 0.445948490915965;
        0.445948490915965, 0.108103018168070;
        0.445948490915965, 0.445948490915965];
    
    w=0.5*[0.109951743655322;
        0.109951743655322;
        0.109951743655322;
        0.223381589678011;
        0.223381589678011;
        0.223381589678011];
elseif precision==5 & order ==7
    % STRANG7, order 7, degree of precision 5.
    ip=[  0.33333333333333333  0.33333333333333333
        0.79742698535308720  0.10128650732345633
        0.10128650732345633  0.79742698535308720
        0.10128650732345633  0.10128650732345633
        0.05971587178976981  0.47014206410511505
        0.47014206410511505  0.05971587178976981
        0.47014206410511505  0.47014206410511505];
    w=0.5*[  0.22500000000000000
        0.12593918054482717
        0.12593918054482717
        0.12593918054482717
        0.13239415278850616
        0.13239415278850616
        0.13239415278850616];
elseif precision==6 & order ==9
    %STRANG8, order 9, degree of precision 6.
    ip=[  0.124949503233232  0.437525248383384
        0.437525248383384  0.124949503233232
        0.437525248383384  0.437525248383384
        0.797112651860071  0.165409927389841
        0.797112651860071  0.037477420750088
        0.165409927389841  0.797112651860071
        0.165409927389841  0.037477420750088
        0.037477420750088  0.797112651860071
        0.037477420750088  0.165409927389841];
    w=0.5*[  0.205950504760887
        0.205950504760887
        0.205950504760887
        0.063691414286223
        0.063691414286223
        0.063691414286223
        0.063691414286223
        0.063691414286223
        0.063691414286223];
elseif precision==7 & order==13
    % STRANG10, order 13, degree of precision 7.
    ip= [ 0.333333333333333  0.333333333333333
        0.479308067841923  0.260345966079038
        0.260345966079038  0.479308067841923
        0.260345966079038  0.260345966079038
        0.869739794195568  0.065130102902216
        0.065130102902216  0.869739794195568
        0.065130102902216  0.065130102902216
        0.638444188569809  0.312865496004875
        0.638444188569809  0.048690315425316
        0.312865496004875  0.638444188569809
        0.312865496004875  0.048690315425316
        0.048690315425316  0.638444188569809
        0.048690315425316  0.312865496004875];
    w=0.5*[ -0.149570044467670
        0.175615257433204
        0.175615257433204
        0.175615257433204
        0.053347235608839
        0.053347235608839
        0.053347235608839
        0.077113760890257
        0.077113760890257
        0.077113760890257
        0.077113760890257
        0.077113760890257
        0.077113760890257];
elseif precision==8 & order==19
    % TOMS584_19, order 19, degree of precision 8, a rule from ACM TOMS algorithm #584.
    ip=[  0.3333333333333333  0.3333333333333333
        0.7974269853530872  0.1012865073234563
        0.1012865073234563  0.7974269853530872
        0.1012865073234563  0.1012865073234563
        0.0597158717897698  0.4701420641051151
        0.4701420641051151  0.0597158717897698
        0.4701420641051151  0.4701420641051151
        0.5357953464498992  0.2321023267750504
        0.2321023267750504  0.5357953464498992
        0.2321023267750504  0.2321023267750504
        0.9410382782311209  0.0294808608844396
        0.0294808608844396  0.9410382782311209
        0.0294808608844396  0.0294808608844396
        0.7384168123405100  0.2321023267750504
        0.7384168123405100  0.0294808608844396
        0.2321023267750504  0.7384168123405100
        0.2321023267750504  0.0294808608844396
        0.0294808608844396  0.7384168123405100
        0.0294808608844396  0.2321023267750504];
    w=0.5*[  0.0378610912003147
        0.0376204254131829
        0.0376204254131829
        0.0376204254131829
        0.0783573522441174
        0.0783573522441174
        0.0783573522441174
        0.1162714796569659
        0.1162714796569659
        0.1162714796569659
        0.0134442673751655
        0.0134442673751655
        0.0134442673751655
        0.0375097224552317
        0.0375097224552317
        0.0375097224552317
        0.0375097224552317
        0.0375097224552317
        0.0375097224552317];
elseif precision==9 & order == 19
    % TOMS612_19, order 19, degree of precision 9, a rule from ACM TOMS algorithm #612.
    ip=[  0.33333333333333331       0.33333333333333331
        2.06349616025259287E-002  0.48968251919873701
        0.48968251919873701       2.06349616025259287E-002
        0.48968251919873701       0.48968251919873701
        0.12582081701412900       0.43708959149293553
        0.43708959149293553       0.12582081701412900
        0.43708959149293553       0.43708959149293553
        0.62359292876193562       0.18820353561903219
        0.18820353561903219       0.62359292876193562
        0.18820353561903219       0.18820353561903219
        0.91054097321109406       4.47295133944529688E-002
        4.47295133944529688E-002  0.91054097321109406
        4.47295133944529688E-002  4.47295133944529688E-002
        0.74119859878449801       3.68384120547362581E-002
        0.74119859878449801       0.22196298916076573
        3.68384120547362581E-002  0.74119859878449801
        3.68384120547362581E-002  0.22196298916076573
        0.22196298916076573       0.74119859878449801
        0.22196298916076573       3.68384120547362581E-002];
    w=0.5*[  9.71357962827961025E-002
        3.13347002271398278E-002
        3.13347002271398278E-002
        3.13347002271398278E-002
        7.78275410047754301E-002
        7.78275410047754301E-002
        7.78275410047754301E-002
        7.96477389272090969E-002
        7.96477389272090969E-002
        7.96477389272090969E-002
        2.55776756586981006E-002
        2.55776756586981006E-002
        2.55776756586981006E-002
        4.32835393772893970E-002
        4.32835393772893970E-002
        4.32835393772893970E-002
        4.32835393772893970E-002
        4.32835393772893970E-002
        4.32835393772893970E-002];
elseif precision==11 & order==28
    %TOMS612_28, order 28, degree of precision 11, a rule from ACM TOMS algorithm #612.
    ip=[  0.33333333333333333  0.333333333333333333
        0.9480217181434233   0.02598914092828833
        0.02598914092828833  0.9480217181434233
        0.02598914092828833  0.02598914092828833
        0.8114249947041546   0.09428750264792270
        0.09428750264792270  0.8114249947041546
        0.09428750264792270  0.09428750264792270
        0.01072644996557060  0.4946367750172147
        0.4946367750172147   0.01072644996557060
        0.4946367750172147   0.4946367750172147
        0.5853132347709715   0.2073433826145142
        0.2073433826145142   0.5853132347709715
        0.2073433826145142   0.2073433826145142
        0.1221843885990187   0.4389078057004907
        0.4389078057004907   0.1221843885990187
        0.4389078057004907   0.4389078057004907
        0.6779376548825902   0.04484167758913055
        0.6779376548825902   0.27722066752827925
        0.04484167758913055  0.6779376548825902
        0.04484167758913055  0.27722066752827925
        0.27722066752827925  0.6779376548825902
        0.27722066752827925  0.04484167758913055
        0.8588702812826364   0.00000000000000000
        0.8588702812826364   0.1411297187173636
        0.0000000000000000   0.8588702812826364
        0.0000000000000000   0.1411297187173636
        0.1411297187173636   0.8588702812826364
        0.1411297187173636   0.0000000000000000];
    
    w= 0.5*[0.08797730116222190
        0.008744311553736190
        0.008744311553736190
        0.008744311553736190
        0.03808157199393533
        0.03808157199393533
        0.03808157199393533
        0.01885544805613125
        0.01885544805613125
        0.01885544805613125
        0.07215969754474100
        0.07215969754474100
        0.07215969754474100
        0.06932913870553720
        0.06932913870553720
        0.06932913870553720
        0.04105631542928860
        0.04105631542928860
        0.04105631542928860
        0.04105631542928860
        0.04105631542928860
        0.04105631542928860
        0.007362383783300573
        0.007362383783300573
        0.007362383783300573
        0.007362383783300573
        0.007362383783300573
        0.007362383783300573];
elseif precision==13 & order==37
    %TOMS706_37, order 37, degree of precision 13, a rule from ACM TOMS algorithm #706.
    ip=  [0.333333333333333333333333333333,  0.333333333333333333333333333333;
        0.950275662924105565450352089520,  0.024862168537947217274823955239;
        0.024862168537947217274823955239,  0.950275662924105565450352089520;
        0.024862168537947217274823955239,  0.024862168537947217274823955239;
        0.171614914923835347556304795551,  0.414192542538082326221847602214;
        0.414192542538082326221847602214,  0.171614914923835347556304795551;
        0.414192542538082326221847602214,  0.414192542538082326221847602214;
        0.539412243677190440263092985511,  0.230293878161404779868453507244;
        0.230293878161404779868453507244,  0.539412243677190440263092985511;
        0.230293878161404779868453507244,  0.230293878161404779868453507244;
        0.772160036676532561750285570113,  0.113919981661733719124857214943;
        0.113919981661733719124857214943,  0.772160036676532561750285570113;
        0.113919981661733719124857214943,  0.113919981661733719124857214943;
        0.009085399949835353883572964740,  0.495457300025082323058213517632;
        0.495457300025082323058213517632,  0.009085399949835353883572964740;
        0.495457300025082323058213517632,  0.495457300025082323058213517632;
        0.062277290305886993497083640527,  0.468861354847056503251458179727;
        0.468861354847056503251458179727,  0.062277290305886993497083640527;
        0.468861354847056503251458179727,  0.468861354847056503251458179727;
        0.022076289653624405142446876931,  0.851306504174348550389457672223;
        0.022076289653624405142446876931,  0.126617206172027096933163647918;
        0.851306504174348550389457672223,  0.022076289653624405142446876931;
        0.851306504174348550389457672223,  0.126617206172027096933163647918;
        0.126617206172027096933163647918,  0.022076289653624405142446876931;
        0.126617206172027096933163647918,  0.851306504174348550389457672223;
        0.018620522802520968955913511549,  0.689441970728591295496647976487;
        0.018620522802520968955913511549,  0.291937506468887771754472382212;
        0.689441970728591295496647976487,  0.018620522802520968955913511549;
        0.689441970728591295496647976487,  0.291937506468887771754472382212;
        0.291937506468887771754472382212,  0.018620522802520968955913511549;
        0.291937506468887771754472382212,  0.689441970728591295496647976487;
        0.096506481292159228736516560903,  0.635867859433872768286976979827;
        0.096506481292159228736516560903,  0.267625659273967961282458816185;
        0.635867859433872768286976979827,  0.096506481292159228736516560903;
        0.635867859433872768286976979827,  0.267625659273967961282458816185;
        0.267625659273967961282458816185,  0.096506481292159228736516560903;
        0.267625659273967961282458816185,  0.635867859433872768286976979827];
    
    w=0.5*[0.051739766065744133555179145422;
        0.008007799555564801597804123460;
        0.008007799555564801597804123460;
        0.008007799555564801597804123460;
        0.046868898981821644823226732071;
        0.046868898981821644823226732071;
        0.046868898981821644823226732071;
        0.046590940183976487960361770070;
        0.046590940183976487960361770070;
        0.046590940183976487960361770070;
        0.031016943313796381407646220131;
        0.031016943313796381407646220131;
        0.031016943313796381407646220131;
        0.010791612736631273623178240136;
        0.010791612736631273623178240136;
        0.010791612736631273623178240136;
        0.032195534242431618819414482205;
        0.032195534242431618819414482205;
        0.032195534242431618819414482205;
        0.015445834210701583817692900053;
        0.015445834210701583817692900053;
        0.015445834210701583817692900053;
        0.015445834210701583817692900053;
        0.015445834210701583817692900053;
        0.015445834210701583817692900053;
        0.017822989923178661888748319485;
        0.017822989923178661888748319485;
        0.017822989923178661888748319485;
        0.017822989923178661888748319485;
        0.017822989923178661888748319485;
        0.017822989923178661888748319485;
        0.037038683681384627918546472190;
        0.037038683681384627918546472190;
        0.037038683681384627918546472190;
        0.037038683681384627918546472190;
        0.037038683681384627918546472190;
        0.037038683681384627918546472190];
elseif precision==15 & order ==64
    %     GAUSS8X8, order 64, degree of precision 15, (essentially a product of two 8 point 1D Gauss-Legendre rules).
    ip=     [ 0.9553660447100000  ,      0.8862103848242247E-03;
        0.9553660447100000    ,    0.4537789678039195E-02;
        0.9553660447100000    ,    0.1058868260117431E-01;
        0.9553660447100000    ,    0.1822327082910602E-01;
        0.9553660447100000    ,    0.2641068446089399E-01;
        0.9553660447100000    ,    0.3404527268882569E-01;
        0.9553660447100000    ,    0.4009616561196080E-01;
        0.9553660447100000    ,    0.4374774490517578E-01;
        0.8556337429600001    ,    0.2866402391985981E-02;
        0.8556337429600001    ,    0.1467724979327651E-01;
        0.8556337429600001    ,    0.3424855503358430E-01;
        0.8556337429600001    ,    0.5894224214571626E-01;
        0.8556337429600001    ,    0.8542401489428375E-01;
        0.8556337429600001    ,    0.1101177020064157    ;
        0.8556337429600001    ,    0.1296890072467235    ;
        0.8556337429600001    ,    0.1414998546480140    ;
        0.7131752428600000    ,    0.5694926133044352E-02;
        0.7131752428600000    ,    0.2916054411712861E-01;
        0.7131752428600000    ,    0.6804452564827500E-01;
        0.7131752428600000    ,    0.1171055801775613    ;
        0.7131752428600000    ,    0.1697191769624387    ;
        0.7131752428600000    ,    0.2187802314917250    ;
        0.7131752428600000    ,    0.2576642130228714    ;
        0.7131752428600000    ,    0.2811298310069557    ;
        0.5451866848000000    ,    0.9030351006711630E-02;
        0.5451866848000000    ,    0.4623939674940125E-01;
        0.5451866848000000    ,    0.1078970888004545    ;
        0.5451866848000000    ,    0.1856923986620134    ;
        0.5451866848000000    ,    0.2691209165379867    ;
        0.5451866848000000    ,    0.3469162263995455    ;
        0.5451866848000000    ,    0.4085739184505988    ;
        0.5451866848000000    ,    0.4457829641932884    ;
        0.3719321645800000    ,    0.1247033193690498E-01;
        0.3719321645800000    ,    0.6385362269957356E-01;
        0.3719321645800000    ,    0.1489989161403976    ;
        0.3719321645800000    ,    0.2564292182833579    ;
        0.3719321645800000    ,    0.3716386171366422    ;
        0.3719321645800000    ,    0.4790689192796024    ;
        0.3719321645800000    ,    0.5642142127204264    ;
        0.3719321645800000    ,    0.6155975034830951    ;
        0.2143084794000000    ,    0.1559996151584746E-01;
        0.2143084794000000    ,    0.7987871227492103E-01;
        0.2143084794000000    ,    0.1863925811641285    ;
        0.2143084794000000    ,    0.3207842387034378    ;
        0.2143084794000000    ,    0.4649072818965623    ;
        0.2143084794000000    ,    0.5992989394358715    ;
        0.2143084794000000    ,    0.7058128083250790    ;
        0.2143084794000000    ,    0.7700915590841526    ;
        0.9132360790000005E-01,    0.1804183496379599E-01;
        0.9132360790000005E-01,    0.9238218584838476E-01;
        0.9132360790000005E-01,    0.2155687489628060    ;
        0.9132360790000005E-01,    0.3709968314854498    ;
        0.9132360790000005E-01,    0.5376795606145502    ;
        0.9132360790000005E-01,    0.6931076431371940    ;
        0.9132360790000005E-01,    0.8162942062516152    ;
        0.9132360790000005E-01,    0.8906345571362040    ;
        0.1777991514999999E-01,    0.1950205026019779E-01;
        0.1777991514999999E-01,    0.9985913490381848E-01;
        0.1777991514999999E-01,    0.2330157982952792    ;
        0.1777991514999999E-01,    0.4010234473667467    ;
        0.1777991514999999E-01,    0.5811966374832533    ;
        0.1777991514999999E-01,    0.7492042865547208    ;
        0.1777991514999999E-01,    0.8823609499461815    ;
        0.1777991514999999E-01,    0.9627180345898023    ];
    
    w=0.5*[0.3335674062677772E-03;
        0.7327880811491046E-03;
        0.1033723454167925E-02;
        0.1195112498415193E-02;
        0.1195112498415193E-02;
        0.1033723454167925E-02;
        0.7327880811491046E-03;
        0.3335674062677772E-03;
        0.1806210919443461E-02;
        0.3967923151181667E-02;
        0.5597437146194232E-02;
        0.6471331443180639E-02;
        0.6471331443180639E-02;
        0.5597437146194232E-02;
        0.3967923151181667E-02;
        0.1806210919443461E-02;
        0.4599755803015752E-02;
        0.1010484287526739E-01;
        0.1425461651131868E-01;
        0.1648010431039818E-01;
        0.1648010431039818E-01;
        0.1425461651131868E-01;
        0.1010484287526739E-01;
        0.4599755803015752E-02;
        0.8017259531156730E-02;
        0.1761248886287915E-01;
        0.2484544071087993E-01;
        0.2872441038508419E-01;
        0.2872441038508419E-01;
        0.2484544071087993E-01;
        0.1761248886287915E-01;
        0.8017259531156730E-02;
        0.1073501897357062E-01;
        0.2358292149331603E-01;
        0.3326776143412911E-01;
        0.3846165753898425E-01;
        0.3846165753898425E-01;
        0.3326776143412911E-01;
        0.2358292149331603E-01;
        0.1073501897357062E-01;
        0.1138879740452669E-01;
        0.2501915606814251E-01;
        0.3529381699354388E-01;
        0.4080402900378691E-01;
        0.4080402900378691E-01;
        0.3529381699354388E-01;
        0.2501915606814251E-01;
        0.1138879740452669E-01;
        0.9223845391285393E-02;
        0.2026314273544469E-01;
        0.2858464328177232E-01;
        0.3304739223149761E-01;
        0.3304739223149761E-01;
        0.2858464328177232E-01;
        0.2026314273544469E-01;
        0.9223845391285393E-02;
        0.4509812715921713E-02;
        0.9907253959306707E-02;
        0.1397588340693756E-01;
        0.1615785427783403E-01;
        0.1615785427783403E-01;
        0.1397588340693756E-01;
        0.9907253959306707E-02;
        0.4509812715921713E-02];
end
end
