function [volume,volumeForm,ipMapped,w,ip] = get_vol_elem_curved(p,t,precision,order)
% calculates the volumes of each element
%   p is the points list
%   t is the triangle/element list. The triangles are assumed to be on the sphere
%
% (C) Matthias Schlottbom, 2011, 2019, 2021

nt=size(t,2);
if nargin<4, order=[];end
% load integration rule
if nargin<3
    precision = 13; %demanded precision of integration for polynomials
    order=37; % convergence order
end
[ip,w]=int_rule_tri(precision,order); %get integration rule, ip is no_ip x dim
lip=length(w); % number of integration points

ip=ip'; % 2 x lip, i.e. integration points are now in columns!

p1=p(1:3,t(1,:)); %first  node of element
p2=p(1:3,t(2,:)); %second node of element
p3=p(1:3,t(3,:)); %third  node of element
d1=p2-p1;
d2=p3-p1;

% in order to access integration points below
ind=repmat(1:nt,1,lip); % 1:nt 1:nt -> lip times

% map integration points to triangles for kernel evaluation
AA=[d1(:) d2(:)]; % transformation matrices below each other
BB=repmat(p1(:),1,lip); % offsets below each other x lip
ipMapped=AA*ip+BB; % integration points on each triangle below each other
ipMapped=reshape(ipMapped,3,nt*lip); % rearrange: all first ip, then all second etc
% ipMapped=permute(reshape(ipMapped,3,nt,lip),[1 3 2]); % rearrange: all first ip, then all second etc

lenIp=sqrt(sum(ipMapped.^2,1));
ipMapped=ipMapped./lenIp; % normalize, i.e., project to sphere

% compute volume form:
% sqrt(det(A'*A-(A'*s(l,i))*(A'*s(l,i))'))/|s(l,i)|^2
% for integration point l on triangle i: s(l,i)
% compute [u;v]=A'*s, where s is an integration point on a triangle
u=AA(:,1).*reshape(ipMapped,3*nt,lip); u=sum(reshape(u,3,nt*lip));
v=AA(:,2).*reshape(ipMapped,3*nt,lip); v=sum(reshape(v,3,nt*lip));
dux=(reshape(d1(:,ind),3,nt*lip)-u.*ipMapped)./lenIp; % x-derivative of transformation
duy=(reshape(d2(:,ind),3,nt*lip)-v.*ipMapped)./lenIp; % y-derivative of transformation
volumeForm= sqrt( sum(dux.^2,1).*sum(duy.^2,1)-sum(dux.*duy,1).^2); % =| ux x uy| length of cross product.
% volumeForm=sqrt((sum(d1(:,ind).^2)-u.^2).*(sum(d2(:,ind).^2)-v.^2)-(sum(d1(:,ind).*d2(:,ind))-u.*v).^2)./lenIp.^2;

volumeForm=reshape(volumeForm,nt,lip)';
volume=w'*volumeForm;
ipMapped=permute(reshape(ipMapped,3,nt,lip),[1 3 2]); % rearrange such that triangle index is the third dimension; now 3 x lip x nt
end