function vol = get_vol_elem(p,t)
% calculates the volumes of each element
%   p is the points list
%   t is the triangle/element list. The triangles can be embedded in R3
%
% (C) Matthias Schlottbom, 2011, 2019

if size(p,1)==2 %flat triangle: append 0
    p=[p;zeros(1,size(p,2))];
end
p1=p(1:3,t(1,:)); %first  node of element
p2=p(1:3,t(2,:)); %second node of element
p3=p(1:3,t(3,:)); %third  node of element
d1=p2-p1;
d2=p3-p1;
vol=0.5*sqrt(sum(d1.^2).*sum(d2.^2)-sum(d1.*d2).^2); % area of standard simplex = 0.5
end